/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.PossibleDsepCfci;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class Cfci
implements GraphSearch {
    private Graph graph;
    private SepsetMap sepset;
    private Knowledge knowledge = new Knowledge();
    private List<Node> variables = new ArrayList<Node>();
    private IndependenceTest independenceTest;
    private boolean changeFlag = true;
    private boolean completeRuleSetUsed = true;
    private boolean possibleDsepSearchDone = true;
    private int maxReachablePathLength = -1;
    private Set<Triple> allTriples;
    private Set<Triple> colliderTriples;
    private Set<Triple> noncolliderTriples;
    private Set<Triple> ambiguousTriples;
    private int depth = -1;
    private long elapsedTime;
    private TetradLogger logger = TetradLogger.getInstance();

    public Cfci(IndependenceTest independenceTest) {
        if (independenceTest == null || this.knowledge == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
    }

    public Cfci(IndependenceTest independenceTest, List<Node> searchVars) {
        if (independenceTest == null || this.knowledge == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
        HashSet<Node> remVars = new HashSet<Node>();
        for (Node node1 : this.variables) {
            boolean search = false;
            for (Node node2 : searchVars) {
                if (!node1.getName().equals(node2.getName())) continue;
                search = true;
            }
            if (search) continue;
            remVars.add(node1);
        }
        this.variables.removeAll(remVars);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public Graph search() {
        long beginTime = System.currentTimeMillis();
        this.logger.log("info", "Starting CFCI algorithm.");
        this.logger.log("info", "Independence test = " + this.independenceTest + ".");
        this.setMaxReachablePathLength(this.maxReachablePathLength);
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Node variable : this.variables) {
            nodes.add(variable);
        }
        this.graph = new EdgeListGraph(nodes);
        this.graph.fullyConnect(Endpoint.CIRCLE);
        Fas adj = new Fas(this.graph, this.independenceTest);
        adj.setKnowledge(this.getKnowledge());
        adj.setDepth(this.depth);
        this.graph = adj.search();
        this.sepset = adj.getSepsets();
        if (this.isPossibleDsepSearchDone()) {
            long time1 = System.currentTimeMillis();
            this.ruleR0(this.independenceTest, this.depth);
            long time2 = System.currentTimeMillis();
            this.logger.log("info", "Step C: " + (double)(time2 - time1) / 1000.0 + "s");
            long time3 = System.currentTimeMillis();
            PossibleDsepCfci possibleDSep = new PossibleDsepCfci(this.getGraph(), this.independenceTest, this.getAmbiguousTriples(), this.getSepset());
            possibleDSep.setDepth(this.getDepth());
            possibleDSep.setKnowledge(this.getKnowledge());
            possibleDSep.setMaxReachablePathLength(this.getMaxReachablePathLength());
            this.sepset = possibleDSep.search();
            long time4 = System.currentTimeMillis();
            this.logger.log("info", "Step D: " + (double)(time4 - time3) / 1000.0 + "s");
            this.graph.reorientAllWith(Endpoint.CIRCLE);
        }
        long time5 = System.currentTimeMillis();
        this.fciOrientbk(this.getKnowledge(), this.graph, this.variables);
        this.ruleR0(this.independenceTest, this.depth);
        long time6 = System.currentTimeMillis();
        this.logger.log("info", "Step CI C: " + (double)(time6 - time5) / 1000.0 + "s");
        this.doFinalOrientation();
        long endTime = System.currentTimeMillis();
        this.elapsedTime = endTime - beginTime;
        this.logger.log("graph", "Returning graph: " + this.graph);
        TetradLogger.getInstance().log("info", "\n\nElapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        TetradLogger.getInstance().log("info", "\nFinishing CFCI algorithm.");
        return this.graph;
    }

    public SepsetMap getSepset() {
        return this.sepset;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public Set<Triple> getColliderTriples() {
        return new HashSet<Triple>(this.colliderTriples);
    }

    public Set<Triple> getNoncolliderTriples() {
        return new HashSet<Triple>(this.noncolliderTriples);
    }

    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    private Graph getGraph() {
        return this.graph;
    }

    private void ruleR0(IndependenceTest test, int depth) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        this.allTriples = new HashSet<Triple>();
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        for (Node y : this.getGraph().getNodes()) {
            int[] combination;
            List<Node> adjacentNodes = this.getGraph().getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node x = adjacentNodes.get(combination[0]);
                Node z = adjacentNodes.get(combination[1]);
                if (this.getGraph().isAdjacentTo(x, z)) continue;
                this.allTriples.add(new Triple(x, y, z));
                TripleType type = this.getTripleType(x, y, z, test, depth);
                if (type == TripleType.COLLIDER) {
                    if (this.isArrowpointAllowed(x, y) && this.isArrowpointAllowed(z, y)) {
                        this.getGraph().setEndpoint(x, y, Endpoint.ARROW);
                        this.getGraph().setEndpoint(z, y, Endpoint.ARROW);
                        TetradLogger.getInstance().log("tripleClassifications", "Collider: " + Triple.pathString(this.graph, x, y, z));
                    }
                    this.colliderTriples.add(new Triple(x, y, z));
                    continue;
                }
                if (type == TripleType.NONCOLLIDER) {
                    this.noncolliderTriples.add(new Triple(x, y, z));
                    TetradLogger.getInstance().log("tripleClassifications", "Noncollider: " + Triple.pathString(this.graph, x, y, z));
                    continue;
                }
                Triple triple = new Triple(x, y, z);
                this.ambiguousTriples.add(triple);
                this.getGraph().addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
                TetradLogger.getInstance().log("tripleClassifications", "AmbiguousTriples: " + Triple.pathString(this.graph, x, y, z));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    private TripleType getTripleType(Node x, Node y, Node z, IndependenceTest test, int depth) {
        List<Node> condSet;
        int[] choice;
        ChoiceGenerator cg;
        int d;
        boolean existsSepsetContainingY = false;
        boolean existsSepsetNotContainingY = false;
        HashSet<Node> __nodes = new HashSet<Node>(this.getGraph().getAdjacentNodes(x));
        __nodes.remove(z);
        LinkedList<Node> _nodes = new LinkedList<Node>(__nodes);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = Math.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                condSet = Cfci.asList(choice, _nodes);
                if (!test.isIndependent(x, z, condSet)) continue;
                if (condSet.contains(y)) {
                    existsSepsetContainingY = true;
                    continue;
                }
                existsSepsetNotContainingY = true;
            }
        }
        __nodes = new HashSet<Node>(this.getGraph().getAdjacentNodes(z));
        __nodes.remove(x);
        _nodes = new LinkedList<Node>(__nodes);
        _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = Math.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                condSet = Cfci.asList(choice, _nodes);
                if (!test.isIndependent(x, z, condSet)) continue;
                if (condSet.contains(y)) {
                    existsSepsetContainingY = true;
                    continue;
                }
                existsSepsetNotContainingY = true;
            }
        }
        List<Node> condSet2 = this.getSepset().get(x, z);
        if (condSet2 != null) {
            if (condSet2.contains(y)) {
                existsSepsetContainingY = true;
            } else {
                existsSepsetNotContainingY = true;
            }
        }
        if (existsSepsetContainingY == existsSepsetNotContainingY) {
            return TripleType.AMBIGUOUS;
        }
        if (!existsSepsetNotContainingY) {
            return TripleType.NONCOLLIDER;
        }
        return TripleType.COLLIDER;
    }

    private static List<Node> asList(int[] indices, List<Node> nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        for (int i : indices) {
            list.add(nodes.get(i));
        }
        return list;
    }

    private void doFinalOrientation() {
        while (this.changeFlag) {
            this.changeFlag = false;
            this.ruleR3();
            this.rulesR1R2cycle();
            this.ruleR4();
        }
        if (this.isCompleteRuleSetUsed()) {
            do {
                this.changeFlag = false;
                this.rulesR8R9R10();
            } while (this.changeFlag);
        }
    }

    private void rulesR1R2cycle() {
        List<Node> nodes = this.graph.getNodes();
        for (Node B : nodes) {
            int[] combination;
            List<Node> adj = this.graph.getAdjacentNodes(B);
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null) {
                Node A = adj.get(combination[0]);
                Node C = adj.get(combination[1]);
                this.ruleR1(A, B, C);
                this.ruleR1(C, B, A);
                this.ruleR2(A, B, C);
                this.ruleR2(C, B, A);
            }
        }
    }

    private void ruleR1(Node a, Node b, Node c) {
        if (this.graph.isAdjacentTo(a, c)) {
            return;
        }
        if (!this.getNoncolliderTriples().contains(new Triple(a, b, c))) {
            return;
        }
        if (this.graph.getEndpoint(a, b) == Endpoint.ARROW && this.graph.getEndpoint(c, b) == Endpoint.CIRCLE) {
            if (!this.isArrowpointAllowed(b, c)) {
                return;
            }
            this.graph.setEndpoint(c, b, Endpoint.TAIL);
            this.graph.setEndpoint(b, c, Endpoint.ARROW);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Away from collider", this.graph.getEdge(b, c)));
        }
    }

    private void ruleR2(Node a, Node b, Node c) {
        if (!this.graph.isAdjacentTo(a, c)) {
            return;
        }
        if (this.graph.getEndpoint(b, a) == Endpoint.TAIL && this.graph.getEndpoint(a, b) == Endpoint.ARROW && this.graph.getEndpoint(b, c) == Endpoint.ARROW && this.graph.getEndpoint(a, c) == Endpoint.CIRCLE) {
            if (!this.isArrowpointAllowed(a, c)) {
                return;
            }
            this.graph.setEndpoint(a, c, Endpoint.ARROW);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Away from ancestor (a)", this.graph.getEdge(a, c)));
        } else if (this.graph.getEndpoint(a, b) == Endpoint.ARROW && this.graph.getEndpoint(c, b) == Endpoint.TAIL && this.graph.getEndpoint(b, c) == Endpoint.ARROW && this.graph.getEndpoint(a, c) == Endpoint.CIRCLE) {
            if (!this.isArrowpointAllowed(a, c)) {
                return;
            }
            this.graph.setEndpoint(a, c, Endpoint.ARROW);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Away from ancestor (b)", this.graph.getEdge(a, c)));
        }
    }

    private void ruleR3() {
        List<Node> nodes = this.graph.getNodes();
        for (Node b : nodes) {
            List<Node> intoBArrows = this.graph.getNodesInTo(b, Endpoint.ARROW);
            List<Node> intoBCircles = this.graph.getNodesInTo(b, Endpoint.CIRCLE);
            for (Node d : intoBCircles) {
                int[] choice;
                if (intoBArrows.size() < 2) continue;
                ChoiceGenerator gen = new ChoiceGenerator(intoBArrows.size(), 2);
                while ((choice = gen.next()) != null) {
                    Node c;
                    Node a = intoBArrows.get(choice[0]);
                    if (this.graph.isAdjacentTo(a, c = intoBArrows.get(choice[1])) || !this.graph.isAdjacentTo(a, d) || !this.graph.isAdjacentTo(c, d) || !this.getNoncolliderTriples().contains(new Triple(a, d, c)) || this.graph.getEndpoint(a, d) != Endpoint.CIRCLE || this.graph.getEndpoint(c, d) != Endpoint.CIRCLE || !this.isArrowpointAllowed(d, b)) continue;
                    this.graph.setEndpoint(d, b, Endpoint.ARROW);
                    this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Double triangle", this.graph.getEdge(d, b)));
                    this.changeFlag = true;
                }
            }
        }
    }

    private void ruleR4() {
        List<Node> nodes = this.graph.getNodes();
        for (Node b : nodes) {
            List<Node> possA = this.graph.getNodesOutTo(b, Endpoint.ARROW);
            List<Node> possC = this.graph.getNodesInTo(b, Endpoint.CIRCLE);
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!this.graph.isParentOf(a, c)) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    this.reachablePathFind(a, b, c, reachable);
                }
            }
        }
    }

    private void reachablePathFind(Node a, Node b, Node c, LinkedList<Node> reachable) {
        HashSet<Node> cParents = new HashSet<Node>(this.graph.getParents(c));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            List<Node> pathExtensions = this.graph.getNodesInTo(x, Endpoint.ARROW);
            pathExtensions.removeAll(visited);
            for (Node d : pathExtensions) {
                if (!this.graph.isAdjacentTo(d, c)) {
                    this.doDdpOrientation(d, a, b, c);
                    return;
                }
                if (!cParents.contains(d) || this.graph.getEndpoint(x, d) != Endpoint.ARROW) continue;
                reachable.add(d);
            }
        }
    }

    private void doDdpOrientation(Node d, Node a, Node b, Node c) {
        List<Node> sepset = this.sepset.get(d, c);
        System.out.println("in doDdpOrientation");
        if (sepset == null) {
            throw new IllegalArgumentException("The edge from d to c must have been removed at this point.");
        }
        TripleType dbc = this.getTripleType(d, b, c, this.independenceTest, this.depth);
        System.out.println("Triple<" + d + ", " + b + ", " + c + "> = " + (Object)((Object)dbc));
        if (dbc == TripleType.NONCOLLIDER) {
            System.out.println("DDP orientation: " + c + " *-- " + b);
            this.graph.setEndpoint(c, b, Endpoint.TAIL);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Definite discriminating path d = " + d, this.graph.getEdge(b, c)));
            this.changeFlag = true;
        } else if (dbc == TripleType.COLLIDER) {
            if (!this.isArrowpointAllowed(a, b)) {
                return;
            }
            if (!this.isArrowpointAllowed(c, b)) {
                return;
            }
            this.graph.setEndpoint(a, b, Endpoint.ARROW);
            this.graph.setEndpoint(c, b, Endpoint.ARROW);
            this.logger.log("colliderOrientations", SearchLogUtils.colliderOrientedMsg("Definite discriminating path.. d = " + d, a, b, c));
            this.changeFlag = true;
        }
    }

    private void ruleR5() {
        List<Node> nodes = this.graph.getNodes();
        for (Node a : nodes) {
            List<Node> adjacents = this.graph.getNodesInTo(a, Endpoint.CIRCLE);
            for (Node b : adjacents) {
                if (this.graph.getEndpoint(a, b) != Endpoint.CIRCLE) continue;
                List<List<Node>> ucCirclePaths = this.getUcCirclePaths(a, b);
                System.out.println("Circle paths:");
                for (List<Node> path : ucCirclePaths) {
                    System.out.println(GraphUtils.pathString(this.graph, path));
                }
                for (List<Node> u : ucCirclePaths) {
                    if (u.size() < 3) continue;
                    Node c = u.get(1);
                    Node d = u.get(u.size() - 2);
                    System.out.println("a = " + a + " c = " + c + " d = " + d + " b = " + b);
                    if (this.graph.isAdjacentTo(a, d) || this.graph.isAdjacentTo(b, c) || !this.getNoncolliderTriples().contains(new Triple(c, a, b)) || !this.getNoncolliderTriples().contains(new Triple(a, b, d))) continue;
                    ArrayList<Node> u2 = new ArrayList<Node>();
                    u2.add(a);
                    u2.addAll(u);
                    u2.add(b);
                    for (int i = 2; i < u2.size(); ++i) {
                        if (this.getNoncolliderTriples().contains(new Triple((Node)u2.get(i - 2), (Node)u2.get(i - 1), (Node)u2.get(i)))) continue;
                    }
                    this.logger.log("colliderOrientations", SearchLogUtils.edgeOrientedMsg("Orient circle path", this.graph.getEdge(a, b)));
                    this.graph.setEndpoint(a, b, Endpoint.TAIL);
                    this.graph.setEndpoint(b, a, Endpoint.TAIL);
                    this.orientTailPath(u);
                    this.changeFlag = true;
                }
            }
        }
    }

    private void ruleR6R7() {
        List<Node> nodes = this.graph.getNodes();
        for (Node b : nodes) {
            List<Node> adjacents = this.graph.getAdjacentNodes(b);
            if (adjacents.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacents.size(), 2);
            int[] choice = cg.next();
            while (choice != null) {
                Node c;
                Node a = adjacents.get(choice[0]);
                if (!this.graph.isAdjacentTo(a, c = adjacents.get(choice[1])) && this.graph.getEndpoint(b, a) == Endpoint.TAIL && this.graph.getEndpoint(c, b) == Endpoint.CIRCLE) {
                    if (this.graph.getEndpoint(a, b) == Endpoint.TAIL) {
                        System.out.println("Single tails (tail) " + c + " *-> " + b);
                        this.graph.setEndpoint(c, b, Endpoint.TAIL);
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Single tails (tail)", this.graph.getEdge(c, b)));
                        this.changeFlag = true;
                    }
                    if (this.graph.getEndpoint(a, b) == Endpoint.CIRCLE && this.getNoncolliderTriples().contains(new Triple(a, b, c))) {
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Single tails (tail)", this.graph.getEdge(c, b)));
                        this.graph.setEndpoint(c, b, Endpoint.TAIL);
                        this.changeFlag = true;
                    }
                }
                choice = cg.next();
            }
        }
    }

    private void rulesR8R9R10() {
        List<Node> nodes = this.graph.getNodes();
        for (Node c : nodes) {
            List<Node> intoCArrows = this.graph.getNodesInTo(c, Endpoint.ARROW);
            for (Node a : intoCArrows) {
                if (this.graph.getEndpoint(c, a) != Endpoint.CIRCLE || this.ruleR8(a, c) || this.ruleR9(a, c)) continue;
                this.ruleR10(a, c);
            }
        }
    }

    private void orientTailPath(List<Node> path) {
        for (int i = 0; i < path.size() - 1; ++i) {
            Node n1 = path.get(i);
            Node n2 = path.get(i + 1);
            System.out.println("Tail path " + n1 + "---" + n2);
            this.graph.setEndpoint(n1, n2, Endpoint.TAIL);
            this.graph.setEndpoint(n2, n1, Endpoint.TAIL);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Orient circle paths", this.graph.getEdge(n1, n2)));
        }
    }

    private List<List<Node>> getUcPdPaths(Node n1, Node n2) {
        LinkedList<List<Node>> ucPdPaths = new LinkedList<List<Node>>();
        LinkedList<Node> soFar = new LinkedList<Node>();
        soFar.add(n1);
        List<Node> adjacencies = this.graph.getAdjacentNodes(n1);
        for (Node curr : adjacencies) {
            this.getUcPdPsHelper(curr, soFar, n2, ucPdPaths);
        }
        return ucPdPaths;
    }

    private void getUcPdPsHelper(Node curr, List<Node> soFar, Node end, List<List<Node>> ucPdPaths) {
        Node prev2;
        if (soFar.contains(curr)) {
            return;
        }
        Node prev = soFar.get(soFar.size() - 1);
        if (this.graph.getEndpoint(prev, curr) == Endpoint.TAIL || this.graph.getEndpoint(curr, prev) == Endpoint.ARROW) {
            return;
        }
        if (soFar.size() >= 2 && this.graph.isAdjacentTo(prev2 = soFar.get(soFar.size() - 2), curr)) {
            return;
        }
        soFar.add(curr);
        if (((Object)curr).equals(end)) {
            ucPdPaths.add(new LinkedList<Node>(soFar));
        } else {
            List<Node> adjacents = this.graph.getAdjacentNodes(curr);
            for (Node next : adjacents) {
                this.getUcPdPsHelper(next, soFar, end, ucPdPaths);
            }
        }
        soFar.remove(soFar.get(soFar.size() - 1));
    }

    private List<List<Node>> getUcCirclePaths(Node n1, Node n2) {
        LinkedList<List<Node>> ucCirclePaths = new LinkedList<List<Node>>();
        List<List<Node>> ucPdPaths = this.getUcPdPaths(n1, n2);
        for (List<Node> path : ucPdPaths) {
            Node sj;
            Node j;
            for (int i = 0; i < path.size() - 1 && this.graph.getEndpoint(j = path.get(i), sj = path.get(i + 1)) == Endpoint.CIRCLE && this.graph.getEndpoint(sj, j) == Endpoint.CIRCLE; ++i) {
                if (i != path.size() - 2) continue;
                ucCirclePaths.add(path);
            }
        }
        return ucCirclePaths;
    }

    private boolean ruleR8(Node a, Node c) {
        List<Node> intoCArrows = this.graph.getNodesInTo(c, Endpoint.ARROW);
        for (Node b : intoCArrows) {
            if (!this.graph.isAdjacentTo(a, b) || !this.graph.isAdjacentTo(b, c) || this.graph.getEndpoint(b, a) != Endpoint.TAIL || this.graph.getEndpoint(c, b) != Endpoint.TAIL || this.graph.getEndpoint(a, b) == Endpoint.TAIL) continue;
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("R8", this.graph.getEdge(c, a)));
            this.graph.setEndpoint(c, a, Endpoint.TAIL);
            this.changeFlag = true;
            return true;
        }
        return false;
    }

    private boolean ruleR9(Node a, Node c) {
        List<List<Node>> ucPdPsToC = this.getUcPdPaths(a, c);
        block0: for (List<Node> u : ucPdPsToC) {
            Node b = u.get(1);
            if (this.graph.isAdjacentTo(b, c) || b == c) continue;
            for (int i = 2; i < u.size(); ++i) {
                if (!this.getNoncolliderTriples().contains(new Triple(u.get(i - 2), u.get(i - 1), u.get(i)))) continue block0;
            }
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("R9", this.graph.getEdge(c, a)));
            this.graph.setEndpoint(c, a, Endpoint.TAIL);
            this.changeFlag = true;
            return true;
        }
        return false;
    }

    private boolean ruleR10(Node a, Node c) {
        List<Node> intoCArrows = this.graph.getNodesInTo(c, Endpoint.ARROW);
        for (Node b : intoCArrows) {
            if (b == a || this.graph.getEndpoint(c, b) != Endpoint.TAIL) continue;
            for (Node d : intoCArrows) {
                if (d == a || d == b || this.graph.getEndpoint(d, c) != Endpoint.TAIL) continue;
                List<List<Node>> ucPdPsToB = this.getUcPdPaths(a, b);
                List<List<Node>> ucPdPsToD = this.getUcPdPaths(a, d);
                block2: for (List<Node> u1 : ucPdPsToB) {
                    Node m = u1.get(1);
                    for (List<Node> u2 : ucPdPsToD) {
                        int i;
                        Node n = u2.get(1);
                        for (i = 2; i < u1.size(); ++i) {
                            if (!this.getNoncolliderTriples().contains(new Triple(u1.get(i - 2), u1.get(i - 1), u1.get(i)))) continue block2;
                        }
                        for (i = 2; i < u2.size(); ++i) {
                            if (!this.getNoncolliderTriples().contains(new Triple(u2.get(i - 2), u2.get(i - 1), u2.get(i)))) continue block2;
                        }
                        if (((Object)m).equals(n) || this.graph.isAdjacentTo(m, n)) continue;
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("R10", this.graph.getEdge(c, a)));
                        this.graph.setEndpoint(c, a, Endpoint.TAIL);
                        this.changeFlag = true;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void fciOrientbk(Knowledge bk, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        this.logger.log("info", "Starting BK Orientation.");
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
            this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.TAIL);
            graph.setEndpoint(from, to, Endpoint.ARROW);
            this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        this.logger.log("info", "Finishing BK Orientation.");
    }

    private boolean isArrowpointAllowed(Node x, Node y) {
        if (this.graph.getEndpoint(x, y) == Endpoint.ARROW) {
            return true;
        }
        if (this.graph.getEndpoint(x, y) == Endpoint.TAIL) {
            return false;
        }
        if (this.graph.getEndpoint(y, x) == Endpoint.ARROW && this.graph.getEndpoint(x, y) == Endpoint.CIRCLE) {
            return true;
        }
        return !this.knowledge.isForbiddenByTiers(x.getName(), y.getName());
    }

    public boolean isPossibleDsepSearchDone() {
        return this.possibleDsepSearchDone;
    }

    public void setPossibleDsepSearchDone(boolean possibleDsepSearchDone) {
        this.possibleDsepSearchDone = possibleDsepSearchDone;
    }

    public int getMaxReachablePathLength() {
        return this.maxReachablePathLength == Integer.MAX_VALUE ? -1 : this.maxReachablePathLength;
    }

    public void setMaxReachablePathLength(int maxReachablePathLength) {
        if (maxReachablePathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxReachablePathLength);
        }
        this.maxReachablePathLength = maxReachablePathLength == -1 ? Integer.MAX_VALUE : maxReachablePathLength;
    }

    private static enum TripleType {
        COLLIDER,
        NONCOLLIDER,
        AMBIGUOUS;

    }
}

