/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.PossibleDsepCfci;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class Cfci_myOld {
    private Graph graph;
    private SepsetMap sepset = new SepsetMap();
    private Knowledge knowledge = new Knowledge();
    private IndependenceTest independenceTest;
    private boolean changeFlag = true;
    private boolean completeRuleSetUsed = true;
    private boolean possibleDsepSearchDone = true;
    private int maxReachablePathLength = -1;
    private Set<Triple> allTriples;
    private Set<Triple> colliderTriples;
    private Set<Triple> noncolliderTriples;
    private Set<Triple> ambiguousTriples;
    private int depth = -1;
    private long elapsedTime;
    private TetradLogger logger = TetradLogger.getInstance();

    public Cfci_myOld(IndependenceTest independenceTest) {
        if (independenceTest == null || this.knowledge == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
    }

    private int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0: " + depth);
        }
        if (depth == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Disallowing Integer.MAX_INT because of an apparent bug.");
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Graph search() {
        long beginTime = System.currentTimeMillis();
        TetradLogger.getInstance().log("info", "Starting CFCI algorithm.");
        TetradLogger.getInstance().log("info", "Independence test = " + this.independenceTest + ".");
        List<Node> variables = this.independenceTest.getVariables();
        LinkedList<Node> nodes = new LinkedList<Node>();
        this.allTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        for (Node variable : variables) {
            nodes.add(variable);
        }
        this.graph = new EdgeListGraph(nodes);
        this.getGraph().fullyConnect(Endpoint.CIRCLE);
        Fas fas = new Fas(this.graph, this.independenceTest);
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        fas.search();
        if (this.isPossibleDsepSearchDone()) {
            long time1 = System.currentTimeMillis();
            this.orientUnshieldedTriples(this.independenceTest, this.depth);
            long time2 = System.currentTimeMillis();
            TetradLogger.getInstance().log("info", "Step C: " + (double)(time2 - time1) / 1000.0 + "s");
            long time3 = System.currentTimeMillis();
            PossibleDsepCfci possibleDSep = new PossibleDsepCfci(this.getGraph(), this.independenceTest, this.getAmbiguousTriples());
            possibleDSep.setDepth(this.getDepth());
            possibleDSep.setKnowledge(this.getKnowledge());
            this.sepset = possibleDSep.search();
            System.out.println("###### Num dsep removals = " + this.sepset.size());
            long time4 = System.currentTimeMillis();
            TetradLogger.getInstance().log("info", "Step D: " + (double)(time4 - time3) / 1000.0 + "s");
            this.getGraph().reorientAllWith(Endpoint.CIRCLE);
        }
        long time5 = System.currentTimeMillis();
        Cfci_myOld.fciOrientbk(this.getKnowledge(), this.getGraph(), this.independenceTest.getVariables());
        this.orientUnshieldedTriples(this.independenceTest, this.depth);
        long time6 = System.currentTimeMillis();
        TetradLogger.getInstance().log("info", "Step CI C: " + (double)(time6 - time5) / 1000.0 + "s");
        this.doFinalOrientation();
        long endTime = System.currentTimeMillis();
        this.elapsedTime = endTime - beginTime;
        this.logger.log("graph", "\nReturning this graph: " + this.graph);
        TetradLogger.getInstance().log("info", "\n\nElapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        TetradLogger.getInstance().log("info", "\nFinishing CFCI algorithm.");
        return this.getGraph();
    }

    private Knowledge getKnowledge() {
        return this.knowledge;
    }

    private Graph getGraph() {
        return this.graph;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public Set<Triple> getColliderTriples() {
        return new HashSet<Triple>(this.colliderTriples);
    }

    public Set<Triple> getNoncolliderTriples() {
        return new HashSet<Triple>(this.noncolliderTriples);
    }

    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    private SepsetMap getSepset() {
        return this.sepset;
    }

    private void orientUnshieldedTriples(IndependenceTest test, int depth) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        for (Node y : this.getGraph().getNodes()) {
            int[] combination;
            List<Node> adjacentNodes = this.getGraph().getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node x = adjacentNodes.get(combination[0]);
                Node z = adjacentNodes.get(combination[1]);
                if (this.getGraph().isAdjacentTo(x, z)) continue;
                this.allTriples.add(new Triple(x, y, z));
                TripleType type = this.getTripleType(x, y, z, test, depth);
                if (type == TripleType.COLLIDER) {
                    if (this.isArrowpointAllowed(x, y) && this.isArrowpointAllowed(z, y)) {
                        this.getGraph().setEndpoint(x, y, Endpoint.ARROW);
                        this.getGraph().setEndpoint(z, y, Endpoint.ARROW);
                        TetradLogger.getInstance().log("tripleClassifications", "Collider: " + Triple.pathString(this.graph, x, y, z));
                    }
                    this.colliderTriples.add(new Triple(x, y, z));
                    continue;
                }
                if (type == TripleType.NONCOLLIDER) {
                    this.noncolliderTriples.add(new Triple(x, y, z));
                    TetradLogger.getInstance().log("tripleClassifications", "Noncollider: " + Triple.pathString(this.graph, x, y, z));
                    continue;
                }
                Triple triple = new Triple(x, y, z);
                this.ambiguousTriples.add(triple);
                this.getGraph().addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
                TetradLogger.getInstance().log("tripleClassifications", "AmbiguousTriples: " + Triple.pathString(this.graph, x, y, z));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    private TripleType getTripleType(Node x, Node y, Node z, IndependenceTest test, int depth) {
        List<Node> condSet;
        int[] choice;
        ChoiceGenerator cg;
        int d;
        boolean existsSepsetContainingY = false;
        boolean existsSepsetNotContainingY = false;
        HashSet<Node> __nodes = new HashSet<Node>(this.getGraph().getAdjacentNodes(x));
        __nodes.remove(z);
        LinkedList<Node> _nodes = new LinkedList<Node>(__nodes);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = Math.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                condSet = Cfci_myOld.asList(choice, _nodes);
                if (!test.isIndependent(x, z, condSet)) continue;
                if (condSet.contains(y)) {
                    existsSepsetContainingY = true;
                    continue;
                }
                existsSepsetNotContainingY = true;
            }
        }
        __nodes = new HashSet<Node>(this.getGraph().getAdjacentNodes(z));
        __nodes.remove(x);
        _nodes = new LinkedList<Node>(__nodes);
        _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = Math.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                condSet = Cfci_myOld.asList(choice, _nodes);
                if (!test.isIndependent(x, z, condSet)) continue;
                if (condSet.contains(y)) {
                    existsSepsetContainingY = true;
                    continue;
                }
                existsSepsetNotContainingY = true;
            }
        }
        List<Node> condSet2 = this.getSepset().get(x, z);
        if (condSet2 != null) {
            if (condSet2.contains(y)) {
                existsSepsetContainingY = true;
            } else {
                existsSepsetNotContainingY = true;
            }
        }
        if (existsSepsetContainingY == existsSepsetNotContainingY) {
            return TripleType.AMBIGUOUS;
        }
        if (!existsSepsetNotContainingY) {
            return TripleType.NONCOLLIDER;
        }
        return TripleType.COLLIDER;
    }

    private static List<Node> asList(int[] indices, List<Node> nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        for (int i : indices) {
            list.add(nodes.get(i));
        }
        return list;
    }

    private void doFinalOrientation() {
        while (this.changeFlag) {
            this.changeFlag = false;
            this.ruleR3();
            this.rulesR1R2cycle();
            this.ruleR4();
        }
        if (this.isCompleteRuleSetUsed()) {
            do {
                this.changeFlag = false;
                this.rulesR8R9R10();
            } while (this.changeFlag);
        }
    }

    private void rulesR1R2cycle() {
        List<Node> nodes = this.getGraph().getNodes();
        for (Node B : nodes) {
            int[] combination;
            List<Node> adj = this.getGraph().getAdjacentNodes(B);
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null) {
                Node A = adj.get(combination[0]);
                Node C = adj.get(combination[1]);
                this.ruleR1(A, B, C);
                this.ruleR1(C, B, A);
                this.ruleR2(A, B, C);
                this.ruleR2(C, B, A);
            }
        }
    }

    private void ruleR1(Node a, Node b, Node c) {
        if (this.getGraph().isAdjacentTo(a, c)) {
            return;
        }
        if (this.getGraph().getEndpoint(a, b) == Endpoint.ARROW && this.getGraph().getEndpoint(c, b) == Endpoint.CIRCLE) {
            if (!this.isArrowpointAllowed(b, c)) {
                return;
            }
            if (!this.getNoncolliderTriples().contains(new Triple(a, b, c))) {
                return;
            }
            this.getGraph().setEndpoint(c, b, Endpoint.TAIL);
            this.getGraph().setEndpoint(b, c, Endpoint.ARROW);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Away from collider", this.graph.getEdge(b, c)));
        }
    }

    private void ruleR2(Node a, Node b, Node c) {
        if (!this.graph.isAdjacentTo(a, c)) {
            return;
        }
        if (this.getGraph().getEndpoint(b, a) == Endpoint.TAIL && this.getGraph().getEndpoint(a, b) == Endpoint.ARROW && this.getGraph().getEndpoint(b, c) == Endpoint.ARROW && this.getGraph().getEndpoint(a, c) == Endpoint.CIRCLE) {
            if (!this.isArrowpointAllowed(a, c)) {
                return;
            }
            this.getGraph().setEndpoint(a, c, Endpoint.ARROW);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Away from ancestor (a)", this.getGraph().getEdge(a, c)));
        } else if (this.getGraph().getEndpoint(a, b) == Endpoint.ARROW && this.getGraph().getEndpoint(c, b) == Endpoint.TAIL && this.getGraph().getEndpoint(b, c) == Endpoint.ARROW && this.getGraph().getEndpoint(a, c) == Endpoint.CIRCLE) {
            if (!this.isArrowpointAllowed(a, c)) {
                return;
            }
            this.getGraph().setEndpoint(a, c, Endpoint.ARROW);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Away from ancestor (b)", this.getGraph().getEdge(a, c)));
        }
    }

    private void awayFromCycle(Node a, Node b, Node c) {
        if (this.getGraph().isAdjacentTo(a, c) && this.getGraph().getEndpoint(a, c) == Endpoint.ARROW && this.getGraph().getEndpoint(c, a) == Endpoint.CIRCLE && this.getGraph().isDirectedFromTo(a, b) && this.getGraph().isDirectedFromTo(b, c)) {
            this.getGraph().setEndpoint(c, a, Endpoint.TAIL);
            TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Away from cycle", this.getGraph().getEdge(c, a)));
            this.changeFlag = true;
        }
    }

    private void ruleR3() {
        List<Node> nodes = this.getGraph().getNodes();
        for (Node B : nodes) {
            List<Node> intoBArrows = this.getGraph().getNodesInTo(B, Endpoint.ARROW);
            List<Node> intoBCircles = this.getGraph().getNodesInTo(B, Endpoint.CIRCLE);
            for (Node D : intoBCircles) {
                int[] choice;
                if (intoBArrows.size() < 2) continue;
                ChoiceGenerator gen = new ChoiceGenerator(intoBArrows.size(), 2);
                while ((choice = gen.next()) != null) {
                    Node A = intoBArrows.get(choice[0]);
                    Node C = intoBArrows.get(choice[1]);
                    if (this.getGraph().isAdjacentTo(A, C) || !this.getGraph().isAdjacentTo(A, D) || !this.getGraph().isAdjacentTo(C, D) || this.getGraph().getEndpoint(A, D) != Endpoint.CIRCLE || !this.getNoncolliderTriples().contains(new Triple(A, D, C)) || this.getGraph().getEndpoint(C, D) != Endpoint.CIRCLE || !this.isArrowpointAllowed(D, B)) continue;
                    this.getGraph().setEndpoint(D, B, Endpoint.ARROW);
                    this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Double triangle", this.getGraph().getEdge(D, B)));
                    this.changeFlag = true;
                }
            }
        }
    }

    private void ruleR4() {
        List<Node> nodes = this.getGraph().getNodes();
        for (Node b : nodes) {
            List<Node> possA = this.graph.getNodesOutTo(b, Endpoint.ARROW);
            List<Node> possC = this.graph.getNodesInTo(b, Endpoint.CIRCLE);
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!this.getGraph().isParentOf(a, c)) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    this.reachablePathFind(a, b, c, reachable);
                }
            }
        }
    }

    private void reachablePathFind(Node a, Node b, Node c, LinkedList<Node> reachable) {
        HashSet<Node> cParents = new HashSet<Node>(this.getGraph().getParents(c));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            List<Node> pathExtensions = this.getGraph().getNodesInTo(x, Endpoint.ARROW);
            pathExtensions.removeAll(visited);
            for (Node d : pathExtensions) {
                if (!this.getGraph().isAdjacentTo(d, c)) {
                    this.doDdpOrientation(d, a, b, c);
                    return;
                }
                if (!cParents.contains(d) || this.getGraph().getEndpoint(x, d) != Endpoint.ARROW) continue;
                reachable.add(d);
            }
        }
    }

    private void doDdpOrientation(Node l, Node a, Node b, Node c) {
        if (this.getColliderTriples().contains(new Triple(l, b, c))) {
            if (!this.isArrowpointAllowed(a, b)) {
                return;
            }
            if (!this.isArrowpointAllowed(c, b)) {
                return;
            }
            this.getGraph().setEndpoint(a, b, Endpoint.ARROW);
            this.getGraph().setEndpoint(c, b, Endpoint.ARROW);
            TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg("DDP", a, b, c));
            this.changeFlag = true;
        } else if (this.getNoncolliderTriples().contains(new Triple(l, b, c))) {
            this.getGraph().setEndpoint(c, b, Endpoint.TAIL);
            TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("DDP", this.getGraph().getEdge(c, b)));
            this.changeFlag = true;
        }
    }

    private void ruleR5() {
        List<Node> nodes = this.getGraph().getNodes();
        for (Node a : nodes) {
            List<Node> adjacents = this.getGraph().getNodesInTo(a, Endpoint.CIRCLE);
            for (Node b : adjacents) {
                if (this.getGraph().getEndpoint(a, b) != Endpoint.CIRCLE) continue;
                List<List<Node>> ucCirclePaths = this.getUcCirclePaths(a, b);
                System.out.println("Circle paths:");
                for (List<Node> path : ucCirclePaths) {
                    System.out.println(GraphUtils.pathString(this.getGraph(), path));
                }
                for (List<Node> u : ucCirclePaths) {
                    if (u.size() < 3) continue;
                    Node c = u.get(1);
                    Node d = u.get(u.size() - 2);
                    System.out.println("a = " + a + " c = " + c + " d = " + d + " b = " + b);
                    if (this.getGraph().isAdjacentTo(a, d) || this.getGraph().isAdjacentTo(b, c) || !this.getNoncolliderTriples().contains(new Triple(c, a, b)) || !this.getNoncolliderTriples().contains(new Triple(a, b, d))) continue;
                    ArrayList<Node> u2 = new ArrayList<Node>();
                    u2.add(a);
                    u2.addAll(u);
                    u2.add(b);
                    for (int i = 2; i < u2.size(); ++i) {
                        if (this.getNoncolliderTriples().contains(new Triple((Node)u2.get(i - 2), (Node)u2.get(i - 1), (Node)u2.get(i)))) continue;
                    }
                    this.logger.log("colliderOrientations", SearchLogUtils.edgeOrientedMsg("Orient circle path", this.getGraph().getEdge(a, b)));
                    this.getGraph().setEndpoint(a, b, Endpoint.TAIL);
                    this.getGraph().setEndpoint(b, a, Endpoint.TAIL);
                    this.orientTailPath(u);
                    this.changeFlag = true;
                }
            }
        }
    }

    private void ruleR6R7() {
        List<Node> nodes = this.getGraph().getNodes();
        for (Node b : nodes) {
            List<Node> adjacents = this.getGraph().getAdjacentNodes(b);
            if (adjacents.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacents.size(), 2);
            int[] choice = cg.next();
            while (choice != null) {
                Node a = adjacents.get(choice[0]);
                Node c = adjacents.get(choice[1]);
                if (!this.getGraph().isAdjacentTo(a, c) && this.getGraph().getEndpoint(b, a) == Endpoint.TAIL && this.getGraph().getEndpoint(c, b) == Endpoint.CIRCLE) {
                    if (this.getGraph().getEndpoint(a, b) == Endpoint.TAIL) {
                        System.out.println("Single tails (tail) " + c + " *-> " + b);
                        this.getGraph().setEndpoint(c, b, Endpoint.TAIL);
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Single tails (tail)", this.getGraph().getEdge(c, b)));
                        this.changeFlag = true;
                    }
                    if (this.getGraph().getEndpoint(a, b) == Endpoint.CIRCLE && this.getNoncolliderTriples().contains(new Triple(a, b, c))) {
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Single tails (tail)", this.getGraph().getEdge(c, b)));
                        this.getGraph().setEndpoint(c, b, Endpoint.TAIL);
                        this.changeFlag = true;
                    }
                }
                choice = cg.next();
            }
        }
    }

    private void rulesR8R9R10() {
        List<Node> nodes = this.getGraph().getNodes();
        for (Node c : nodes) {
            List<Node> intoCArrows = this.getGraph().getNodesInTo(c, Endpoint.ARROW);
            for (Node a : intoCArrows) {
                if (this.getGraph().getEndpoint(c, a) != Endpoint.CIRCLE || this.ruleR8(a, c) || this.ruleR9(a, c)) continue;
                this.ruleR10(a, c);
            }
        }
    }

    private void orientTailPath(List<Node> path) {
        for (int i = 0; i < path.size() - 1; ++i) {
            Node n1 = path.get(i);
            Node n2 = path.get(i + 1);
            System.out.println("Tail path " + n1 + "---" + n2);
            this.getGraph().setEndpoint(n1, n2, Endpoint.TAIL);
            this.getGraph().setEndpoint(n2, n1, Endpoint.TAIL);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Orient circle paths", this.getGraph().getEdge(n1, n2)));
        }
    }

    private List<List<Node>> getUcPdPaths(Node n1, Node n2) {
        LinkedList<List<Node>> ucPdPaths = new LinkedList<List<Node>>();
        LinkedList<Node> soFar = new LinkedList<Node>();
        soFar.add(n1);
        List<Node> adjacencies = this.getGraph().getAdjacentNodes(n1);
        for (Node curr : adjacencies) {
            this.getUcPdPsHelper(curr, soFar, n2, ucPdPaths);
        }
        return ucPdPaths;
    }

    private void getUcPdPsHelper(Node curr, List<Node> soFar, Node end, List<List<Node>> ucPdPaths) {
        if (soFar.contains(curr)) {
            return;
        }
        Node prev = soFar.get(soFar.size() - 1);
        if (this.getGraph().getEndpoint(prev, curr) == Endpoint.TAIL || this.getGraph().getEndpoint(curr, prev) == Endpoint.ARROW) {
            return;
        }
        if (soFar.size() >= 2) {
            Node prev2 = soFar.get(soFar.size() - 2);
            if (this.getGraph().isAdjacentTo(prev2, curr)) {
                return;
            }
        }
        soFar.add(curr);
        if (((Object)curr).equals(end)) {
            ucPdPaths.add(new LinkedList<Node>(soFar));
        } else {
            List<Node> adjacents = this.getGraph().getAdjacentNodes(curr);
            for (Node next : adjacents) {
                this.getUcPdPsHelper(next, soFar, end, ucPdPaths);
            }
        }
        soFar.remove(soFar.get(soFar.size() - 1));
    }

    private List<List<Node>> getUcCirclePaths(Node n1, Node n2) {
        LinkedList<List<Node>> ucCirclePaths = new LinkedList<List<Node>>();
        List<List<Node>> ucPdPaths = this.getUcPdPaths(n1, n2);
        block0: for (List<Node> path : ucPdPaths) {
            for (int i = 0; i < path.size() - 1; ++i) {
                Node j = path.get(i);
                Node sj = path.get(i + 1);
                if (this.getGraph().getEndpoint(j, sj) != Endpoint.CIRCLE || this.getGraph().getEndpoint(sj, j) != Endpoint.CIRCLE) continue block0;
                if (i != path.size() - 2) continue;
                ucCirclePaths.add(path);
            }
        }
        return ucCirclePaths;
    }

    private boolean ruleR8(Node a, Node c) {
        List<Node> intoCArrows = this.getGraph().getNodesInTo(c, Endpoint.ARROW);
        for (Node b : intoCArrows) {
            if (!this.getGraph().isAdjacentTo(a, b) || !this.getGraph().isAdjacentTo(b, c) || this.getGraph().getEndpoint(b, a) != Endpoint.TAIL || this.getGraph().getEndpoint(c, b) != Endpoint.TAIL || this.getGraph().getEndpoint(a, b) == Endpoint.TAIL) continue;
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("R8", this.getGraph().getEdge(c, a)));
            this.getGraph().setEndpoint(c, a, Endpoint.TAIL);
            this.changeFlag = true;
            return true;
        }
        return false;
    }

    private boolean ruleR9(Node a, Node c) {
        List<List<Node>> ucPdPsToC = this.getUcPdPaths(a, c);
        block0: for (List<Node> u : ucPdPsToC) {
            Node b = u.get(1);
            if (this.getGraph().isAdjacentTo(b, c) || b == c) continue;
            for (int i = 2; i < u.size(); ++i) {
                if (!this.getNoncolliderTriples().contains(new Triple(u.get(i - 2), u.get(i - 1), u.get(i)))) continue block0;
            }
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("R9", this.getGraph().getEdge(c, a)));
            this.getGraph().setEndpoint(c, a, Endpoint.TAIL);
            this.changeFlag = true;
            return true;
        }
        return false;
    }

    private boolean ruleR10(Node a, Node c) {
        List<Node> intoCArrows = this.getGraph().getNodesInTo(c, Endpoint.ARROW);
        for (Node b : intoCArrows) {
            if (b == a || this.getGraph().getEndpoint(c, b) != Endpoint.TAIL) continue;
            for (Node d : intoCArrows) {
                if (d == a || d == b || this.getGraph().getEndpoint(d, c) != Endpoint.TAIL) continue;
                List<List<Node>> ucPdPsToB = this.getUcPdPaths(a, b);
                List<List<Node>> ucPdPsToD = this.getUcPdPaths(a, d);
                block2: for (List<Node> u1 : ucPdPsToB) {
                    Node m = u1.get(1);
                    for (List<Node> u2 : ucPdPsToD) {
                        int i;
                        Node n = u2.get(1);
                        for (i = 2; i < u1.size(); ++i) {
                            if (!this.getNoncolliderTriples().contains(new Triple(u1.get(i - 2), u1.get(i - 1), u1.get(i)))) continue block2;
                        }
                        for (i = 2; i < u2.size(); ++i) {
                            if (!this.getNoncolliderTriples().contains(new Triple(u2.get(i - 2), u2.get(i - 1), u2.get(i)))) continue block2;
                        }
                        if (((Object)m).equals(n) || this.getGraph().isAdjacentTo(m, n)) continue;
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("R10", this.getGraph().getEdge(c, a)));
                        this.getGraph().setEndpoint(c, a, Endpoint.TAIL);
                        this.changeFlag = true;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static void fciOrientbk(Knowledge bk, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        TetradLogger.getInstance().log("info", "Starting BK Orientation.");
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
            TetradLogger.getInstance().log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Required by knowledge", graph.getEdge(from, to)));
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(from, to, Endpoint.ARROW);
            graph.setEndpoint(to, from, Endpoint.TAIL);
            TetradLogger.getInstance().log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Required by knowledge", graph.getEdge(from, to)));
        }
    }

    private boolean isArrowpointAllowed(Node x, Node y) {
        if (this.getGraph().getEndpoint(x, y) == Endpoint.ARROW) {
            return true;
        }
        if (this.getGraph().getEndpoint(x, y) == Endpoint.TAIL) {
            return false;
        }
        if (this.getGraph().getEndpoint(y, x) == Endpoint.ARROW && this.getGraph().getEndpoint(x, y) == Endpoint.CIRCLE) {
            return true;
        }
        return !this.knowledge.isForbiddenByTiers(x.getName(), y.getName());
    }

    public boolean isPossibleDsepSearchDone() {
        return this.possibleDsepSearchDone;
    }

    public void setPossibleDsepSearchDone(boolean possibleDsepSearchDone) {
        this.possibleDsepSearchDone = possibleDsepSearchDone;
    }

    private static enum TripleType {
        COLLIDER,
        NONCOLLIDER,
        AMBIGUOUS;

    }
}

