/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class ClarkFas {
    private IndependenceTest independenceTest;
    private Knowledge knowledge = new Knowledge();
    private SepsetMap sepsets;
    private int depth = 2;
    private TetradLogger logger = TetradLogger.getInstance();

    public ClarkFas(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0.");
        }
        if (depth > 1000) {
            throw new IllegalArgumentException("Depth must be <= 1000.");
        }
        this.depth = depth;
    }

    public Graph search() {
        int i;
        this.logger.log("info", "Starting PC algorithm");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        if (this.getIndependenceTest() == null) {
            throw new NullPointerException();
        }
        List<Node> nodes = this.getIndependenceTest().getVariables();
        Vector g = new Vector();
        Set<NodePair> g1 = new HashSet();
        g.add(g1);
        System.out.println("Depth 0");
        for (i = 0; i < nodes.size(); ++i) {
            System.out.println(i + " / " + nodes.size());
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node xi = nodes.get(i);
                Node xj = nodes.get(j);
                if (this.getIndependenceTest().isIndependent(xi, xj, new Node[0])) continue;
                NodePair p = new NodePair(xi, xj);
                g1.add(p);
            }
        }
        for (i = 1; i <= this.depth; ++i) {
            System.out.println("Depth " + i);
            g1 = (Set)g.lastElement();
            HashSet g2 = new HashSet((Collection)g.lastElement());
            g.add(g2);
            int j = 0;
            for (NodePair p : g1) {
                int[] choice;
                System.out.println(++j + " / " + g1.size());
                Node xi = p.getFirst();
                Node xj = p.getSecond();
                ChoiceGenerator gen = new ChoiceGenerator(nodes.size(), this.depth);
                while ((choice = gen.next()) != null) {
                    List<Node> cond = SearchGraphUtils.asList(choice, nodes);
                    for (Node _node : cond) {
                        if (_node == xi || _node == xj || cond.contains(xi) || cond.contains(xj) || !this.allAdjacent(xi, cond, g1) && !this.allAdjacent(xj, cond, g1) || !this.getIndependenceTest().isIndependent(xi, xj, cond)) continue;
                        g2.remove(p);
                    }
                }
            }
        }
        EdgeListGraph graph = new EdgeListGraph(this.getIndependenceTest().getVariables());
        Set gPrime = (Set)g.lastElement();
        for (NodePair p : gPrime) {
            graph.addUndirectedEdge(p.getFirst(), p.getSecond());
        }
        return graph;
    }

    private boolean allAdjacent(Node xi, List<Node> cond, Set<NodePair> g1) {
        for (Node node : cond) {
            if (g1.contains(new NodePair(xi, node))) continue;
            return false;
        }
        return true;
    }
}

