/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Cpc;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MbSearch;
import edu.cmu.tetrad.search.MbUtils;
import java.util.List;

public class CpcMb
implements MbSearch {
    private IndependenceTest test;
    private int depth;

    public CpcMb(IndependenceTest test, int depth) {
        this.test = test;
        this.depth = depth;
    }

    @Override
    public List<Node> findMb(String targetName) {
        Node target = this.getVariableForName(targetName);
        Cpc search = new Cpc(this.test);
        search.setDepth(this.depth);
        Graph graph = search.search();
        MbUtils.trimToMbNodes(graph, target, false);
        List<Node> mbVariables = graph.getNodes();
        mbVariables.remove(target);
        return mbVariables;
    }

    @Override
    public String getAlgorithmName() {
        return "CPCMB";
    }

    @Override
    public int getNumIndependenceTests() {
        return 0;
    }

    private Node getVariableForName(String targetVariableName) {
        Node target = null;
        for (Node V : this.test.getVariables()) {
            if (!V.getName().equals(targetVariableName)) continue;
            target = V;
            break;
        }
        if (target == null) {
            throw new IllegalArgumentException("Target variable not in dataset: " + targetVariableName);
        }
        return target;
    }
}

