/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.CombinationGenerator;
import java.util.ArrayList;
import java.util.List;

public class DirectedGraphIterator {
    private List<Graph> graphs = new ArrayList<Graph>();
    private int index = -1;

    public DirectedGraphIterator(Graph graph) {
        int[] combination;
        graph = new EdgeListGraph(graph);
        ArrayList<Edge> undirectedEdges = new ArrayList<Edge>();
        for (Edge edge : graph.getEdges()) {
            if (!Edges.isUndirectedEdge(edge)) continue;
            undirectedEdges.add(edge);
        }
        int[] dims = new int[undirectedEdges.size()];
        for (int i = 0; i < undirectedEdges.size(); ++i) {
            dims[i] = 2;
        }
        CombinationGenerator generator = new CombinationGenerator(dims);
        while ((combination = generator.next()) != null) {
            for (int k = 0; k < combination.length; ++k) {
                Edge edge = (Edge)undirectedEdges.get(k);
                graph.removeEdge(edge.getNode1(), edge.getNode2());
                if (combination[k] == 0) {
                    graph.addDirectedEdge(edge.getNode1(), edge.getNode2());
                    continue;
                }
                graph.addDirectedEdge(edge.getNode2(), edge.getNode1());
            }
            this.graphs.add(new EdgeListGraph(graph));
        }
        System.out.println("# directed graphs = " + this.graphs.size());
    }

    public Graph next() {
        ++this.index;
        if (this.index < this.graphs.size()) {
            return this.graphs.get(this.index);
        }
        return null;
    }

    public boolean hasNext() {
        return this.index + 1 < this.graphs.size();
    }
}

