/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

public class EvaluationResult {
    AdjacencyEvaluationResult adj;
    OrientationEvaluationResult ori;
    CoefficientEvaluationResult coeffAll;
    CoefficientEvaluationResult coeffSome;
    PatternEvaluationResult pat;
    String name = null;

    public EvaluationResult(String methodName, AdjacencyEvaluationResult adj, OrientationEvaluationResult ori, CoefficientEvaluationResult coeffAll, CoefficientEvaluationResult coeffSome) {
        this.name = methodName;
        this.adj = adj;
        this.ori = ori;
        this.coeffAll = coeffAll;
        this.coeffSome = coeffSome;
    }

    public EvaluationResult(String methodName, PatternEvaluationResult pat) {
        this.name = methodName;
        this.pat = pat;
    }

    static class PatternEvaluationResult {
        AdjacencyEvaluationResult adj;
        OrientationEvaluationResult ori;

        public PatternEvaluationResult(AdjacencyEvaluationResult adj, OrientationEvaluationResult ori) {
            this.adj = adj;
            this.ori = ori;
        }

        public double loss() {
            double oriLoss = (double)this.ori.directedWrongWay.intValue() + 0.5 * (double)this.ori.undirectedWhenShouldBeDirected.intValue() + 0.5 * (double)this.ori.directedWhenShouldBeUndirected.intValue();
            double adjLoss = 1.5 * (double)this.adj.errorsOfOmission.intValue() + 1.0 * (double)this.adj.errorsOfCommission.intValue();
            double loss = adjLoss + oriLoss;
            return loss;
        }
    }

    static class CoefficientEvaluationResult
    implements PartialEvaluationResult {
        Double totalCoeffErrorSq;
        Integer nEdgesEvaluated;

        public CoefficientEvaluationResult(Double totalCoeffErrorSq, Integer edgesEvaluated) {
            this.totalCoeffErrorSq = totalCoeffErrorSq;
            this.nEdgesEvaluated = edgesEvaluated;
        }

        double loss() {
            return this.totalCoeffErrorSq;
        }

        @Override
        public double[] values() {
            return new double[]{this.totalCoeffErrorSq, this.nEdgesEvaluated.intValue(), this.loss()};
        }
    }

    static class OrientationEvaluationResult
    implements PartialEvaluationResult {
        Integer nCorrect;
        Integer directedWrongWay;
        Integer undirectedWhenShouldBeDirected;
        Integer directedWhenShouldBeUndirected;

        public OrientationEvaluationResult(Integer correct, Integer directedWrongWay, Integer undirectedWhenShouldBeDirected, Integer directedWhenShouldBeUndirected) {
            this.nCorrect = correct;
            this.directedWrongWay = directedWrongWay;
            this.undirectedWhenShouldBeDirected = undirectedWhenShouldBeDirected;
            this.directedWhenShouldBeUndirected = directedWhenShouldBeUndirected;
        }

        @Override
        public double[] values() {
            return new double[]{this.nCorrect.intValue(), this.directedWrongWay.intValue(), this.undirectedWhenShouldBeDirected.intValue(), this.directedWhenShouldBeUndirected.intValue()};
        }
    }

    static class AdjacencyEvaluationResult
    implements PartialEvaluationResult {
        Integer errorsOfOmission;
        Integer errorsOfCommission;

        public AdjacencyEvaluationResult(Integer errorsOfOmission, Integer errorsOfCommission) {
            this.errorsOfOmission = errorsOfOmission;
            this.errorsOfCommission = errorsOfCommission;
        }

        public double loss() {
            return this.errorsOfOmission + this.errorsOfCommission;
        }

        @Override
        public double[] values() {
            return new double[]{this.errorsOfOmission.intValue(), this.errorsOfCommission.intValue(), this.loss()};
        }
    }

    public static interface PartialEvaluationResult {
        public double[] values();
    }
}

