/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.function.DoubleFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.stat.Descriptive;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.CheatSearch;
import edu.cmu.tetrad.search.EvaluationResult;
import edu.cmu.tetrad.search.GraphWithParameters;
import edu.cmu.tetrad.search.LacerdaSpirtesRamsey2007Search;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SemLearningMethod;
import edu.cmu.tetrad.search.Shimizu2006SearchOld;
import edu.cmu.tetrad.search.fastica.math.Matrix;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Beta;
import edu.cmu.tetrad.util.dist.Distribution;
import edu.cmu.tetrad.util.dist.GaussianPower;
import edu.cmu.tetrad.util.dist.Normal;
import edu.cmu.tetrad.util.dist.Uniform;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ExploreFastIca {
    static String _ = "     ";
    static String __ = _ + _;
    static String ___ = _ + _ + _;
    static String ____ = _ + _ + _ + _;
    static String METHOD_SEPARATOR = "|" + _;
    public static List<Edge> edgesToEvaluateCoeffs;
    public static double globalCoeffErrorScoreTrue;
    public static int globalNEdgesEvaluatedTrue;
    public static int totalOriCorrect;
    public static int totalOriEvaluated;
    private static int totalErrorsOfOmission;
    private static int totalErrorsOfCommission;

    public double[][] sampleMatrix() {
        double[][] a = new double[][]{{2.0, 5.0, 10.0, 11.0, 7.0}, {3.0, 3.0, 5.0, 1.0, 2.0}, {5.0, 4.0, 8.0, 6.0, 11.0}, {6.0, 3.0, 5.0, 12.0, 10.0}, {9.0, 2.0, 4.0, 5.0, 9.0}};
        return a;
    }

    public static List<Node> makeNodeList(int nVars) {
        Vector<Node> nodes = new Vector<Node>();
        for (int i = 1; i <= nVars; ++i) {
            GraphNode node = new GraphNode("X" + i);
            nodes.add(node);
        }
        return nodes;
    }

    private static GraphWithParameters makeRandomDagWithParms(Dag dag) {
        GraphWithParameters dwp = new GraphWithParameters(dag);
        List<Edge> edges = dag.getEdges();
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.get(i);
            double w = 1.0;
            dwp.getWeightHash().put(edge, w);
        }
        return dwp;
    }

    public static void main(String[] args) {
        ExploreFastIca.generateCandidateModels();
    }

    private static void generateCandidateModels() {
        GraphWithParameters genModel = ExploreFastIca.graphAbc();
        System.out.println("genModel = " + genModel + "\n" + genModel.getGraphMatrix());
        boolean isShrinkingMatrix = LacerdaSpirtesRamsey2007Search.allEigenvaluesAreSmallerThanOneInModulus(genModel.getGraphMatrix().getDoubleData());
        System.out.println("for generating model, isShrinkingMatrix = " + isShrinkingMatrix);
        DoubleMatrix2D reducedForm = ExploreFastIca.reducedForm(genModel);
        System.out.println("reducedForm = " + reducedForm);
        ColtDataSet matrixB = genModel.getGraphMatrix();
        int n = matrixB.getDoubleData().rows();
        DoubleMatrix2D matrixW = MatrixUtils.linearCombination(MatrixUtils.identityMatrix(n), 1.0, matrixB.getDoubleData(), -1.0);
        System.out.println("211: matrixW = " + matrixW);
        LacerdaSpirtesRamsey2007Search.findCandidateModels(genModel.getGraph().getNodes(), matrixW, null, n, false);
    }

    private static void showPowersOfB(GraphWithParameters genModel) {
        ColtDataSet matrixB = genModel.getGraphMatrix();
        Algebra algebra = new Algebra();
        for (int i = 1; i < 100; i += 10) {
            DoubleMatrix2D bpow = algebra.pow(matrixB.getDoubleData(), i);
            System.out.println("B^" + i + " = " + bpow);
        }
    }

    private static GraphWithParameters graphXyzw() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("X"));
        g.addNode(new GraphNode("Y"));
        g.addNode(new GraphNode("Z"));
        g.addNode(new GraphNode("W"));
        genModel.addEdge("X", "Z", 1.0);
        genModel.addEdge("Y", "W", 1.0);
        genModel.addEdge("Z", "W", 1.2);
        genModel.addEdge("W", "Z", 0.7);
        return genModel;
    }

    private static GraphWithParameters graph4Cycle() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("B"));
        g.addNode(new GraphNode("C"));
        g.addNode(new GraphNode("D"));
        g.addNode(new GraphNode("E"));
        genModel.addEdge("B", "C", 1.0);
        genModel.addEdge("C", "D", 0.7);
        genModel.addEdge("D", "E", 0.7);
        genModel.addEdge("E", "B", 1.0);
        return genModel;
    }

    private static GraphWithParameters graphAbc() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("X1"));
        g.addNode(new GraphNode("X2"));
        g.addNode(new GraphNode("X3"));
        genModel.addEdge("X2", "X1", 1.0);
        genModel.addEdge("X3", "X1", 0.7);
        return genModel;
    }

    private static GraphWithParameters graphInteractingCycles() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("A"));
        g.addNode(new GraphNode("B"));
        g.addNode(new GraphNode("C"));
        g.addNode(new GraphNode("D"));
        g.addNode(new GraphNode("E"));
        genModel.addEdge("A", "B", 0.5);
        genModel.addEdge("B", "C", 1.0);
        genModel.addEdge("C", "A", 1.0);
        genModel.addEdge("A", "D", -1.1);
        genModel.addEdge("D", "E", 1.0);
        genModel.addEdge("E", "C", 0.96);
        return genModel;
    }

    private static GraphWithParameters graphWithCycleIndicators() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("A1"));
        g.addNode(new GraphNode("A2"));
        g.addNode(new GraphNode("A3"));
        g.addNode(new GraphNode("A4"));
        g.addNode(new GraphNode("B1"));
        g.addNode(new GraphNode("B2"));
        g.addNode(new GraphNode("B3"));
        g.addNode(new GraphNode("B4"));
        g.addNode(new GraphNode("C1"));
        g.addNode(new GraphNode("C2"));
        g.addNode(new GraphNode("C3"));
        g.addNode(new GraphNode("C4"));
        genModel.addEdge("A1", "B1", 1.0);
        genModel.addEdge("A2", "B2", 1.0);
        genModel.addEdge("A3", "B3", 1.0);
        genModel.addEdge("A4", "B4", 1.0);
        genModel.addEdge("B1", "C1", 1.0);
        genModel.addEdge("B2", "C2", 1.0);
        genModel.addEdge("B3", "C3", 1.0);
        genModel.addEdge("B4", "C4", 1.0);
        genModel.addEdge("B1", "B2", 0.9);
        genModel.addEdge("B2", "B3", 0.9);
        genModel.addEdge("B3", "B4", 0.9);
        genModel.addEdge("B4", "B1", 0.9);
        return genModel;
    }

    private static GraphWithParameters graph2() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("A"));
        g.addNode(new GraphNode("B"));
        genModel.addEdge("A", "B", 0.5);
        genModel.addEdge("B", "A", 0.8);
        return genModel;
    }

    private static GraphWithParameters graphUaiPaper() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("X1"));
        g.addNode(new GraphNode("X2"));
        g.addNode(new GraphNode("X3"));
        g.addNode(new GraphNode("X4"));
        g.addNode(new GraphNode("X5"));
        genModel.addEdge("X1", "X2", 1.2);
        genModel.addEdge("X2", "X3", 2.0);
        genModel.addEdge("X3", "X4", -1.0);
        genModel.addEdge("X4", "X2", -0.3);
        genModel.addEdge("X2", "X5", 3.0);
        return genModel;
    }

    private static GraphWithParameters graphIndepCycles() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("A"));
        g.addNode(new GraphNode("B"));
        g.addNode(new GraphNode("C"));
        g.addNode(new GraphNode("D"));
        g.addNode(new GraphNode("E"));
        genModel.addEdge("A", "B", 0.5);
        genModel.addEdge("B", "A", 0.5);
        genModel.addEdge("B", "C", 1.0);
        genModel.addEdge("C", "D", 0.7);
        genModel.addEdge("D", "C", 0.7);
        return genModel;
    }

    private static GraphWithParameters graph2_2Cycles() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("K1"));
        g.addNode(new GraphNode("K2"));
        g.addNode(new GraphNode("L1"));
        g.addNode(new GraphNode("L2"));
        genModel.addEdge("K1", "K2", 0.9);
        genModel.addEdge("K2", "K1", 0.9);
        genModel.addEdge("L1", "L2", 0.9);
        genModel.addEdge("L2", "L1", 0.9);
        return genModel;
    }

    private static void testVarianceOfGaussianSquare() {
        GaussianPower gp2 = new GaussianPower(2.0);
        int SIZE = 1000000;
        double[] arr = new double[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            double sample;
            arr[i] = sample = gp2.nextRandom();
        }
        DoubleArrayList dal = new DoubleArrayList(arr);
        double mean = Descriptive.mean(dal);
        double variance = Descriptive.sampleVariance(dal, mean);
        System.out.println("mean = " + mean);
        System.out.println("variance = " + variance);
    }

    private static void testRiemannSum() {
        double sum = ExploreFastIca.riemannSum();
        System.out.println("sum = " + sum);
        double pi = Math.PI;
        System.out.println("sqrt(2*pi) = " + Math.sqrt(2.0 * pi));
    }

    private static double riemannSum() {
        double stepSize = 0.05;
        double sum = 0.0;
        double pi = Math.PI;
        for (double t = -20.0; t < 20.0; t += stepSize) {
            double value = 1.0 / Math.sqrt(2.0 * pi) * Math.exp(-(Math.abs(t) / 2.0)) * Math.pow(t, 2.0);
            System.out.println("t = " + t + "  value = " + value);
            sum += stepSize * value;
        }
        return sum;
    }

    private static void testCyclicDiscovery() {
        GaussianPower gp2 = new GaussianPower(2.0);
        GraphWithParameters genModel = ExploreFastIca.graphUaiPaper();
        DoubleMatrix1D errorCoefficients = ExploreFastIca.getErrorCoeffsIdentity(genModel.getGraph().getNumNodes());
        DoubleMatrix2D inVectors = ExploreFastIca.simulate_Cyclic(genModel, errorCoefficients, 3000, gp2);
        ColtDataSet dataSet = ColtDataSet.makeContinuousData(genModel.getGraph().getNodes(), inVectors.viewDice());
        DoubleMatrix2D iMinusB = MatrixUtils.linearCombination(MatrixUtils.identityMatrix(4), 1.0, ExploreFastIca.getMatAbcd(), -1.0);
        DoubleMatrix2D invIMinusB = MatrixUtils.inverse(iMinusB);
        new LacerdaSpirtesRamsey2007Search().run(dataSet);
    }

    private static DoubleMatrix1D getErrorCoeffsSpirtes05Nov() {
        DenseDoubleMatrix1D errorCoefficients = new DenseDoubleMatrix1D(4);
        errorCoefficients.set(0, 0.9);
        errorCoefficients.set(1, 1.5);
        errorCoefficients.set(2, 1.3);
        errorCoefficients.set(3, 0.6);
        return errorCoefficients;
    }

    private static DoubleMatrix1D getErrorCoeffsIdentity(int n) {
        DenseDoubleMatrix1D errorCoefficients = new DenseDoubleMatrix1D(n);
        for (int i = 0; i < n; ++i) {
            errorCoefficients.set(i, 1.0);
        }
        return errorCoefficients;
    }

    public static void testNRooks() {
        DoubleMatrix2D mat = ExploreFastIca.getMat17Oct();
        List<List<Integer>> assns = LacerdaSpirtesRamsey2007Search.nRookColumnAssignments(mat);
        System.out.println("assns.size() = " + assns.size());
        for (List<Integer> assn : assns) {
            System.out.println(assn);
            DoubleMatrix2D m = LacerdaSpirtesRamsey2007Search.displayNRookAssignment(assn);
            System.out.println(m);
        }
    }

    private static DoubleMatrix2D getMat17Oct() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(4, 4);
        mat.set(0, 0, 1.0);
        mat.set(0, 1, 1.0);
        mat.set(1, 1, 1.0);
        mat.set(1, 2, 1.0);
        mat.set(2, 2, 1.0);
        mat.set(2, 3, 1.0);
        mat.set(3, 3, 1.0);
        mat.set(3, 0, 1.0);
        return mat;
    }

    private static DoubleMatrix2D getMatAbcd() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(4, 4);
        mat.set(0, 1, 0.5);
        mat.set(1, 2, 0.5);
        mat.set(2, 3, 0.5);
        mat.set(3, 0, 0.5);
        return mat;
    }

    private static DoubleMatrix2D getMatXyzwM1() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(4, 4);
        mat.set(2, 0, 0.7);
        mat.set(3, 1, 1.2);
        mat.set(3, 2, 0.8);
        mat.set(2, 3, 0.4);
        return mat;
    }

    private static DoubleMatrix2D getMatXyzCycle() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(3, 3);
        mat.set(1, 0, 0.5);
        mat.set(2, 1, 0.5);
        mat.set(1, 2, 0.5);
        return mat;
    }

    private static DoubleMatrix2D getMatXzyCycle() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(3, 3);
        mat.set(2, 0, 0.5);
        mat.set(2, 1, 0.5);
        mat.set(1, 2, 0.5);
        return mat;
    }

    private static DoubleMatrix2D getMatXyzwM2() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(4, 4);
        mat.set(3, 0, 0.5);
        mat.set(2, 1, 0.5);
        mat.set(3, 2, 0.5);
        mat.set(2, 3, 0.5);
        return mat;
    }

    private static DoubleMatrix2D getMatXyzComplete() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(3, 3);
        mat.set(0, 1, 0.5);
        mat.set(0, 2, 0.5);
        mat.set(1, 0, 0.5);
        mat.set(1, 2, 0.5);
        mat.set(2, 0, 0.5);
        mat.set(2, 1, 0.5);
        return mat;
    }

    private static DoubleMatrix2D getMatXyzXExogenous() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(3, 3);
        mat.set(0, 1, 0.5);
        mat.set(1, 2, 0.5);
        mat.set(2, 1, 0.5);
        return mat;
    }

    public static void runMultipleTimes() {
        DataSet dataSet = ExploreFastIca.readData("C:\\Documents and Settings\\Administrator\\Desktop\\causality\\joe-data.txt");
        for (int i = 0; i < 10; ++i) {
            Vector<SemLearningMethod> methods = new Vector<SemLearningMethod>();
            methods.add(new Shimizu2006SearchOld(0.5));
            ExploreFastIca.doRun(dataSet, null, methods, false);
        }
    }

    private static void compareIcaTetrad() {
        Beta beta05_05 = new Beta(0.5, 0.5);
        Beta beta2_2 = new Beta(2.0, 2.0);
        Uniform u = new Uniform(-1.0, 1.0);
        GaussianPower gp025 = new GaussianPower(0.25);
        GaussianPower gp05 = new GaussianPower(0.5);
        GaussianPower gp09 = new GaussianPower(0.9);
        GaussianPower gp095 = new GaussianPower(0.95);
        GaussianPower gp098 = new GaussianPower(0.98);
        GaussianPower gp1 = new GaussianPower(1.0);
        Normal g = new Normal(0.0, 1.0);
        GaussianPower gp102 = new GaussianPower(1.02);
        GaussianPower gp105 = new GaussianPower(1.05);
        GaussianPower gp11 = new GaussianPower(1.1);
        GaussianPower gp12 = new GaussianPower(1.2);
        GaussianPower gp13 = new GaussianPower(1.3);
        GaussianPower gp14 = new GaussianPower(1.4);
        GaussianPower gp15 = new GaussianPower(1.5);
        GaussianPower gp16 = new GaussianPower(1.6);
        GaussianPower gp17 = new GaussianPower(1.7);
        GaussianPower gp18 = new GaussianPower(1.8);
        GaussianPower gp19 = new GaussianPower(1.9);
        GaussianPower gp2 = new GaussianPower(2.0);
        GaussianPower gp25 = new GaussianPower(2.5);
        GaussianPower gp3 = new GaussianPower(3.0);
        GaussianPower gp35 = new GaussianPower(3.5);
        GaussianPower gp4 = new GaussianPower(4.0);
        Beta beta0203 = new Beta(0.2, 0.3);
        for (int nNodes : new int[]{10}) {
            for (int maxNoParents : new int[]{3}) {
                for (int graphRun = 0; graphRun < 1; ++graphRun) {
                    for (int sampleSize : new int[]{50, 200}) {
                        for (Distribution distr : new Distribution[]{gp1}) {
                            int nRuns = 10;
                            Vector<SemLearningMethod> methods = new Vector<SemLearningMethod>();
                            methods.add(new Shimizu2006SearchOld(0.2));
                            methods.add(new Shimizu2006SearchOld(0.4));
                            methods.add(new Shimizu2006SearchOld(0.5));
                            methods.add(new Shimizu2006SearchOld(0.6));
                            methods.add(new CheatSearch());
                            boolean evaluateAsPattern = true;
                            List<HashMap<SemLearningMethod, EvaluationResult>> evalTable = ExploreFastIca.doRuns(nNodes, sampleSize, maxNoParents, distr, methods, evaluateAsPattern, nRuns);
                            ExploreFastIca.printRunHeader(nNodes, sampleSize, maxNoParents, (GaussianPower)distr);
                            if (!evaluateAsPattern) {
                                ExploreFastIca.makeComparisonForGraph(evalTable, methods);
                                continue;
                            }
                            ExploreFastIca.makeComparisonForPattern(evalTable, methods);
                        }
                    }
                }
            }
        }
    }

    private static void makeComparisonForPattern(List<HashMap<SemLearningMethod, EvaluationResult>> evalTable, List<SemLearningMethod> methods) {
        int i = 0;
        int propsPerMethod = 6;
        DenseDoubleMatrix2D table = new DenseDoubleMatrix2D(evalTable.size(), propsPerMethod * methods.size());
        for (HashMap<SemLearningMethod, EvaluationResult> run : evalTable) {
            int nMethod = 0;
            for (SemLearningMethod method : methods) {
                EvaluationResult eval = run.get(method);
                EvaluationResult.PatternEvaluationResult pat = eval.pat;
                table.set(i, 0 + propsPerMethod * nMethod, pat.adj.errorsOfOmission.intValue());
                table.set(i, 1 + propsPerMethod * nMethod, pat.adj.errorsOfCommission.intValue());
                table.set(i, 2 + propsPerMethod * nMethod, pat.ori.directedWrongWay.intValue());
                table.set(i, 3 + propsPerMethod * nMethod, pat.ori.undirectedWhenShouldBeDirected.intValue());
                table.set(i, 4 + propsPerMethod * nMethod, pat.ori.directedWhenShouldBeUndirected.intValue());
                table.set(i, 5 + propsPerMethod * nMethod, pat.loss());
                ++nMethod;
            }
            ++i;
        }
        ExploreFastIca.printTable(propsPerMethod, table, methods, "pattern (errOmission,errCommission,directedWrongWay,undirectedWhenShouldBeDirected,directedWhenShouldBeUndirected,loss)");
    }

    private static void makeComparisonForGraph(List<HashMap<SemLearningMethod, EvaluationResult>> evalTable, List<SemLearningMethod> methods) {
        int i = 0;
        int propsPerMethod = 3;
        DenseDoubleMatrix2D adjTable = new DenseDoubleMatrix2D(evalTable.size(), propsPerMethod * methods.size());
        for (HashMap<SemLearningMethod, EvaluationResult> run : evalTable) {
            int nMethod = 0;
            for (SemLearningMethod method : methods) {
                EvaluationResult eval = run.get(method);
                adjTable.set(i, 0 + propsPerMethod * nMethod, eval.adj.errorsOfOmission.intValue());
                adjTable.set(i, 1 + propsPerMethod * nMethod, eval.adj.errorsOfCommission.intValue());
                adjTable.set(i, 2 + propsPerMethod * nMethod, eval.adj.loss());
                ++nMethod;
            }
            ++i;
        }
        ExploreFastIca.printTable(propsPerMethod, adjTable, methods, "adjacency (errOmission,errCommission,loss)");
        i = 0;
        propsPerMethod = 1;
        DenseDoubleMatrix2D allCoeffTable = new DenseDoubleMatrix2D(evalTable.size(), propsPerMethod * methods.size());
        for (HashMap<SemLearningMethod, EvaluationResult> run : evalTable) {
            int nMethod = 0;
            for (SemLearningMethod method : methods) {
                EvaluationResult eval = run.get(method);
                allCoeffTable.set(i, 0 + propsPerMethod * nMethod, eval.coeffAll.loss());
                ++nMethod;
            }
            ++i;
        }
        ExploreFastIca.printTable(propsPerMethod, allCoeffTable, methods, "all coefficients (total_loss)");
    }

    private static void printTable(int propsPerMethod, DoubleMatrix2D table, List<SemLearningMethod> methods, String propsEvaluated) {
        int j;
        int props = table.columns();
        int runs = table.rows();
        Vector<Double> means = new Vector<Double>();
        Vector<Double> sds = new Vector<Double>();
        for (int j2 = 0; j2 < table.columns(); ++j2) {
            DoubleArrayList dal = new DoubleArrayList(table.viewColumn(j2).toArray());
            double mean = Descriptive.mean(dal);
            means.add(mean);
            double variance = Descriptive.sampleVariance(dal, mean);
            double sd = runs > 1 ? Descriptive.sampleStandardDeviation(runs, variance) : -1.0;
            sds.add(sd);
        }
        String s = "*** comparing runs for this setting: " + propsEvaluated + " ***";
        String stars = ExploreFastIca.stringMultiply("*", s.length());
        System.out.println(stars);
        System.out.println(s);
        System.out.println(stars);
        s = "";
        for (SemLearningMethod method : methods) {
            s = s + method.getName() + __;
        }
        System.out.println(s);
        for (int i = 0; i < runs; ++i) {
            s = "#" + i + ":" + __;
            for (int j3 = 0; j3 < props; ++j3) {
                s = s + ExploreFastIca.nextEntryString(table.get(i, j3), j3, propsPerMethod);
            }
            System.out.println(s);
        }
        System.out.println("from " + runs + " runs");
        s = "mean:    " + _;
        for (j = 0; j < props; ++j) {
            s = s + ExploreFastIca.nextEntryString((Double)means.get(j), j, propsPerMethod);
        }
        System.out.println(s);
        s = "stdev:   " + _;
        for (j = 0; j < props; ++j) {
            s = s + ExploreFastIca.nextEntryString((Double)sds.get(j), j, propsPerMethod);
        }
        System.out.println(s);
        if (propsPerMethod == 1) {
            int smallestLossIndex = ExploreFastIca.argmin(means, methods);
            System.out.println("smallestLossIndex = " + smallestLossIndex);
            System.out.println("smallest loss: " + methods.get(smallestLossIndex).getName());
        }
    }

    private static int argmin(List<Double> l, List<SemLearningMethod> methods) {
        int minIndex = 0;
        double min = l.get(0);
        int i = 0;
        for (double d : l) {
            if (d < min && !methods.get(i).getName().contains("true DAG")) {
                min = d;
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    private static String nextEntryString(double entry, int column, int propsPerMethod) {
        DecimalFormat form = new DecimalFormat("0.000E00");
        String s = "";
        if (column % propsPerMethod == 0) {
            s = s + METHOD_SEPARATOR;
        }
        String d = form.format(entry);
        int dSize = ("" + d).length();
        s = s + d + ExploreFastIca.stringMultiply(" ", 10 - dSize);
        return s;
    }

    private static String stringMultiply(String str, int n) {
        String s = "";
        for (int i = 0; i < n; ++i) {
            s = s + str;
        }
        return s;
    }

    private static List<HashMap<SemLearningMethod, EvaluationResult>> doRuns(int nNodes, int sampleSize, int maxNoParents, Distribution distr, List<SemLearningMethod> methods, boolean evaluateAsPattern, int nRuns) {
        Vector<HashMap<SemLearningMethod, EvaluationResult>> evalTable = new Vector<HashMap<SemLearningMethod, EvaluationResult>>();
        for (int run = 0; run < nRuns; ++run) {
            ExploreFastIca.printRunHeader(nNodes, sampleSize, maxNoParents, (GaussianPower)distr, run);
            int maxNumEdges = nNodes * (nNodes - 1) / 2;
            Dag dag = GraphUtils.randomDag(nNodes, 0, nNodes, nNodes, maxNoParents, nNodes, false);
            System.out.println("generating DAG = " + dag);
            Graph standard = !evaluateAsPattern ? dag : SearchGraphUtils.patternFromDag(dag);
            System.out.println("\nstandard = " + standard);
            GraphWithParameters generatingGraph = ExploreFastIca.makeRandomDagWithParms(dag);
            DagGeneratorParameters generatingParameters = new DagGeneratorParameters(nNodes, maxNoParents);
            PwpPlusGeneratingParameters pwpWithParms = new PwpPlusGeneratingParameters(generatingParameters, generatingGraph);
            HashMap<SemLearningMethod, EvaluationResult> evalSet = ExploreFastIca.doRun(pwpWithParms, sampleSize, distr, methods, evaluateAsPattern);
            evalTable.add(evalSet);
        }
        return evalTable;
    }

    private static HashMap<SemLearningMethod, EvaluationResult> doRun(PwpPlusGeneratingParameters pwpWithParms, int sampleSize, Distribution distr, List<SemLearningMethod> methods, boolean evaluateAsPattern) {
        DoubleMatrix2D inVectors = ExploreFastIca.simulate(pwpWithParms.generatingPwp, sampleSize, distr);
        System.out.println("inVectors (truncated) = " + ExploreFastIca.truncate(inVectors));
        ColtDataSet dataSet = ColtDataSet.makeContinuousData(pwpWithParms.generatingPwp.getGraph().getNodes(), inVectors.viewDice());
        return ExploreFastIca.doRun(dataSet, pwpWithParms, methods, evaluateAsPattern);
    }

    private static HashMap<SemLearningMethod, EvaluationResult> doRun(DataSet dataSet, PwpPlusGeneratingParameters pwpWithParms, List<SemLearningMethod> methods, boolean evaluateAsPattern) {
        HashMap<SemLearningMethod, EvaluationResult> evals = new HashMap<SemLearningMethod, EvaluationResult>();
        for (SemLearningMethod method : methods) {
            System.out.println("437: before, edgesToEvaluateCoeffs = " + edgesToEvaluateCoeffs);
            String s = "*************** Running " + method.getName() + " ****************";
            String stars = ExploreFastIca.stringMultiply("*", s.length());
            System.out.println(stars);
            System.out.println(s);
            System.out.println(stars);
            GraphWithParameters standard = !evaluateAsPattern ? pwpWithParms.generatingPwp : new GraphWithParameters(SearchGraphUtils.patternFromDag((Dag)pwpWithParms.generatingPwp.getGraph()));
            PwpPlusGeneratingParameters standardPwpPlusParms = new PwpPlusGeneratingParameters(pwpWithParms.generatingParameters, standard);
            GraphWithParameters estimatedGraph = method.run(dataSet, !evaluateAsPattern, standardPwpPlusParms);
            System.out.println("437: after, edgesToEvaluateCoeffs = " + edgesToEvaluateCoeffs);
            EvaluationResult eval = estimatedGraph == null ? null : (!evaluateAsPattern ? ExploreFastIca.evaluateGraph(estimatedGraph, standard, method.getName(), true, true, true, edgesToEvaluateCoeffs) : ExploreFastIca.evaluatePattern(estimatedGraph, standard, method.getName()));
            evals.put(method, eval);
        }
        return evals;
    }

    private static EvaluationResult evaluatePattern(GraphWithParameters estimatedGraph, GraphWithParameters standard, String methodName) {
        EvaluationResult.AdjacencyEvaluationResult adj = estimatedGraph.evalAdjacency(standard.getGraph());
        EvaluationResult.OrientationEvaluationResult ori = estimatedGraph.evalOrientations(standard.getGraph());
        EvaluationResult.PatternEvaluationResult pat = new EvaluationResult.PatternEvaluationResult(adj, ori);
        EvaluationResult result = new EvaluationResult(methodName, pat);
        return result;
    }

    private static void printComparisonSingleRun(String comparedAttribute, EvaluationResult eval1, EvaluationResult eval2, double loss1, double loss2) {
        double difference = loss1 - loss2;
        String s = difference != 0.0 ? (difference > 0.0 ? eval2 : eval1).name + " did better by " + difference : eval1.name + " and " + eval2.name + " tied!";
        System.out.println(comparedAttribute + ": " + "PC loss = " + loss1 + "  Shimizu loss = " + loss2 + ". " + s);
    }

    public static List<Edge> getDirectedEdges(Graph g) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : g.getEdges()) {
            if (!edge.isDirected()) continue;
            edges.add(edge);
        }
        return edges;
    }

    private static Dag twoNodeDag() {
        GraphNode node1 = new GraphNode("X1");
        GraphNode node2 = new GraphNode("X2");
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(node1);
        nodes.add(node2);
        Dag dag = new Dag(nodes);
        Edge edge = new Edge(node1, node2, Endpoint.TAIL, Endpoint.ARROW);
        dag.addEdge(edge);
        return dag;
    }

    private static void printRunHeader(int nNodes, int sampleSize, int maxNoParents, GaussianPower distr) {
        String s = "#### nNodes = " + nNodes + ", sampleSize = " + sampleSize + ", maxParents = " + maxNoParents + ", distr = " + distr.getName() + " ####";
        String hashes = ExploreFastIca.stringMultiply("#", s.length());
        System.out.println(hashes);
        System.out.println(s);
        System.out.println(hashes);
    }

    private static void printRunHeader(int nNodes, int sampleSize, int maxNoParents, GaussianPower distr, int runN) {
        String s = "#### nNodes = " + nNodes + ", sampleSize = " + sampleSize + ", maxParents = " + maxNoParents + ", distr = " + distr.getName() + ", run = " + runN + " ####";
        String hashes = ExploreFastIca.stringMultiply("#", s.length());
        System.out.println(hashes);
        System.out.println(hashes);
        System.out.println(s);
        System.out.println(hashes);
        System.out.println(hashes);
    }

    private static boolean hasCorrespondingEdge(Graph graph, Edge edge) {
        Node node2;
        String nodeName1 = edge.getNode1().getName();
        String nodeName2 = edge.getNode2().getName();
        Node node1 = graph.getNode(nodeName1);
        Edge corrEdge = graph.getDirectedEdge(node1, node2 = graph.getNode(nodeName2));
        return corrEdge != null;
    }

    private static EvaluationResult evaluateGraph(GraphWithParameters graph, GraphWithParameters standard, String methodName, boolean evalAdjacency, boolean evalOrientation, boolean evalCoeffs, List<Edge> edgesToEvaluateCoeffs) {
        System.out.println("");
        System.out.println("****************************************************");
        System.out.println("************* Evaluating " + methodName + " ***************");
        System.out.println("****************************************************");
        EvaluationResult.AdjacencyEvaluationResult adj = null;
        EvaluationResult.OrientationEvaluationResult ori = null;
        EvaluationResult.CoefficientEvaluationResult coeffAll = null;
        EvaluationResult.CoefficientEvaluationResult coeffSome = null;
        if (evalAdjacency) {
            adj = graph.evalAdjacency((Dag)standard.getGraph());
            graph.printAdjacencyEvaluation();
            totalErrorsOfOmission += graph.errorsOfOmission;
            totalErrorsOfCommission += graph.errorsOfCommission;
        }
        if (evalOrientation) {
            ori = graph.evalOrientations((Dag)standard.getGraph());
            graph.printOrientationEvaluation();
            totalOriCorrect += graph.oriCorrect;
            totalOriEvaluated += graph.oriEvaluated;
        }
        if (evalCoeffs) {
            System.out.println("== evaluating all node pairs ==");
            coeffAll = graph.evalCoeffs(standard);
            graph.printCoefficientEvaluation();
            if (edgesToEvaluateCoeffs != null) {
                System.out.println("== evaluating some node pairs ==");
                coeffSome = graph.evalCoeffsForNodePairs(standard, edgesToEvaluateCoeffs);
            }
            graph.printCoefficientEvaluation();
        }
        return new EvaluationResult(methodName, adj, ori, coeffAll, coeffSome);
    }

    private static String truncate(DoubleMatrix2D mat) {
        int MAX_LENGTH = 15;
        int n = mat.columns() > MAX_LENGTH ? MAX_LENGTH : mat.columns();
        DenseDoubleMatrix2D res = new DenseDoubleMatrix2D(mat.rows(), n);
        for (int j = 0; j < n; ++j) {
            res.viewColumn(j).assign(mat.viewColumn(j));
        }
        return res.toString();
    }

    private static DoubleMatrix2D reducedForm(GraphWithParameters graph) {
        int n = graph.getGraph().getNumNodes();
        DoubleMatrix2D graphMatrix = graph.getGraphMatrix().getDoubleData();
        DoubleMatrix2D identityMinusGraphMatrix = MatrixUtils.linearCombination(MatrixUtils.identityMatrix(n), 1.0, graphMatrix, -1.0);
        DoubleMatrix2D mixingMatrix = MatrixUtils.inverse(identityMinusGraphMatrix);
        return mixingMatrix;
    }

    private static DoubleMatrix1D simulateReducedForm(DoubleMatrix2D reducedForm, DoubleMatrix1D errorCoefficients, Distribution distr) {
        int n = reducedForm.rows();
        DenseDoubleMatrix1D vector = new DenseDoubleMatrix1D(n);
        DenseDoubleMatrix1D samples = new DenseDoubleMatrix1D(n);
        for (int j = 0; j < n; ++j) {
            double sample = distr.nextRandom();
            double errorCoefficient = errorCoefficients.get(j);
            samples.set(j, sample * errorCoefficient);
        }
        for (int i = 0; i < n; ++i) {
            double sum = 0.0;
            for (int j = 0; j < n; ++j) {
                double coefficient = reducedForm.get(i, j);
                double sample = samples.get(j);
                sum += coefficient * sample;
            }
            vector.set(i, sum);
        }
        return vector;
    }

    public static DoubleMatrix1D simulate(GraphWithParameters dwp, Distribution distribution) {
        DagWithParmsAndValues dpv = new DagWithParmsAndValues(dwp);
        Dag dag = (Dag)dwp.getGraph();
        HashMap<Edge, Double> weightHash = dwp.getWeightHash();
        HashMap<Node, Double> valueHash = dpv.valueHash;
        List<Node> exogenousTerms = dag.getExogenousTerms();
        for (int i = 0; i < exogenousTerms.size(); ++i) {
            Node node = exogenousTerms.get(i);
            double value = distribution.nextRandom();
            valueHash.put(node, value);
        }
        List<Node> nodes = dwp.getGraph().getNodes();
        List<Node> nodesWithoutValue = ExploreFastIca.setMinus(nodes, exogenousTerms);
        for (int count = 0; !ExploreFastIca.allHaveValues(valueHash, nodes) && count < 20; ++count) {
            for (int i = 0; i < nodesWithoutValue.size(); ++i) {
                Node node = nodesWithoutValue.get(i);
                List<Node> parents = dag.getParents(node);
                if (!ExploreFastIca.allHaveValues(valueHash, parents)) continue;
                double nodeValue = distribution.nextRandom();
                for (int j = 0; j < parents.size(); ++j) {
                    Node parent = parents.get(j);
                    double parentValue = valueHash.get(parent);
                    Edge edge = dag.getDirectedEdge(parent, node);
                    double edgeWeight = weightHash.get(edge);
                    nodeValue += edgeWeight * parentValue;
                }
                dpv.valueHash.put(node, nodeValue);
                nodesWithoutValue.remove(node);
                --i;
            }
        }
        DenseDoubleMatrix1D vector = new DenseDoubleMatrix1D(dwp.getGraph().getNumNodes());
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            vector.set(i, dpv.valueHash.get(node));
        }
        return vector;
    }

    private static List<Node> setMinus(List<Node> l1, List<Node> l2) {
        Vector<Node> result = new Vector<Node>(l1);
        for (int i = 0; i < l2.size(); ++i) {
            result.remove(l2.get(i));
        }
        return result;
    }

    public static DoubleMatrix2D simulate(GraphWithParameters dwp, int n, Distribution distribution) {
        DenseDoubleMatrix2D vectors = new DenseDoubleMatrix2D(dwp.getGraph().getNumNodes(), n);
        for (int j = 0; j < n; ++j) {
            DoubleMatrix1D vector = ExploreFastIca.simulate(dwp, distribution);
            vectors.viewColumn(j).assign(vector);
        }
        return vectors;
    }

    public static DoubleMatrix2D simulate_Cyclic(GraphWithParameters dwp, DoubleMatrix1D errorCoefficients, int n, Distribution distribution) {
        Object errorCoeffMatrix = null;
        DoubleMatrix2D reducedForm = ExploreFastIca.reducedForm(dwp);
        System.out.println("reducedForm = " + reducedForm);
        DenseDoubleMatrix2D vectors = new DenseDoubleMatrix2D(dwp.getGraph().getNumNodes(), n);
        for (int j = 0; j < n; ++j) {
            DoubleMatrix1D vector = ExploreFastIca.simulateReducedForm(reducedForm, errorCoefficients, distribution);
            vectors.viewColumn(j).assign(vector);
        }
        return vectors;
    }

    private static boolean allHaveValues(HashMap weightHash, List<Node> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (weightHash.get(node) != null) continue;
            return false;
        }
        return true;
    }

    private static DoubleMatrix2D example_line(int n) {
        DoubleMatrix1D e1 = ExploreFastIca.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e2 = ExploreFastIca.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e3 = ExploreFastIca.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D x1 = e1;
        DoubleMatrix1D x2 = ExploreFastIca.linearCombination(x1, 1.0, e2, 0.07);
        DoubleMatrix1D x3 = ExploreFastIca.linearCombination(x2, 1.0, e3, 0.05);
        DoubleMatrix1D[] observedVars = new DoubleMatrix1D[]{x1, x2, x3};
        return ExploreFastIca.combine(observedVars);
    }

    private static DoubleMatrix2D example_Y(int n) {
        DoubleMatrix1D e1 = ExploreFastIca.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e2 = ExploreFastIca.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e3 = ExploreFastIca.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e4 = ExploreFastIca.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e5 = ExploreFastIca.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D x1 = e1;
        DoubleMatrix1D x2 = e2;
        DoubleMatrix1D x3 = ExploreFastIca.linearCombination(ExploreFastIca.linearCombination(x1, 1.0, x2, 2.0), 1.0, e3, 1.0);
        DoubleMatrix1D x4 = ExploreFastIca.linearCombination(x3, 1.5, e4, 1.0);
        DoubleMatrix1D x5 = ExploreFastIca.linearCombination(x1, 1.0, e5, 1.0);
        DoubleMatrix1D[] observedVars = new DoubleMatrix1D[]{x1, x2, x3, x4, x5};
        return ExploreFastIca.combine(observedVars);
    }

    private static DoubleMatrix2D example_completeDag(int n) {
        DoubleMatrix1D e1 = ExploreFastIca.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e2 = ExploreFastIca.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e3 = ExploreFastIca.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e4 = ExploreFastIca.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D x1 = e1;
        DoubleMatrix1D[] vars2 = new DoubleMatrix1D[]{x1, e2};
        double[] ws2 = new double[]{2.0, 1.0};
        DoubleMatrix1D x2 = ExploreFastIca.linearCombination(vars2, ws2);
        DoubleMatrix1D[] vars3 = new DoubleMatrix1D[]{x1, x2, e3};
        double[] ws3 = new double[]{3.0, 0.0, 1.0};
        DoubleMatrix1D x3 = ExploreFastIca.linearCombination(vars3, ws3);
        DoubleMatrix1D[] vars4 = new DoubleMatrix1D[]{x1, x2, x3, e4};
        double[] ws4 = new double[]{1.0, 1.0, -1.0, 1.0};
        DoubleMatrix1D x4 = ExploreFastIca.linearCombination(vars4, ws4);
        DoubleMatrix1D[] observedVars = new DoubleMatrix1D[]{x1, x2, x3, x4};
        return ExploreFastIca.combine(observedVars);
    }

    private static DoubleMatrix2D example_completeDagSG(int n) {
        DoubleMatrix1D e1 = ExploreFastIca.generateSquaredGaussian(n);
        DoubleMatrix1D e2 = ExploreFastIca.generateSquaredGaussian(n);
        DoubleMatrix1D e3 = ExploreFastIca.generateSquaredGaussian(n);
        DoubleMatrix1D e4 = ExploreFastIca.generateSquaredGaussian(n);
        DoubleMatrix1D x1 = e1;
        DoubleMatrix1D[] vars2 = new DoubleMatrix1D[]{x1, e2};
        double[] ws2 = new double[]{2.0, 1.0};
        DoubleMatrix1D x2 = ExploreFastIca.linearCombination(vars2, ws2);
        DoubleMatrix1D[] vars3 = new DoubleMatrix1D[]{x1, x2, e3};
        double[] ws3 = new double[]{3.0, 0.0, 1.0};
        DoubleMatrix1D x3 = ExploreFastIca.linearCombination(vars3, ws3);
        DoubleMatrix1D[] vars4 = new DoubleMatrix1D[]{x1, x2, x3, e4};
        double[] ws4 = new double[]{1.0, 1.0, -1.0, 1.0};
        DoubleMatrix1D x4 = ExploreFastIca.linearCombination(vars4, ws4);
        DoubleMatrix1D[] observedVars = new DoubleMatrix1D[]{x1, x2, x3, x4};
        return ExploreFastIca.combine(observedVars);
    }

    private static DoubleMatrix2D example_Straight(int n) {
        DoubleMatrix1D e1 = ExploreFastIca.generateFourthGaussian(n);
        DoubleMatrix1D e2 = ExploreFastIca.generateAlmostGaussian(n);
        DoubleMatrix1D x1 = e1;
        DoubleMatrix1D[] vars2 = new DoubleMatrix1D[]{x1, e2};
        double[] ws2 = new double[]{1.0, 1.0};
        DoubleMatrix1D x2 = ExploreFastIca.linearCombination(vars2, ws2);
        DoubleMatrix1D[] observedVars = new DoubleMatrix1D[]{x1, x2};
        return ExploreFastIca.combine(observedVars);
    }

    private static DoubleMatrix2D example_Reverse(int n) {
        DoubleMatrix1D e1 = ExploreFastIca.generateAlmostGaussian(n);
        DoubleMatrix1D e2 = ExploreFastIca.generateFourthGaussian(n);
        DoubleMatrix1D x1 = e1;
        DoubleMatrix1D[] vars2 = new DoubleMatrix1D[]{x1, e2};
        double[] ws2 = new double[]{1.0, 1.0};
        DoubleMatrix1D x2 = ExploreFastIca.linearCombination(vars2, ws2);
        DoubleMatrix1D[] observedVars = new DoubleMatrix1D[]{x1, x2};
        return ExploreFastIca.combine(observedVars);
    }

    private static DoubleMatrix2D combine(DoubleMatrix1D[] vecs) {
        DenseDoubleMatrix2D resultMatrix = new DenseDoubleMatrix2D(vecs.length, vecs[0].size());
        for (int i = 0; i < vecs.length; ++i) {
            resultMatrix.viewRow(i).assign(vecs[i]);
        }
        return resultMatrix;
    }

    private static DoubleMatrix1D linearCombination(DoubleMatrix1D a, double aw, DoubleMatrix1D b, double bw) {
        DenseDoubleMatrix1D resultMatrix = new DenseDoubleMatrix1D(a.size());
        for (int i = 0; i < a.size(); ++i) {
            resultMatrix.set(i, aw * a.get(i) + bw * b.get(i));
        }
        return resultMatrix;
    }

    private static DoubleMatrix1D linearCombination(DoubleMatrix1D[] vecs, double[] weights) {
        DenseDoubleMatrix1D resultMatrix = new DenseDoubleMatrix1D(vecs[0].size());
        for (int i = 0; i < vecs[0].size(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < vecs.length; ++j) {
                sum += vecs[j].get(i) * weights[j];
            }
            resultMatrix.set(i, sum);
        }
        return resultMatrix;
    }

    private static DoubleMatrix2D linearCombination(DoubleMatrix2D a, double aw, DoubleMatrix2D b, double bw) {
        for (int i = 0; i < a.rows(); ++i) {
        }
        DenseDoubleMatrix2D resultMatrix = new DenseDoubleMatrix2D(a.rows(), a.columns());
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                resultMatrix.set(i, j, aw * a.get(i, j) + bw * b.get(i, j));
                if (i != j) continue;
            }
        }
        return resultMatrix;
    }

    private static DataSet readData(String filename) {
        DataReader p = new DataReader();
        File inFile = new File(filename);
        try {
            return p.parseTabular(inFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DoubleMatrix2D generateBimodal2DGaussian(int n) {
        DenseDoubleMatrix2D vectors = new DenseDoubleMatrix2D(2, n);
        for (int i = 0; i < n; ++i) {
            double y;
            double x;
            if (Math.random() < 0.5) {
                x = ExploreFastIca.Gaussian_invcdf(Math.random()) - 10.0;
                y = ExploreFastIca.Gaussian_invcdf(Math.random());
            } else {
                x = ExploreFastIca.Gaussian_invcdf(Math.random()) + 10.0;
                y = ExploreFastIca.Gaussian_invcdf(Math.random());
            }
            vectors.set(0, i, x);
            vectors.set(1, i, y);
        }
        return vectors;
    }

    public static DoubleMatrix2D generate2DGaussian(int n) {
        DenseDoubleMatrix2D vectors = new DenseDoubleMatrix2D(2, n);
        RandomUtil r = RandomUtil.getInstance();
        for (int i = 0; i < n; ++i) {
            vectors.set(0, i, r.nextNormal(0.0, 1.0));
            vectors.set(1, i, r.nextNormal(0.0, 1.0));
        }
        return vectors;
    }

    public static DoubleMatrix1D generateAlmostGaussian(int n) {
        DenseDoubleMatrix1D points = new DenseDoubleMatrix1D(n);
        RandomUtil r = RandomUtil.getInstance();
        for (int i = 0; i < n; ++i) {
            if (r.nextDouble() < 0.95) {
                points.set(i, r.nextNormal(0.0, 1.0));
                continue;
            }
            points.set(i, r.nextNormal(0.0, 1.0) + 2.0);
        }
        return points;
    }

    public static DoubleMatrix1D generateGaussian(int n) {
        DenseDoubleMatrix1D points = new DenseDoubleMatrix1D(n);
        RandomUtil r = RandomUtil.getInstance();
        for (int i = 0; i < n; ++i) {
            points.set(i, r.nextNormal(0.0, 1.0));
        }
        return points;
    }

    public static DoubleMatrix1D generateSquaredGaussian(int n) {
        DenseDoubleMatrix1D points = new DenseDoubleMatrix1D(n);
        RandomUtil r = RandomUtil.getInstance();
        for (int i = 0; i < n; ++i) {
            points.set(i, Math.pow(r.nextNormal(0.0, 1.0), 2.0));
        }
        return points;
    }

    public static DoubleMatrix1D generateFourthGaussian(int n) {
        DenseDoubleMatrix1D points = new DenseDoubleMatrix1D(n);
        RandomUtil r = RandomUtil.getInstance();
        for (int i = 0; i < n; ++i) {
            points.set(i, Math.pow(r.nextNormal(0.0, 1.0), 4.0));
        }
        return points;
    }

    public static double generateUniform(double a, double b) {
        double length = b - a;
        double x = a + length * Math.random();
        return x;
    }

    public static DoubleMatrix1D generateUniform(double a, double b, int n) {
        DenseDoubleMatrix1D points = new DenseDoubleMatrix1D(n);
        double length = b - a;
        for (int i = 0; i < n; ++i) {
            double x = a + length * Math.random();
            points.set(i, x);
        }
        return points;
    }

    private static double Gaussian_invcdf(double x) {
        double[] table = new double[]{0.0, 0.0398, 0.0793, 0.1179, 0.1554, 0.1915, 0.2257, 0.258, 0.2881, 0.3159, 0.3413, 0.3643, 0.3849, 0.4032, 0.4192, 0.4332, 0.4452, 0.4554, 0.4641, 0.4713, 0.4772, 0.4821, 0.4861, 0.4893, 0.4918, 0.4938, 0.4953, 0.4965, 0.4974, 0.4981, 0.4987, 0.5};
        if (x > 0.5) {
            int index = ExploreFastIca.getLastSmallerIndex(x - 0.5, table);
            double interpol = ExploreFastIca.interpolate(0.5 + table[index], 0.5 + table[index + 1], (double)index * 0.1, (double)(index + 1) * 0.1, x);
            System.out.println("x = " + x + "    interpol = " + interpol);
            return interpol;
        }
        double ix = 1.0 - x;
        int index = ExploreFastIca.getLastSmallerIndex(ix - 0.5, table);
        double interpol = ExploreFastIca.interpolate(0.5 + table[index], 0.5 + table[index + 1], (double)index * 0.1, (double)(index + 1) * 0.1, ix);
        System.out.println("x = " + x + "    -interpol = " + -interpol);
        return -interpol;
    }

    private static double interpolate(double x1, double x2, double y1, double y2, double x) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double slope = dy / dx;
        return y1 + slope * (x - x1);
    }

    private static int getLastSmallerIndex(double d, double[] table) {
        for (int i = 0; i < table.length; ++i) {
            if (!(table[i] > d)) continue;
            return i - 1;
        }
        return -1;
    }

    public static DoubleMatrix2D convertToColt(double[][] vectors) {
        int m = Matrix.getNumOfRows(vectors);
        int n = Matrix.getNumOfColumns(vectors);
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                mat.set(i, j, vectors[i][j]);
            }
        }
        return mat;
    }

    public static double[] convert(DoubleMatrix1D vector) {
        int n = vector.size();
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = vector.get(i);
        }
        return v;
    }

    public static double[][] convert(DoubleMatrix2D inVectors) {
        if (inVectors == null) {
            return null;
        }
        int m = inVectors.rows();
        int n = inVectors.columns();
        double[][] inV = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                inV[i][j] = inVectors.get(i, j);
            }
        }
        return inV;
    }

    static {
        globalCoeffErrorScoreTrue = 0.0;
        globalNEdgesEvaluatedTrue = 0;
        totalOriCorrect = 0;
        totalOriEvaluated = 0;
        totalErrorsOfOmission = 0;
        totalErrorsOfCommission = 0;
    }

    public static final class Invert
    implements DoubleFunction {
        @Override
        public double apply(double d) {
            return 1.0 / d;
        }
    }

    static class PwpPlusGeneratingParameters {
        DagGeneratorParameters generatingParameters;
        GraphWithParameters generatingPwp;

        public PwpPlusGeneratingParameters(DagGeneratorParameters generatingParameters, GraphWithParameters pwp) {
            this.generatingParameters = generatingParameters;
            this.generatingPwp = pwp;
        }
    }

    static class DagGeneratorParameters {
        int nNodes;
        int maxNoParents;

        public DagGeneratorParameters(int nNodes, int maxNoParents) {
            this.nNodes = nNodes;
            this.maxNoParents = maxNoParents;
        }
    }

    public static class DagWithParmsAndValues {
        public GraphWithParameters dwp;
        public HashMap<Node, Double> valueHash;

        public DagWithParmsAndValues(GraphWithParameters dwp) {
            this.dwp = dwp;
            this.valueHash = new HashMap();
        }
    }
}

