/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Fas2 {
    private Graph graph;
    private IndependenceTest test;
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private int numIndependenceTests;
    private TetradLogger logger = TetradLogger.getInstance();
    private Graph trueGraph;
    private int numFalseDependenceJudgments;
    private int numDependenceJudgement;
    private SepsetMap sepset;
    private Map<Node, List<Node>> envelopes;

    public Fas2(Graph graph, IndependenceTest test, Map<Node, List<Node>> envelopes) {
        this.graph = graph;
        this.test = test;
        this.envelopes = envelopes;
    }

    public Graph search() {
        boolean more;
        this.logger.log("info", "Starting Fast Adjacency Search.");
        List<Edge> edges = this.graph.getEdges();
        for (Edge _edge : edges) {
            String name2;
            String name1 = _edge.getNode1().getName();
            if (!this.knowledge.edgeForbidden(name1, name2 = _edge.getNode2().getName()) || !this.knowledge.edgeForbidden(name2, name1)) continue;
            this.graph.removeEdge(_edge);
            this.logger.log("edgeRemoved", "Removed " + _edge + " because it was " + "forbidden by background knowledge.");
        }
        SepsetMap sepset = new SepsetMap();
        int _depth = this.depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        for (int d = 0; d <= _depth && (more = this.searchAtDepth(this.graph, this.test, this.getKnowledge(), sepset, d)); ++d) {
        }
        this.logger.log("info", "Finishing Fast Adjacency Search.");
        this.sepset = sepset;
        return this.graph;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException("Cannot set knowledge to null");
        }
        this.knowledge = knowledge;
    }

    private List<Node> possibleParents(Node x, List<Node> adjx, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z = z.getName();
            if (!this.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        boolean possibleParent;
        boolean bl = possibleParent = !knowledge.edgeForbidden(z, x) && !knowledge.edgeRequired(x, z);
        if (possibleParent && z.equals("CITES") && (x.equals("PUBS") || x.equals("PREPROD"))) {
            System.out.println(knowledge.edgeForbidden("CITES", "PUBS"));
            System.out.println(knowledge.edgeForbidden("CITES", "PREPROD"));
            System.out.println(z + " is a possible parent of " + x);
        }
        return possibleParent;
    }

    private boolean searchAtDepth(Graph graph, IndependenceTest test, Knowledge knowledge, SepsetMap sepset, int depth) {
        boolean more = false;
        LinkedList<Node> nodes = new LinkedList<Node>(graph.getNodes());
        for (Node x : nodes) {
            LinkedList<Node> b = new LinkedList<Node>(graph.getAdjacentNodes(x));
            if (this.envelopes != null) {
                for (Node node : this.envelopes.get(x)) {
                    if (b.contains(node)) continue;
                    b.add(node);
                }
            }
            block4: for (Node y : b) {
                int[] choice;
                List<Node> adjx = graph.getAdjacentNodes(x);
                if (this.envelopes != null) {
                    for (Node node : this.envelopes.get(x)) {
                        if (adjx.contains(node)) continue;
                        adjx.add(node);
                    }
                }
                adjx.remove(y);
                List<Node> ppx = this.possibleParents(x, adjx, knowledge);
                boolean noEdgeRequired = knowledge.noEdgeRequired(x.getName(), y.getName());
                if (ppx.size() < depth) continue;
                ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), depth);
                while ((choice = cg.next()) != null) {
                    List<Node> condSet = SearchGraphUtils.asList(choice, ppx);
                    boolean independent = false;
                    try {
                        independent = test.isIndependent(x, y, condSet);
                    }
                    catch (Exception e) {
                        independent = false;
                    }
                    ++this.numIndependenceTests;
                    if (this.trueGraph != null) {
                        double p;
                        IndTestDSep testDSep = new IndTestDSep(this.trueGraph);
                        Node _x = testDSep.getVariable(x.getName());
                        Node _y = testDSep.getVariable(y.getName());
                        ArrayList<Node> _condSet = new ArrayList<Node>();
                        for (Node node : condSet) {
                            _condSet.add(testDSep.getVariable(node.getName()));
                        }
                        boolean trueIndep = testDSep.isIndependent(_x, _y, _condSet);
                        if (!independent && trueIndep) {
                            ++this.numFalseDependenceJudgments;
                        }
                        if (!independent) {
                            ++this.numDependenceJudgement;
                        }
                        if ((p = test.getPValue()) > 0.8 && !trueIndep) {
                            System.out.println("ROGUE DEPENDENCY! P = " + p + " fact = " + SearchLogUtils.independenceFact(x, y, condSet));
                        }
                    }
                    if (!independent || !noEdgeRequired) continue;
                    graph.removeEdge(x, y);
                    sepset.set(x, y, new LinkedList<Node>(condSet));
                    continue block4;
                }
            }
            if (graph.getAdjacentNodes(x).size() - 1 <= depth) continue;
            more = true;
        }
        return more;
    }

    public int getNumIndependenceTests() {
        return this.numIndependenceTests;
    }

    public void setTrueGraph(Graph trueGraph) {
        this.trueGraph = trueGraph;
    }

    public int getNumFalseDependenceJudgments() {
        return this.numFalseDependenceJudgments;
    }

    public int getNumDependenceJudgments() {
        return this.numDependenceJudgement;
    }

    public SepsetMap getSepsets() {
        return this.sepset;
    }
}

