/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.ResolveSepsets;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SepsetMapDci;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FasDci {
    private Graph graph;
    private Set<Node> variables = new HashSet<Node>();
    private IndependenceTest independenceTest;
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private int numIndependenceTests;
    private String method;
    private List<Set<Node>> marginalVars;
    private List<IndependenceTest> independenceTests;
    private SepsetMapDci knownIndependencies;
    private SepsetMapDci knownAssociations;
    private TetradLogger logger = TetradLogger.getInstance();

    public FasDci(Graph graph, IndependenceTest independenceTest) {
        this.graph = graph;
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
    }

    public FasDci(Graph graph, IndependenceTest independenceTest, String method, List<Set<Node>> marginalVars, List<IndependenceTest> independenceTests, SepsetMapDci knownIndependencies, SepsetMapDci knownAssociations) {
        this.graph = graph;
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
        this.method = method;
        this.marginalVars = marginalVars;
        this.independenceTests = independenceTests;
        this.knownIndependencies = knownIndependencies;
        this.knownAssociations = knownAssociations;
    }

    public SepsetMapDci search() {
        boolean more;
        this.logger.log("info", "Starting Fast Adjacency Search (DCI).");
        List<Edge> edges = this.graph.getEdges();
        for (Edge _edge : edges) {
            String name2;
            String name1 = _edge.getNode1().getName();
            if (!this.knowledge.edgeForbidden(name1, name2 = _edge.getNode2().getName()) || !this.knowledge.edgeForbidden(name2, name1)) continue;
            this.graph.removeEdge(_edge);
            this.logger.log("edgeRemoved", "Removed " + _edge + " because it was " + "forbidden by background knowledge.");
        }
        SepsetMapDci sepset = new SepsetMapDci();
        int _depth = this.depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        for (int d = 0; d <= _depth && (more = this.searchAtDepth(this.graph, this.independenceTest, new Knowledge(), sepset, d)); ++d) {
        }
        this.logger.log("info", "Finishing Fast Adjacency Search.");
        return sepset;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException("Cannot set knowledge to null");
        }
        this.knowledge = knowledge;
    }

    private List<Node> possibleParents(Node x, List<Node> adjx, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z = z.getName();
            if (!this.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        return !knowledge.edgeForbidden(z, x) && !knowledge.edgeRequired(x, z);
    }

    private boolean searchAtDepth(Graph graph, IndependenceTest independenceTest, Knowledge knowledge, SepsetMapDci sepset, int depth) {
        boolean more = false;
        for (Node x : this.variables) {
            LinkedList<Node> b = new LinkedList<Node>();
            for (Node node : graph.getAdjacentNodes(x)) {
                if (!this.variables.contains(node)) continue;
                b.add(node);
            }
            block2: for (Node y : b) {
                int[] choice;
                ArrayList<Node> adjx = new ArrayList<Node>(b);
                adjx.remove(y);
                List<Node> ppx = this.possibleParents(x, adjx, knowledge);
                boolean noEdgeRequired = knowledge.noEdgeRequired(x.getName(), y.getName());
                if (ppx.size() < depth) continue;
                ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), depth);
                while ((choice = cg.next()) != null) {
                    List<Node> condSet = SearchGraphUtils.asList(choice, ppx);
                    boolean independent = false;
                    boolean known = false;
                    if (this.knownIndependencies != null && this.knownIndependencies.get(x, y) != null) {
                        for (List<Node> set : this.knownIndependencies.getSet(x, y)) {
                            if (!set.containsAll(condSet) || set.size() != condSet.size()) continue;
                            independent = true;
                            known = true;
                            break;
                        }
                    }
                    if (this.knownAssociations != null && this.knownAssociations.get(x, y) != null) {
                        for (List<Node> set : this.knownAssociations.getSet(x, y)) {
                            if (!set.containsAll(condSet) || set.size() != condSet.size()) continue;
                            independent = false;
                            known = true;
                            break;
                        }
                    }
                    if (!known) {
                        independent = independenceTest.isIndependent(x, y, condSet);
                        if (this.method != null) {
                            ArrayList<IndependenceTest> testsWithVars = new ArrayList<IndependenceTest>();
                            for (int k = 0; k < this.marginalVars.size(); ++k) {
                                Set<Node> marginalSet = this.marginalVars.get(k);
                                if (!marginalSet.contains(x) || !marginalSet.contains(y) || !marginalSet.containsAll(condSet)) continue;
                                testsWithVars.add(this.independenceTests.get(k));
                            }
                            boolean inconsistency = false;
                            for (IndependenceTest testWithVars : testsWithVars) {
                                if (testWithVars.isIndependent(x, y, condSet) == independent) continue;
                                inconsistency = true;
                                break;
                            }
                            if (inconsistency) {
                                independent = ResolveSepsets.isIndependentPooled(this.method, testsWithVars, x, y, condSet);
                            }
                        }
                        ++this.numIndependenceTests;
                    }
                    if (!independent || !noEdgeRequired) continue;
                    graph.removeEdge(x, y);
                    sepset.set(x, y, new LinkedList<Node>(condSet));
                    continue block2;
                }
            }
            ArrayList<Node> currentAdjNodes = new ArrayList<Node>();
            for (Node node : graph.getAdjacentNodes(x)) {
                if (!this.variables.contains(node)) continue;
                currentAdjNodes.add(node);
            }
            if (currentAdjNodes.size() - 1 <= depth) continue;
            more = true;
        }
        return more;
    }

    public int getNumIndependenceTests() {
        return this.numIndependenceTests;
    }
}

