/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class FasDeterministic {
    private Graph graph;
    private IndependenceTest test;
    private Knowledge knowledge;
    private int depth = Integer.MAX_VALUE;

    public FasDeterministic(Graph graph, IndependenceTest test) {
        this.graph = graph;
        this.test = test;
    }

    public SepsetMap search() {
        TetradLogger.getInstance().log("info", "Starting Fast Adjacency Search.");
        List<Edge> edges = this.graph.getEdges();
        for (Edge edge1 : edges) {
            String name1 = edge1.getNode1().getName();
            String name2 = edge1.getNode2().getName();
            if (!this.getKnowledge().edgeForbidden(name1, name2) || !this.getKnowledge().edgeForbidden(name2, name1)) continue;
            this.graph.removeEdge(edge1);
            TetradLogger.getInstance().log("edgeRemoved", "Removed " + edge1 + " because it was " + "forbidden by background knowledge.");
        }
        String message = "Depth = " + (this.getDepth() == Integer.MAX_VALUE ? "Unlimited" : Integer.toString(this.getDepth()));
        TetradLogger.getInstance().log("info", message);
        SepsetMap sepset = new SepsetMap();
        int _depth = this.getDepth();
        if (_depth == -1) {
            _depth = Integer.MAX_VALUE;
        }
        for (int d = 0; d <= _depth && this.searchAtDepth(this.graph, this.test, this.getKnowledge(), sepset, d); ++d) {
        }
        TetradLogger.getInstance().log("info", "Finishing Fast Adjacency Search.");
        return sepset;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException("Cannot set knowledge to null");
        }
        this.knowledge = knowledge;
    }

    private List<Node> possibleParents(Node x, Node y, List<Node> nodes, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        String _y = y.getName();
        for (Node z : nodes) {
            String _z = z.getName();
            if (!this.possibleParentOf(_z, _x, _y, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, String y, Knowledge knowledge) {
        if (knowledge.edgeForbidden(z, x)) {
            return false;
        }
        if (knowledge.edgeForbidden(z, y)) {
            return false;
        }
        if (knowledge.edgeRequired(x, z)) {
            return false;
        }
        return !knowledge.edgeRequired(y, z);
    }

    private boolean searchAtDepth(Graph graph, IndependenceTest test, Knowledge knowledge, SepsetMap sepset, int depth) {
        boolean more = false;
        LinkedList<Node> nodes = new LinkedList<Node>(graph.getNodes());
        for (Node x : nodes) {
            LinkedList<Node> b = new LinkedList<Node>(graph.getAdjacentNodes(x));
            block3: for (Node y : b) {
                int[] choice;
                List<Node> adjx = graph.getAdjacentNodes(x);
                adjx.remove(y);
                List<Node> ppx = this.possibleParents(x, y, adjx, knowledge);
                boolean noEdgeRequired = knowledge.noEdgeRequired(x.getName(), y.getName());
                if (ppx.size() < depth) continue;
                ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), depth);
                while ((choice = cg.next()) != null) {
                    boolean splitdetermines;
                    List<Node> condSet = SearchGraphUtils.asList(choice, ppx);
                    List<Node> _x = Collections.singletonList(x);
                    boolean determines = test.determines(_x, y);
                    boolean bl = splitdetermines = test.determines(condSet, x) || test.determines(condSet, y);
                    if (determines) {
                        TetradLogger.getInstance().log("info", _x + " determines " + y);
                    }
                    if (splitdetermines) {
                        TetradLogger.getInstance().log("info", condSet + " split determines " + x + " and " + y);
                    }
                    if (determines || splitdetermines) continue;
                    boolean independent = false;
                    try {
                        independent = test.isIndependent(x, y, condSet);
                    }
                    catch (Exception e) {
                        TetradLogger.getInstance().log("info", "The score for independence test " + SearchLogUtils.independenceFact(x, y, condSet) + " was undefined.");
                    }
                    if (!independent || !noEdgeRequired) continue;
                    graph.removeEdge(x, y);
                    sepset.set(x, y, new LinkedList<Node>(condSet));
                    continue block3;
                }
            }
            if (graph.getAdjacentNodes(x).size() - 1 <= depth) continue;
            more = true;
        }
        return more;
    }
}

