/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.search.ChiSquareTest;
import edu.cmu.tetrad.util.CombinationIterator;
import edu.cmu.tetrad.util.ProbUtils;
import java.util.Arrays;

public final class GSquareTest
extends ChiSquareTest {
    public GSquareTest(DataSet dataSet, double alpha) {
        super(dataSet, alpha);
    }

    public Result calcGSquare(int[] testIndices) {
        double pValue;
        this.getCellTable().addToTable(this.getDataSet(), testIndices);
        int[] firstVar = new int[]{0};
        int[] secondVar = new int[]{1};
        int[] bothVars = new int[]{0, 1};
        double g2 = 0.0;
        int df = 0;
        int[] condDims = new int[testIndices.length - 2];
        System.arraycopy(this.selectFromArray(this.getDims(), testIndices), 2, condDims, 0, condDims.length);
        int[] coords = new int[testIndices.length];
        int numRows = this.getCellTable().getNumValues(0);
        int numCols = this.getCellTable().getNumValues(1);
        boolean[] attestedRows = new boolean[numRows];
        boolean[] attestedCols = new boolean[numCols];
        CombinationIterator combinationIterator = new CombinationIterator(condDims);
        while (combinationIterator.hasNext()) {
            int[] combination = (int[])combinationIterator.next();
            System.arraycopy(combination, 0, coords, 2, combination.length);
            Arrays.fill(attestedRows, true);
            Arrays.fill(attestedCols, true);
            long total = this.getCellTable().calcMargin(coords, bothVars);
            if (total == 0L) continue;
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    coords[0] = i;
                    coords[1] = j;
                    long sumRow = this.getCellTable().calcMargin(coords, secondVar);
                    long sumCol = this.getCellTable().calcMargin(coords, firstVar);
                    long observed = (int)this.getCellTable().getValue(coords);
                    boolean skip = false;
                    if (sumRow == 0L) {
                        attestedRows[i] = false;
                        skip = true;
                    }
                    if (sumCol == 0L) {
                        attestedCols[j] = false;
                        skip = true;
                    }
                    if (skip) continue;
                    double expected = (double)(sumCol * sumRow) / (double)total;
                    if (observed == 0L) continue;
                    g2 += 2.0 * (double)observed * Math.log((double)observed / expected);
                }
            }
            int numAttestedRows = 0;
            int numAttestedCols = 0;
            for (boolean attestedRow : attestedRows) {
                if (!attestedRow) continue;
                ++numAttestedRows;
            }
            for (boolean attestedCol : attestedCols) {
                if (!attestedCol) continue;
                ++numAttestedCols;
            }
            df += (numAttestedRows - 1) * (numAttestedCols - 1);
        }
        if (df == 0) {
            df = 1;
        }
        boolean indep = (pValue = 1.0 - ProbUtils.chisqCdf(g2, df)) > this.getAlpha();
        return new Result(g2, pValue, df, indep);
    }

    public static final class Result {
        private final double gSquare;
        private final double pValue;
        private final int df;
        private final boolean isIndep;

        public Result(double gSquare, double pValue, int df, boolean isIndep) {
            this.gSquare = gSquare;
            this.pValue = pValue;
            this.df = df;
            this.isIndep = isIndep;
        }

        public final double getGSquare() {
            return this.gSquare;
        }

        public final double getPValue() {
            return this.pValue;
        }

        public final int getDf() {
            return this.df;
        }

        public final boolean isIndep() {
            return this.isIndep;
        }
    }
}

