/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Ges;
import edu.cmu.tetrad.search.MbSearch;
import edu.cmu.tetrad.search.MbUtils;
import java.util.List;

public class GesMbSearch
implements MbSearch {
    private DataSet dataSet;

    public GesMbSearch(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public List<Node> findMb(String targetName) {
        Node target = this.getVariableForName(targetName);
        Ges search = new Ges(this.dataSet);
        Graph graph = search.search();
        MbUtils.trimToMbNodes(graph, target, false);
        List<Node> mbVariables = graph.getNodes();
        mbVariables.remove(target);
        return mbVariables;
    }

    @Override
    public String getAlgorithmName() {
        return "GESMB";
    }

    @Override
    public int getNumIndependenceTests() {
        return 0;
    }

    private Node getVariableForName(String targetVariableName) {
        Node target = null;
        for (Node V : this.dataSet.getVariables()) {
            if (!V.getName().equals(targetVariableName)) continue;
            target = V;
            break;
        }
        if (target == null) {
            throw new IllegalArgumentException("Target variable not in dataset: " + targetVariableName);
        }
        return target;
    }
}

