/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MbSearch;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class HitonOld
implements MbSearch {
    private IndependenceTest test;
    private List<Node> variables;
    private int depth;
    private Graph markovBlanket;

    public HitonOld(IndependenceTest test, int depth) {
        if (test == null) {
            throw new NullPointerException();
        }
        this.test = test;
        this.depth = depth;
        this.variables = test.getVariables();
    }

    public Graph search(String targetVariableName) {
        if (targetVariableName == null) {
            throw new IllegalArgumentException("Null target name not permitted");
        }
        Node W = null;
        for (Node variable : this.variables) {
            if (!variable.getName().equals(targetVariableName)) continue;
            W = variable;
            break;
        }
        if (W == null) {
            throw new IllegalArgumentException("Target variable not in dataset.");
        }
        TetradLogger.getInstance().log("details", "target = " + targetVariableName + " W = " + W);
        TetradLogger.getInstance().log("details", "Will use HITON procedure.");
        List<Node> associated = this.hitonMb(targetVariableName);
        if (!associated.contains(W)) {
            associated.add(W);
        }
        TetradLogger.getInstance().log("details", "Variables ouput by findRamsey--used in PC Search");
        for (Node V : associated) {
            TetradLogger.getInstance().log("details", "" + V);
        }
        TetradLogger.getInstance().log("details", "Size of associated = " + associated.size());
        IndependenceTest indAssociated = this.test.indTestSubset(associated);
        TetradLogger.getInstance().log("details", "Entering step 4");
        Pc pcAssociated = new Pc(indAssociated);
        if (this.depth > 0) {
            pcAssociated.setDepth(this.depth);
        }
        Graph associatedPattern = pcAssociated.search();
        TetradLogger.getInstance().log("details", "Pattern produced by PC algorithm");
        TetradLogger.getInstance().log("details", "" + associatedPattern);
        TetradLogger.getInstance().log("details", "\nEntering step 5.");
        List<Node> adjW = associatedPattern.getAdjacentNodes(W);
        for (Node x : adjW) {
            if ((associatedPattern.getEndpoint(W, x) != Endpoint.ARROW || associatedPattern.getEndpoint(x, W) != Endpoint.ARROW) && (associatedPattern.getEndpoint(W, x) != Endpoint.TAIL || associatedPattern.getEndpoint(x, W) != Endpoint.TAIL)) continue;
            associatedPattern.setEndpoint(W, x, Endpoint.ARROW);
            associatedPattern.setEndpoint(x, W, Endpoint.TAIL);
            TetradLogger.getInstance().log("details", "Setting edge " + W + "-->" + x);
        }
        TetradLogger.getInstance().log("details", "\nEntering Step 6.");
        List<Node> parentsOfW = associatedPattern.getParents(W);
        for (Node x : parentsOfW) {
            List<Node> adjX = associatedPattern.getAdjacentNodes(x);
            for (Node y : adjX) {
                if (y == W) continue;
                associatedPattern.removeEdge(y, x);
            }
        }
        TetradLogger.getInstance().log("details", "\nEntering Step 7.");
        List<Edge> allEdges = associatedPattern.getEdges();
        for (Edge edge : allEdges) {
            Endpoint fromEndpoint = edge.getEndpoint1();
            Endpoint toEndpoint = edge.getEndpoint2();
            Node fromNode = edge.getNode1();
            Node toNode = edge.getNode2();
            if ((fromEndpoint != Endpoint.ARROW || toEndpoint != Endpoint.ARROW) && (fromEndpoint != Endpoint.TAIL || toEndpoint != Endpoint.TAIL)) continue;
            if (associatedPattern.isChildOf(fromNode, W) && !associatedPattern.isChildOf(toNode, W)) {
                associatedPattern.setEndpoint(toNode, fromNode, Endpoint.ARROW);
                associatedPattern.setEndpoint(fromNode, toNode, Endpoint.TAIL);
                continue;
            }
            if (associatedPattern.isChildOf(toNode, W) && !associatedPattern.isChildOf(fromNode, W)) {
                associatedPattern.setEndpoint(fromNode, toNode, Endpoint.ARROW);
                associatedPattern.setEndpoint(toNode, fromNode, Endpoint.TAIL);
                continue;
            }
            associatedPattern.removeEdge(fromNode, toNode);
        }
        List<Node> childrenOfW = associatedPattern.getChildren(W);
        parentsOfW = associatedPattern.getParents(W);
        TetradLogger.getInstance().log("details", "\nEntering Step 8.");
        HashSet<Node> remaining = new HashSet<Node>();
        remaining.add(W);
        for (Node parent : parentsOfW) {
            remaining.add(parent);
        }
        for (Node child : childrenOfW) {
            remaining.add(child);
        }
        for (Node child : childrenOfW) {
            List<Node> parChild = associatedPattern.getAdjacentNodes(child);
            for (Node parentOfChild : parChild) {
                remaining.add(parentOfChild);
            }
        }
        if (!remaining.contains(W)) {
            throw new IllegalArgumentException("Target missing from MB");
        }
        TetradLogger.getInstance().log("details", "After Step 8 there are " + remaining.size() + " variables remaining.");
        LinkedList<Node> remainingList = new LinkedList<Node>(remaining);
        this.markovBlanket = associatedPattern.subgraph(remainingList);
        TetradLogger.getInstance().log("details", "\nEntering Step 9.");
        List<Node> parents = this.markovBlanket.getParents(W);
        for (Node parent : parents) {
            List<Node> parPar = this.markovBlanket.getParents(parent);
            for (Node parentPar : parPar) {
                this.markovBlanket.removeEdge(parentPar, parent);
            }
        }
        List<Node> children = this.markovBlanket.getChildren(W);
        for (Node child : children) {
            List<Node> childChild = this.markovBlanket.getChildren(child);
            for (Node childCh : childChild) {
                this.markovBlanket.removeEdge(childCh, child);
            }
        }
        TetradLogger.getInstance().log("details", "\nEntering Step 10.");
        childrenOfW = this.markovBlanket.getChildren(W);
        LinkedList<Node> parentsOfChildren = new LinkedList<Node>();
        for (Node child : childrenOfW) {
            List<Node> parChild = this.markovBlanket.getParents(child);
            for (Node parentOfChild : parChild) {
                if (parentOfChild == W) continue;
                parentsOfChildren.add(parentOfChild);
            }
        }
        for (int i = 0; i < parentsOfChildren.size(); ++i) {
            Node childParent1 = (Node)parentsOfChildren.get(i);
            for (int j = 0; j < parentsOfChildren.size(); ++j) {
                if (i == j) continue;
                Node childParent2 = (Node)parentsOfChildren.get(j);
                this.markovBlanket.removeEdge(childParent1, childParent2);
            }
        }
        for (Node r : remainingList) {
            if (!this.markovBlanket.getEdges(r).isEmpty()) continue;
            this.markovBlanket.removeNode(r);
        }
        TetradLogger.getInstance().log("details", "DEBUG: Markov Blanket after Step 10");
        TetradLogger.getInstance().log("details", "" + this.markovBlanket);
        return this.markovBlanket;
    }

    public List<Node> hitonPc(String targetName) {
        Node[] sortedVars;
        Node t = this.getVariableForName(targetName);
        LinkedList<Node> currentPc = new LinkedList<Node>();
        for (Node node : sortedVars = this.maxAssoc(t, this.variables)) {
            currentPc.add(node);
            block1: for (Node x : new LinkedList<Node>(currentPc)) {
                int index = currentPc.indexOf(x);
                currentPc.remove(x);
                for (int d = 0; d <= Math.min(this.depth, currentPc.size()); ++d) {
                    int[] indices;
                    ChoiceGenerator cg = new ChoiceGenerator(currentPc.size(), d);
                    while ((indices = cg.next()) != null) {
                        LinkedList<Node> condSet = new LinkedList<Node>();
                        for (int k = 0; k < d; ++k) {
                            condSet.add(currentPc.get(indices[k]));
                        }
                        if (!this.test.isIndependent(x, t, condSet)) continue;
                        currentPc.remove(x);
                        continue block1;
                    }
                }
                currentPc.add(index, x);
            }
        }
        return currentPc;
    }

    @Override
    public List<Node> findMb(String targetName) {
        return this.hitonMb(targetName);
    }

    @Override
    public String getAlgorithmName() {
        return "HITON";
    }

    @Override
    public int getNumIndependenceTests() {
        return 0;
    }

    public List<Node> hitonMb(String targetName) {
        Node t = this.getVariableForName(targetName);
        List<Node> pc = this.hitonPc(targetName);
        LinkedList<Node> currentMb = new LinkedList<Node>();
        for (Node node : pc) {
            List<Node> pcOfPc = this.hitonPc(node.getName());
            for (Node v : pcOfPc) {
                if (currentMb.contains(v)) continue;
                currentMb.add(v);
            }
        }
        for (Node node : pc) {
            if (currentMb.contains(node)) continue;
            currentMb.add(node);
        }
        LinkedList currentMbCopy = new LinkedList(currentMb);
        block3: for (Node x : currentMbCopy) {
            if (x == t) continue;
            TetradLogger.getInstance().log("details", "x = " + x);
            LinkedList<Node> vMinusTx = new LinkedList<Node>(this.variables);
            vMinusTx.remove(t);
            vMinusTx.remove(x);
            for (Node y : pc) {
                if (y == x || y == t) continue;
                TetradLogger.getInstance().log("details", "y = " + y);
                for (int d = 0; d <= Math.min(this.depth, vMinusTx.size()); ++d) {
                    int[] indices;
                    TetradLogger.getInstance().log("details", "Cond sets of d " + d);
                    ChoiceGenerator cg = new ChoiceGenerator(vMinusTx.size(), d);
                    while ((indices = cg.next()) != null) {
                        LinkedList<Node> cond = new LinkedList<Node>();
                        for (int k : indices) {
                            cond.add((Node)vMinusTx.get(k));
                        }
                        if (!cond.contains(y)) {
                            cond.add(y);
                        }
                        if (!this.test.isIndependent(x, t, cond)) continue;
                        currentMb.remove(x);
                        continue block3;
                    }
                }
            }
        }
        return currentMb;
    }

    public Node[] maxAssoc(Node target, List<Node> variables) {
        if (target == null) {
            throw new IllegalArgumentException("Null target name not permitted");
        }
        Object[] vsp = new VariableScorePair[variables.size()];
        int numberElements = 0;
        for (Node possibleAssoc : variables) {
            if (possibleAssoc == target) continue;
            this.test.isIndependent(target, possibleAssoc, new LinkedList<Node>());
            double score = this.test.getPValue();
            int index = variables.indexOf(possibleAssoc);
            vsp[numberElements] = new VariableScorePair(possibleAssoc, score, index);
            ++numberElements;
        }
        Arrays.sort(vsp, 0, numberElements);
        Node[] varsInOrder = new Node[numberElements];
        for (int i = 0; i < numberElements; ++i) {
            Object pair = vsp[numberElements - i - 1];
            varsInOrder[i] = ((VariableScorePair)pair).getVariable();
        }
        return varsInOrder;
    }

    public Graph getMarkovBlanket() {
        return this.markovBlanket;
    }

    private Node getVariableForName(String targetName) {
        Node target = null;
        for (Node V : this.variables) {
            if (!V.getName().equals(targetName)) continue;
            target = V;
            break;
        }
        if (target == null) {
            throw new IllegalArgumentException("Target variable not in dataset: " + targetName);
        }
        return target;
    }

    private static class VariableScorePair
    implements Comparable {
        private Node v;
        private double score;
        private int index;

        public VariableScorePair(Node v, double score, int index) {
            this.v = v;
            this.score = score;
            this.index = index;
        }

        public Node getVariable() {
            return this.v;
        }

        public double getScore() {
            return this.score;
        }

        public int getIndex() {
            return this.index;
        }

        public int compareTo(Object other) {
            if (this.getScore() < ((VariableScorePair)other).getScore()) {
                return 1;
            }
            if (this.getScore() == ((VariableScorePair)other).getScore()) {
                return 0;
            }
            return -1;
        }
    }
}

