/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.SepsetMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class IONSearchOriginal {
    private Graph[] Gsub;
    private int n;
    private List[][][] sepsets;
    private Knowledge bk;
    private Graph G;
    private boolean[][] confirmed;
    private static final Endpoint NONE = null;
    private static final Endpoint NULL = Endpoint.TAIL;
    private static final Endpoint ARROW = Endpoint.ARROW;
    private static final Endpoint CIRCLE = Endpoint.CIRCLE;

    public IONSearchOriginal(Graph[] Gsub, List[][][] sepsets, Knowledge bk) {
        this.Gsub = Gsub;
        this.sepsets = sepsets;
        this.bk = bk;
        this.n = Gsub.length;
    }

    public IONSearchOriginal(Graph[] Gsub, SepsetMap[] sepSets, Knowledge bk) {
        this.Gsub = Gsub;
        this.n = Gsub.length;
        this.sepsets = new ArrayList[this.n][][];
        this.bk = bk;
        for (int i = 0; i < this.n; ++i) {
            List<Node> v = Gsub[i].getNodes();
            this.sepsets[i] = new ArrayList[v.size()][v.size()];
            for (int j = 0; j < v.size(); ++j) {
                Node x = v.get(j);
                for (int k = 0; k < v.size(); ++k) {
                    if (j == k) continue;
                    Node y = v.get(k);
                    this.sepsets[i][j][k] = sepSets[i].get(x, y) == null ? null : new ArrayList<Node>(sepSets[i].get(x, y));
                }
            }
        }
    }

    public Graph search() {
        List[] Vsub = new List[this.n];
        ArrayList<Node> V = new ArrayList<Node>();
        for (int i = 0; i < this.n; ++i) {
            Vsub[i] = this.Gsub[i].getNodes();
            for (Node node : Vsub[i]) {
                if (V.contains(node)) continue;
                V.add(node);
            }
        }
        int nVnodes = V.size();
        this.confirmed = new boolean[nVnodes][nVnodes];
        for (int i = 0; i < nVnodes; ++i) {
            for (int j = 0; j < nVnodes; ++j) {
                this.confirmed[i][j] = false;
            }
        }
        this.G = new EdgeListGraph(V);
        this.G.fullyConnect(CIRCLE);
        if (!this.bk.isEmpty()) {
            Iterator itv;
            Node nodeB;
            Node nodeA;
            String B;
            String A;
            Iterator<KnowledgeEdge> req = this.bk.requiredEdgesIterator();
            while (req.hasNext()) {
                KnowledgeEdge reqEdge = req.next();
                A = reqEdge.getFrom();
                B = reqEdge.getTo();
                nodeA = null;
                nodeB = null;
                itv = V.iterator();
                while (itv.hasNext() && !A.equals((nodeA = (Node)itv.next()).getName())) {
                }
                itv = V.iterator();
                while (itv.hasNext() && !B.equals((nodeB = (Node)itv.next()).getName())) {
                }
                this.G.setEndpoint(nodeA, nodeB, ARROW);
                this.G.setEndpoint(nodeB, nodeA, NULL);
                System.out.println("In IonSearch.search confirming edge between " + nodeA.getName() + " " + nodeB.getName() + V.indexOf(nodeA) + " " + V.indexOf(nodeB));
                this.confirmed[V.indexOf((Object)nodeA)][V.indexOf((Object)nodeB)] = true;
                this.confirmed[V.indexOf((Object)nodeB)][V.indexOf((Object)nodeA)] = true;
            }
            Iterator<KnowledgeEdge> fbd = this.bk.forbiddenEdgesIterator();
            while (fbd.hasNext()) {
                KnowledgeEdge reqEdge = fbd.next();
                A = reqEdge.getFrom();
                B = reqEdge.getTo();
                nodeA = null;
                nodeB = null;
                itv = V.iterator();
                while (itv.hasNext() && !A.equals((nodeA = (Node)itv.next()).getName())) {
                }
                itv = V.iterator();
                while (itv.hasNext() && !B.equals((nodeB = (Node)itv.next()).getName())) {
                }
                this.G.setEndpoint(nodeA, nodeB, NONE);
                this.G.setEndpoint(nodeB, nodeA, NONE);
            }
        }
        for (int i = 0; i < this.n; ++i) {
            int nNodes = Vsub[i].size();
            for (int x = 0; x < nNodes; ++x) {
                for (int y = x + 1; y < nNodes; ++y) {
                    if (this.Gsub[i].isAdjacentTo((Node)Vsub[i].get(x), (Node)Vsub[i].get(y))) continue;
                    this.G.removeEdge((Node)Vsub[i].get(x), (Node)Vsub[i].get(y));
                    boolean remove = true;
                    for (Node isPotAnc : this.sepsets[i][x][y]) {
                        if (!this.isPotentialAncestor(this.Gsub[i], isPotAnc, (Node)Vsub[i].get(x))) continue;
                        remove = false;
                        break;
                    }
                    if (remove) {
                        List<Node> ancestorsX = this.getDefiniteAncestors((Node)Vsub[i].get(x));
                        for (int j = 0; j < this.n; ++j) {
                            for (Node isDefAnc : Vsub[j]) {
                                if (!this.getDefiniteAncestors((Node)Vsub[i].get(x)).contains(isDefAnc)) continue;
                                this.G.removeEdge((Node)Vsub[i].get(y), isDefAnc);
                            }
                        }
                    }
                    remove = true;
                    for (Node isPotAnc : this.sepsets[i][x][y]) {
                        if (!this.isPotentialAncestor(this.Gsub[i], isPotAnc, (Node)Vsub[i].get(y))) continue;
                        remove = false;
                        break;
                    }
                    if (!remove) continue;
                    for (int j = 0; j < this.n; ++j) {
                        for (Node isDefAnc : Vsub[j]) {
                            if (!this.getDefiniteAncestors((Node)Vsub[i].get(y)).contains(isDefAnc)) continue;
                            this.G.removeEdge((Node)Vsub[i].get(x), isDefAnc);
                        }
                    }
                }
            }
        }
        for (int j = 0; j < this.n; ++j) {
            for (Node nodex : Vsub[j]) {
                List<Node> adjacentNodes = this.Gsub[j].getNodesOutTo(nodex, ARROW);
                for (Node nodey : adjacentNodes) {
                    Endpoint fromEndPoint = this.Gsub[j].getEndpoint(nodey, nodex);
                    if (fromEndPoint != NULL && fromEndPoint != CIRCLE || !this.G.isAdjacentTo(nodex, nodey)) continue;
                    this.G.setEndpoint(nodex, nodey, ARROW);
                    this.G.setEndpoint(nodey, nodex, fromEndPoint);
                }
            }
        }
        for (int x = 0; x < nVnodes; ++x) {
            for (int y = x + 1; y < nVnodes; ++y) {
                Node Y;
                Node X;
                if (x == y || !this.G.isAdjacentTo(X = (Node)V.get(x), Y = (Node)V.get(y))) continue;
                boolean commit = false;
                List<Node> varT = this.getVarsOnTreks(this.G, X, Y);
                ArrayList<Node> varTUnionXY = new ArrayList<Node>(varT);
                varTUnionXY.add(X);
                varTUnionXY.add(Y);
                for (int i = 0; i < this.n; ++i) {
                    if (!Vsub[i].contains(X) || !Vsub[i].contains(Y)) continue;
                    boolean subset = true;
                    for (Node v : varTUnionXY) {
                        if (Vsub[i].contains(v)) continue;
                        subset = false;
                    }
                    if (!subset) continue;
                    commit = true;
                }
                if (!commit) continue;
                this.confirmed[x][y] = true;
                this.confirmed[y][x] = true;
            }
        }
        return this.G;
    }

    public boolean[][] getConfirmed() {
        return this.confirmed;
    }

    private boolean isDefiniteAncestor(Graph g, Node nodeFrom, Node nodeTo) {
        return g.existsDirectedPathFromTo(nodeFrom, nodeTo);
    }

    private List<Node> getDefiniteAncestors(Node nodeTo) {
        ArrayList<Node> ancestors = new ArrayList<Node>();
        for (int i = 0; i < this.n; ++i) {
            Graph g = this.Gsub[i];
            List<Node> vars = g.getNodes();
            if (!vars.contains(nodeTo)) continue;
            for (Node v : vars) {
                if (g.getEndpoint(v, nodeTo) != ARROW || g.getEndpoint(nodeTo, v) != NULL) continue;
                ancestors.add(v);
            }
        }
        int numAnc = ancestors.size();
        for (int i = 0; i < numAnc; ++i) {
            Node ancestor = (Node)ancestors.get(i);
            List<Node> ancestorAncestors = this.getDefiniteAncestors(ancestor);
            for (Node aa : ancestorAncestors) {
                if (ancestors.contains(aa)) continue;
                ancestors.add(aa);
                ++numAnc;
            }
        }
        return ancestors;
    }

    private List<Node> getVarsOnTreks(Graph g, Node nodex, Node nodey) {
        ArrayList<Node> varT = new ArrayList<Node>();
        List<Node> adjacentToX = g.getAdjacentNodes(nodex);
        for (Node adjNode : adjacentToX) {
            ArrayList<Node> currentPath = new ArrayList<Node>();
            currentPath.add(nodex);
            if (adjNode == nodey) continue;
            if (!currentPath.contains(adjNode)) {
                currentPath.add(adjNode);
            }
            this.buildPath(g, currentPath, varT, nodey);
        }
        varT.remove(nodex);
        return varT;
    }

    private void buildPath(Graph g, List<Node> currentPath, List<Node> onPotTrek, Node endPoint) {
        int last = currentPath.size() - 1;
        Node currentLast = currentPath.get(last);
        List<Node> adjacentToCurrentLast = g.getAdjacentNodes(currentLast);
        for (Node nextNode : adjacentToCurrentLast) {
            if (currentPath.contains(nextNode) || g.getEndpoint(currentPath.get(last - 1), currentLast) == ARROW && g.getEndpoint(currentLast, nextNode) == ARROW) continue;
            if (nextNode == endPoint) {
                for (Node cpNode : currentPath) {
                    if (onPotTrek.contains(cpNode)) continue;
                    onPotTrek.add(cpNode);
                }
                continue;
            }
            currentPath.add(nextNode);
            this.buildPath(g, currentPath, onPotTrek, endPoint);
        }
        currentPath.remove(currentLast);
    }

    private boolean isPotentialAncestor(Graph g, Node nodeFrom, Node nodeTo) {
        HashSet<Node> s = new HashSet<Node>();
        return this.potentialPathFind(s, g, nodeFrom, nodeTo);
    }

    private boolean potentialPathFind(Set<Node> s, Graph g, Node nodeFrom, Node nodeTo) {
        if (nodeFrom == nodeTo) {
            return false;
        }
        if (g.getEndpoint(nodeFrom, nodeTo) != NONE && g.getEndpoint(nodeTo, nodeFrom) != ARROW && g.getEndpoint(nodeTo, nodeFrom) != NONE) {
            return true;
        }
        s.add(nodeFrom);
        for (Node o : g.getAdjacentNodes(nodeFrom)) {
            if (s.contains(o) || g.getEndpoint(nodeFrom, o) == NONE || g.getEndpoint(o, nodeFrom) == ARROW || g.getEndpoint(o, nodeFrom) == NONE || !this.potentialPathFind(s, g, o, nodeTo)) continue;
            return true;
        }
        return false;
    }
}

