/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.Images;
import java.util.List;

public class ImagesFirstNontriangular
implements GraphSearch {
    private Knowledge knowledge = new Knowledge();
    private List<DataSet> dataSets;

    public ImagesFirstNontriangular(List<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    @Override
    public Graph search() {
        Graph pattern = new EdgeListGraph();
        for (int c = 1; c < 150; ++c) {
            System.out.println("\n\n** c = " + c);
            Images images = new Images(this.dataSets);
            images.setPenaltyDiscount(c + 1);
            images.setKnowledge(this.getKnowledge());
            pattern = images.search();
            boolean nextDDisconnects = pattern.getAdjacentNodes(pattern.getNode("I")).isEmpty();
            images.setPenaltyDiscount(c);
            pattern = images.search();
            if (!this.containsTriangle(pattern)) {
                System.out.println("No triangle!");
            }
            if (nextDDisconnects) {
                System.out.println("Input variable disconnected for c = " + (c + 1));
            }
            if (!this.containsTriangle(pattern) || nextDDisconnects) break;
        }
        return pattern;
    }

    @Override
    public long getElapsedTime() {
        return 0L;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    private boolean containsTriangle(Graph graph) {
        int numNodes = graph.getNumNodes();
        List<Node> nodes = graph.getNodes();
        for (int j1 = 0; j1 < numNodes; ++j1) {
            for (int j2 = j1; j2 < numNodes; ++j2) {
                for (int j3 = j2; j3 < numNodes; ++j3) {
                    if (!graph.isAdjacentTo(nodes.get(j1), nodes.get(j2)) || !graph.isAdjacentTo(nodes.get(j1), nodes.get(j3)) || !graph.isAdjacentTo(nodes.get(j2), nodes.get(j3))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

