/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndTestFisherZGeneralizedInverse;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class IndTestFisherZBootstrap
implements IndependenceTest {
    private final CovarianceMatrix covMatrix;
    private final List<Node> variables;
    private double alpha = 0.05;
    private double thresh = Double.NaN;
    private double fishersZ;
    private IndTestFisherZGeneralizedInverse deterministicTest;
    private DataSet dataSet;
    private int numBootstrapSamples;
    private int bootstrapSampleSize;
    private DoubleMatrix2D[] bootstrapSamples;
    private IndependenceTest[] tests;

    public IndTestFisherZBootstrap(DataSet dataSet, double alpha, int numBootstrapSamples, int bootstrapSampleSize) {
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        this.covMatrix = new CovarianceMatrix(dataSet);
        this.dataSet = dataSet;
        this.variables = Collections.unmodifiableList(this.covMatrix.getVariables());
        this.setAlpha(alpha);
        this.deterministicTest = new IndTestFisherZGeneralizedInverse(dataSet, alpha);
        this.numBootstrapSamples = numBootstrapSamples;
        this.bootstrapSampleSize = bootstrapSampleSize;
        this.bootstrapSamples = new DoubleMatrix2D[numBootstrapSamples];
        this.tests = new IndependenceTest[numBootstrapSamples];
        for (int i = 0; i < numBootstrapSamples; ++i) {
            DoubleMatrix2D fullData = dataSet.getDoubleData();
            this.bootstrapSamples[i] = this.getBootstrapSample(fullData, bootstrapSampleSize);
            this.tests[i] = new IndTestFisherZ(this.bootstrapSamples[i], dataSet.getVariables(), alpha);
        }
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        return null;
    }

    @Override
    public boolean isIndependent(Node x, Node y, List<Node> z) {
        boolean independent;
        int[] independentGuys = new int[this.numBootstrapSamples];
        for (int i = 0; i < this.numBootstrapSamples; ++i) {
            independent = this.tests[i].isIndependent(x, y, z);
            independentGuys[i] = independent ? 1 : 0;
        }
        int sum = 0;
        for (int i = 0; i < this.numBootstrapSamples; ++i) {
            sum += independentGuys[i];
        }
        boolean bl = independent = sum > this.numBootstrapSamples / 2;
        if (independent) {
            TetradLogger.getInstance().log("independencies", SearchLogUtils.independenceFactMsg(x, y, z, this.getPValue()));
        } else {
            TetradLogger.getInstance().log("dependencies", SearchLogUtils.dependenceFactMsg(x, y, z, this.getPValue()));
        }
        return independent;
    }

    @Override
    public boolean isIndependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isIndependent(x, y, zList);
    }

    @Override
    public boolean isDependent(Node x, Node y, List<Node> z) {
        return !this.isIndependent(x, y, z);
    }

    @Override
    public boolean isDependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isDependent(x, y, zList);
    }

    @Override
    public double getPValue() {
        return 0.0;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public boolean determines(List<Node> z, Node x1) {
        return false;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public String toString() {
        return "Fisher's Z Bootstrap";
    }

    private DoubleMatrix2D getBootstrapSample(DoubleMatrix2D data, int sampleSize) {
        int actualSampleSize = data.rows();
        int[] rows = new int[sampleSize];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = RandomUtil.getInstance().nextInt(actualSampleSize);
        }
        int[] cols = new int[data.columns()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = i;
        }
        return data.viewSelection(rows, cols);
    }

    @Override
    public DataSet getData() {
        return null;
    }
}

