/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.GSquareTest;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class IndTestGSquare
implements IndependenceTest {
    private GSquareTest gSquareTest;
    private List<Node> variables;
    private DataSet dataSet;
    private double alpha;
    private double gSquare;
    private double pValue;
    private double determinationP = 0.99;
    private static NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();

    public IndTestGSquare(DataSet dataSet, double alpha) {
        this.dataSet = dataSet;
        this.alpha = alpha;
        this.variables = new ArrayList<Node>(dataSet.getVariables());
        int[] numVals = new int[this.variables.size()];
        for (int i = 0; i < this.variables.size(); ++i) {
            DiscreteVariable v = (DiscreteVariable)this.variables.get(i);
            numVals[i] = v.getNumCategories();
        }
        this.gSquareTest = new GSquareTest(dataSet, alpha);
    }

    public IndependenceTest indTestSubset(List vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        int[] indices = new int[vars.size()];
        int j = -1;
        for (int i = 0; i < this.variables.size(); ++i) {
            if (!vars.contains(this.variables.get(i))) continue;
            indices[++j] = i;
        }
        DataSet newDataSet = this.dataSet.subsetColumns(indices);
        return new IndTestGSquare(newDataSet, this.alpha);
    }

    public double getGSquare() {
        return this.gSquare;
    }

    @Override
    public double getPValue() {
        return this.pValue;
    }

    @Override
    public boolean isIndependent(Node x, Node y, List<Node> z) {
        int i;
        if (x == null) {
            throw new NullPointerException();
        }
        if (y == null) {
            throw new NullPointerException();
        }
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        int[] testIndices = new int[2 + z.size()];
        testIndices[0] = this.variables.indexOf(x);
        testIndices[1] = this.variables.indexOf(y);
        for (i = 0; i < z.size(); ++i) {
            testIndices[i + 2] = this.variables.indexOf(z.get(i));
        }
        for (i = 0; i < testIndices.length; ++i) {
            if (testIndices[i] >= 0) continue;
            throw new IllegalArgumentException("Variable " + i + " was not used in the constructor.");
        }
        GSquareTest.Result result = this.gSquareTest.calcGSquare(testIndices);
        this.gSquare = result.getGSquare();
        this.pValue = result.getPValue();
        if (result.isIndep()) {
            StringBuilder sb = new StringBuilder();
            sb.append("INDEPENDENCE ACCEPTED: ");
            sb.append(SearchLogUtils.independenceFact(x, y, z));
            sb.append("\tp = ").append(nf.format(result.getPValue())).append("\tg^2 = ").append(nf.format(result.getGSquare())).append("\tdf = ").append(result.getDf());
            TetradLogger.getInstance().log("independencies", sb.toString());
        }
        return result.isIndep();
    }

    @Override
    public boolean isIndependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isIndependent(x, y, zList);
    }

    @Override
    public boolean isDependent(Node x, Node y, List<Node> z) {
        return !this.isIndependent(x, y, z);
    }

    @Override
    public boolean isDependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isDependent(x, y, zList);
    }

    @Override
    public void setAlpha(double alpha) {
        this.gSquareTest.setAlpha(alpha);
    }

    @Override
    public double getAlpha() {
        return this.gSquareTest.getAlpha();
    }

    @Override
    public List<Node> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public String toString() {
        return "G Square, alpha = " + nf.format(this.getAlpha());
    }

    @Override
    public boolean determines(List<Node> z, Node x1) {
        int i;
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        int[] testIndices = new int[1 + z.size()];
        testIndices[0] = this.variables.indexOf(x1);
        for (i = 0; i < z.size(); ++i) {
            testIndices[i + 1] = this.variables.indexOf(z.get(i));
        }
        for (i = 0; i < testIndices.length; ++i) {
            if (testIndices[i] >= 0) continue;
            throw new IllegalArgumentException("Variable " + i + "was not used in the constructor.");
        }
        boolean determined = this.gSquareTest.isDetermined(testIndices, this.getDeterminationP());
        if (determined) {
            StringBuilder sb = new StringBuilder();
            sb.append("Determination found: ").append(x1).append(" is determined by {");
            for (int i2 = 0; i2 < z.size(); ++i2) {
                sb.append(z.get(i2));
                if (i2 >= z.size() - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
            TetradLogger.getInstance().log("independencies", sb.toString());
        }
        return determined;
    }

    public double getDeterminationP() {
        return this.determinationP;
    }

    public void setDeterminationP(double determinationP) {
        this.determinationP = determinationP;
    }

    @Override
    public DataSet getData() {
        return null;
    }
}

