/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMapDci;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndTestSepset
implements IndependenceTest {
    private SepsetMapDci sepset;
    private Map<Node, Node> nodesToVariables;
    private Map<Node, Node> variablesToNodes;
    private List<Node> observedVars;

    public IndTestSepset(SepsetMapDci sepset, List<Node> nodes) {
        if (sepset == null) {
            throw new NullPointerException();
        }
        this.sepset = sepset;
        this.nodesToVariables = new HashMap<Node, Node>();
        this.variablesToNodes = new HashMap<Node, Node>();
        for (Node node : nodes) {
            this.nodesToVariables.put(node, node);
            this.variablesToNodes.put(node, node);
        }
        this.observedVars = this.calcObservedVars(nodes);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        for (Node var : vars) {
            if (this.getVariables().contains(var)) continue;
            throw new IllegalArgumentException("All vars must be original vars");
        }
        return this;
    }

    private List<Node> calcObservedVars(List<Node> nodes) {
        ArrayList<Node> observedVars = new ArrayList<Node>();
        for (Node node : nodes) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            observedVars.add(this.getVariable(node));
        }
        return observedVars;
    }

    @Override
    public boolean isIndependent(Node x, Node y, List<Node> z) {
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        boolean independent = false;
        if (this.sepset.get(x, y) != null) {
            List<List<Node>> condSets = this.sepset.getSet(x, y);
            for (List<Node> condSet : condSets) {
                if (condSet.size() != z.size() || !condSet.containsAll(z)) continue;
                double pValue = 1.0;
                TetradLogger.getInstance().log("independencies", SearchLogUtils.independenceFactMsg(x, y, z, pValue));
                independent = true;
                break;
            }
        }
        if (independent) {
            TetradLogger.getInstance().log("independencies", SearchLogUtils.independenceFactMsg(x, y, z, this.getPValue()));
        } else {
            TetradLogger.getInstance().log("dependencies", SearchLogUtils.dependenceFactMsg(x, y, z, this.getPValue()));
        }
        return independent;
    }

    @Override
    public boolean isIndependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isIndependent(x, y, zList);
    }

    @Override
    public boolean isDependent(Node x, Node y, List<Node> z) {
        return !this.isIndependent(x, y, z);
    }

    @Override
    public boolean isDependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isDependent(x, y, zList);
    }

    @Override
    public double getPValue() {
        return Double.NaN;
    }

    @Override
    public List<Node> getVariables() {
        return Collections.unmodifiableList(this.observedVars);
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> nodes = this.getVariables();
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (Node var : nodes) {
            nodeNames.add(var.getName());
        }
        return nodeNames;
    }

    public boolean determines(List z, Node x1) {
        return z.contains(x1);
    }

    @Override
    public double getAlpha() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAlpha(double alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public Node getVariable(Node node) {
        return this.nodesToVariables.get(node);
    }

    public Node getNode(Node variable) {
        return this.variablesToNodes.get(variable);
    }

    public String toString() {
        return "D-separation";
    }

    @Override
    public DataSet getData() {
        return null;
    }
}

