/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.GraphChange;
import edu.cmu.tetrad.search.IonHittingSet;
import edu.cmu.tetrad.search.PossibleDConnectingPath;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.TetradSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class IonSearch {
    private List<Graph> input = new ArrayList<Graph>();
    private List<Graph> output = new ArrayList<Graph>();
    private Set<NodePair> notadjacent = new HashSet<NodePair>();
    private List<Node> variables = new ArrayList<Node>();
    private static ReentrantLock lock = new ReentrantLock(true);
    private static ReentrantLock fclock = new ReentrantLock(true);
    private List<Integer> recGraphs = new ArrayList<Integer>();
    private List<Float> recHitTimes = new ArrayList<Float>();
    private long runtime;
    private boolean changeFlag = true;
    private boolean pathLengthSearch = false;
    private boolean adjacencySearch = true;
    private Set<IonIndependenceFacts> separations;
    private Set<IonIndependenceFacts> associations;
    private Set<Set<Set<Edge>>> necessaryTreks;
    private Set<Set<Set<Edge>>> currentNecessaryTreks = new HashSet<Set<Set<Edge>>>();
    private Graph currentGraph;
    private Set<Triple> currentTriples;
    private List<Triple> currentDiscriminatingColliders;
    private Set<Triple> currentPossibleColliders = new HashSet<Triple>();
    private long unshielded = 0L;
    private long discrim = 0L;
    private long coliter = 0L;
    private long dofinal = 0L;
    private long predicts = 0L;
    private long currentNecTreks = 0L;

    public IonSearch(List<Graph> pags) {
        for (Graph graph : pags) {
            EdgeListGraph newPag = new EdgeListGraph(graph);
            for (Triple triple : IonSearch.getAllTriples(newPag)) {
                if (!graph.isDefNoncollider(triple.getX(), triple.getY(), triple.getZ())) continue;
                newPag.addUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
            }
            this.input.add(newPag);
        }
        for (Graph pag : this.input) {
            for (Node node : pag.getNodes()) {
                if (this.variables.contains(node)) continue;
                this.variables.add(node);
            }
        }
    }

    public void setPathLengthSearch(boolean b) {
        this.pathLengthSearch = b;
    }

    public void setAdjacencySearch(boolean b) {
        this.adjacencySearch = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Graph> search() {
        long start = System.currentTimeMillis();
        TetradLogger.getInstance().log("info", "Starting ION Search.");
        IonSearch.logGraphs("\nInitial Pags: ", this.input);
        EdgeListGraph graph = new EdgeListGraph(this.variables);
        LinkedList<EdgeListGraph> searchPags = new LinkedList<EdgeListGraph>();
        graph.fullyConnect(Endpoint.CIRCLE);
        this.removeAdjacencies(graph);
        this.transferOrientations(graph);
        for (Node a : this.variables) {
            for (Node b : this.variables) {
                if (((Object)b).equals(a)) continue;
                for (Node c : this.variables) {
                    if (((Object)c).equals(b) || ((Object)c).equals(a) || !graph.isAncestorOf(a, b) || !graph.isAncestorOf(b, c)) continue;
                    graph.setEndpoint(a, c, Endpoint.ARROW);
                }
            }
        }
        this.preventColliders(graph);
        this.awayFromColliderAncestorCycle(graph);
        searchPags.offer(graph);
        List<Set<IonIndependenceFacts>> sepAndAssoc = this.findSepAndAssoc();
        this.separations = sepAndAssoc.get(0);
        this.associations = sepAndAssoc.get(1);
        LinkedList<Graph> step3Pags = new LinkedList<Graph>();
        HashSet<Graph> reject = new HashSet<Graph>();
        if (this.separations.isEmpty()) {
            this.doFinalOrientation(graph);
            step3Pags.add(graph);
        }
        int numNodes = graph.getNumNodes();
        int pl = numNodes - 1;
        if (this.pathLengthSearch) {
            pl = 2;
        }
        block12: for (int l = pl; l < numNodes; ++l) {
            int seps = this.separations.size();
            for (IonIndependenceFacts fact : this.separations) {
                System.out.println("Sep: " + seps);
                --seps;
                searchPags.addAll(step3Pags);
                this.recGraphs.add(searchPags.size());
                step3Pags.clear();
                while (!searchPags.isEmpty()) {
                    List list;
                    System.out.println("ION Step 3 size: " + searchPags.size());
                    Graph pag = (Graph)searchPags.poll();
                    ArrayList<PossibleDConnectingPath> dConnections = new ArrayList<PossibleDConnectingPath>();
                    if (this.adjacencySearch) {
                        for (List<Node> list2 : fact.getZ()) {
                            lock.lock();
                            try {
                                if (this.pathLengthSearch) {
                                    dConnections.addAll(PossibleDConnectingPath.findDConnectingPathsOfLength(pag, fact.getX(), fact.getY(), list2, l));
                                    continue;
                                }
                                dConnections.addAll(PossibleDConnectingPath.findDConnectingPaths(pag, fact.getX(), fact.getY(), list2));
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                    } else {
                        for (IonIndependenceFacts ionIndependenceFacts : this.separations) {
                            for (List<Node> conditions : ionIndependenceFacts.getZ()) {
                                lock.lock();
                                try {
                                    if (this.pathLengthSearch) {
                                        dConnections.addAll(PossibleDConnectingPath.findDConnectingPathsOfLength(pag, ionIndependenceFacts.getX(), ionIndependenceFacts.getY(), conditions, l));
                                        continue;
                                    }
                                    dConnections.addAll(PossibleDConnectingPath.findDConnectingPaths(pag, ionIndependenceFacts.getX(), ionIndependenceFacts.getY(), conditions));
                                }
                                finally {
                                    lock.unlock();
                                }
                            }
                        }
                    }
                    if (dConnections.isEmpty()) {
                        this.doFinalOrientation(pag);
                        step3Pags.add(pag);
                        continue;
                    }
                    HashMap<Collection<Node>, List<PossibleDConnectingPath>> paths = new HashMap<Collection<Node>, List<PossibleDConnectingPath>>();
                    for (PossibleDConnectingPath possibleDConnectingPath : dConnections) {
                        LinkedList<PossibleDConnectingPath> p = (LinkedList<PossibleDConnectingPath>)paths.get(possibleDConnectingPath.getConditions());
                        if (p == null) {
                            p = new LinkedList<PossibleDConnectingPath>();
                        }
                        p.add(possibleDConnectingPath);
                        paths.put(possibleDConnectingPath.getConditions(), p);
                    }
                    fclock.lock();
                    ArrayList arrayList = new ArrayList();
                    try {
                        list = IonSearch.findChanges(paths);
                    }
                    finally {
                        fclock.unlock();
                    }
                    float f = System.currentTimeMillis();
                    List<GraphChange> hittingSets = IonHittingSet.findHittingSet(list);
                    this.recHitTimes.add(Float.valueOf(((float)System.currentTimeMillis() - f) / 100.0f));
                    for (GraphChange gc : hittingSets) {
                        Graph changed = gc.applyTo(pag);
                        if (reject.contains(changed) || step3Pags.contains(changed)) continue;
                        if (changed == null || IonSearch.predictsFalseIndependence(this.associations, changed) || IonSearch.hasCircularPath(changed)) {
                            reject.add(changed);
                        }
                        this.doFinalOrientation(changed);
                        step3Pags.add(changed);
                    }
                }
                if (this.adjacencySearch) continue;
                continue block12;
            }
        }
        HashSet<Graph> outputPags = new HashSet<Graph>();
        while (!step3Pags.isEmpty()) {
            Graph pag = (Graph)step3Pags.poll();
            HashMap<Edge, Boolean> necEdges = new HashMap<Edge, Boolean>();
            for (Edge edge : pag.getEdges()) {
                necEdges.put(edge, false);
            }
            block22: for (IonIndependenceFacts fact : this.associations) {
                for (List list : fact.getZ()) {
                    if (!list.isEmpty()) continue;
                    List<List<Node>> list3 = GraphUtils.treks(pag, fact.x, fact.y);
                    if (list3.size() != 1) continue block22;
                    List<Node> trek = list3.get(0);
                    ArrayList triples = new ArrayList();
                    for (int i = 1; i < trek.size(); ++i) {
                        necEdges.put(pag.getEdge(trek.get(i - 1), trek.get(i)), true);
                        if (i == 1) continue;
                        pag.addUnderlineTriple(trek.get(i - 2), trek.get(i - 1), trek.get(i));
                    }
                    continue block22;
                }
            }
            for (Graph newPag : this.possRemove(pag, necEdges)) {
                boolean elimTreks = false;
                block26: for (IonIndependenceFacts ionIndependenceFacts : this.associations) {
                    for (List<Node> nodes : ionIndependenceFacts.getZ()) {
                        if (!nodes.isEmpty()) continue;
                        if (!GraphUtils.treks(newPag, ionIndependenceFacts.x, ionIndependenceFacts.y).isEmpty()) continue block26;
                        elimTreks = true;
                        continue block26;
                    }
                }
                if (elimTreks) continue;
                ArrayList<Triple> arrayList = new ArrayList<Triple>();
                for (Triple triple : newPag.getUnderLines()) {
                    if (!newPag.isAdjacentTo(triple.getX(), triple.getY()) || !newPag.isAdjacentTo(triple.getY(), triple.getZ())) {
                        arrayList.add(triple);
                        continue;
                    }
                    if (!newPag.getEndpoint(triple.getX(), triple.getY()).equals(Endpoint.TAIL) && !newPag.getEndpoint(triple.getZ(), triple.getY()).equals(Endpoint.TAIL)) continue;
                    arrayList.add(triple);
                }
                for (Triple triple : arrayList) {
                    newPag.removeUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
                }
                ArrayList<Set<GraphChange>> arrayList2 = new ArrayList<Set<GraphChange>>();
                Set<Triple> pagTriples = IonSearch.getPossibleTriples(newPag);
                block30: for (IonIndependenceFacts fact : this.associations) {
                    for (List<Node> nodes : fact.getZ()) {
                        if (!nodes.isEmpty()) continue;
                        HashSet<GraphChange> tripleSet = new HashSet<GraphChange>();
                        for (List<Node> nodeList : GraphUtils.treks(newPag, fact.x, fact.y)) {
                            boolean noTriples = true;
                            for (int j = 0; j < nodeList.size() - 2; ++j) {
                                Triple checkTriple = new Triple(nodeList.get(j), nodeList.get(j + 1), nodeList.get(j + 2));
                                if (!pagTriples.contains(checkTriple)) continue;
                                GraphChange noncollider = new GraphChange();
                                noncollider.addNonCollider(checkTriple);
                                tripleSet.add(noncollider);
                                noTriples = false;
                            }
                            if (!noTriples) continue;
                            tripleSet.clear();
                            break;
                        }
                        if (tripleSet.isEmpty()) continue block30;
                        arrayList2.add(tripleSet);
                        continue block30;
                    }
                }
                if (arrayList2.isEmpty()) {
                    outputPags.add(newPag);
                    continue;
                }
                List<GraphChange> hittingSets = IonHittingSet.findHittingSet(arrayList2);
                for (GraphChange gc : hittingSets) {
                    Graph changed = gc.applyTo(newPag);
                    outputPags.add(changed);
                }
            }
        }
        HashSet<Graph> moreSpecific = new HashSet<Graph>();
        block35: for (Graph pag : outputPags) {
            for (Graph graph2 : outputPags) {
                if (pag.getEdges().size() != graph2.getEdges().size() || ((Object)pag).equals(graph2)) continue;
                boolean bl = true;
                for (Edge edge1 : pag.getEdges()) {
                    if (graph2.isAdjacentTo(edge1.getNode1(), edge1.getNode2())) continue;
                    bl = false;
                }
                if (!bl) continue;
                boolean arrowstails = true;
                boolean circles = true;
                for (Edge edge2 : graph2.getEdges()) {
                    Edge edge1 = pag.getEdge(edge2.getNode1(), edge2.getNode2());
                    if (((Object)edge1.getNode1()).equals(edge2.getNode1())) {
                        if (!edge2.getEndpoint1().equals(Endpoint.CIRCLE)) {
                            if (!edge1.getEndpoint1().equals(edge2.getEndpoint1())) {
                                arrowstails = false;
                            }
                        } else if (!edge1.getEndpoint1().equals(edge2.getEndpoint1())) {
                            circles = false;
                        }
                        if (!edge2.getEndpoint2().equals(Endpoint.CIRCLE)) {
                            if (edge1.getEndpoint2().equals(edge2.getEndpoint2())) continue;
                            arrowstails = false;
                            continue;
                        }
                        if (edge1.getEndpoint2().equals(edge2.getEndpoint2())) continue;
                        circles = false;
                        continue;
                    }
                    if (!((Object)edge1.getNode1()).equals(edge2.getNode2())) continue;
                    if (!edge2.getEndpoint1().equals(Endpoint.CIRCLE)) {
                        if (!edge1.getEndpoint2().equals(edge2.getEndpoint1())) {
                            arrowstails = false;
                        }
                    } else if (!edge1.getEndpoint2().equals(edge2.getEndpoint1())) {
                        circles = false;
                    }
                    if (!edge2.getEndpoint2().equals(Endpoint.CIRCLE)) {
                        if (edge1.getEndpoint1().equals(edge2.getEndpoint2())) continue;
                        arrowstails = false;
                        continue;
                    }
                    if (edge1.getEndpoint1().equals(edge2.getEndpoint2())) continue;
                    circles = false;
                }
                if (!arrowstails || circles) continue;
                moreSpecific.add(pag);
                continue block35;
            }
        }
        for (Graph pag : moreSpecific) {
            outputPags.remove(pag);
        }
        this.findNecessaryTreks(graph);
        for (Graph pag : outputPags) {
            this.allColliderCombinations(pag, new HashSet<Edge>());
        }
        this.runtime = (System.currentTimeMillis() - start) / 100L;
        IonSearch.logGraphs("\nReturning output (" + outputPags.size() + " Graphs):", new ArrayList(outputPags));
        return this.output;
    }

    public List<String> getRuntime() {
        float totalhit = 0.0f;
        float longesthit = 0.0f;
        float averagehit = 0.0f;
        for (Float i : this.recHitTimes) {
            totalhit += i.floatValue();
            averagehit += i.floatValue() / (float)this.recHitTimes.size();
            if (!(i.floatValue() > longesthit)) continue;
            longesthit = i.floatValue();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(Long.toString(this.runtime));
        list.add(Float.toString(totalhit));
        list.add(Float.toString(longesthit));
        list.add(Float.toString(averagehit));
        return list;
    }

    public List<Integer> getIterations() {
        int totalit = 0;
        int largestit = 0;
        int averageit = 0;
        for (Integer i : this.recGraphs) {
            totalit += i.intValue();
            averageit += i / this.recGraphs.size();
            if (i <= largestit) continue;
            largestit = i;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(totalit);
        list.add(largestit);
        list.add(averageit);
        return list;
    }

    public String getStats() {
        String stats = "Total running time:  " + this.runtime + "\\\\";
        int totalit = 0;
        int largestit = 0;
        int averageit = 0;
        for (Integer i : this.recGraphs) {
            totalit += i.intValue();
            averageit += i.intValue();
            if (i <= largestit) continue;
            largestit = i;
        }
        averageit /= this.recGraphs.size();
        float totalhit = 0.0f;
        float longesthit = 0.0f;
        float averagehit = 0.0f;
        for (Float i : this.recHitTimes) {
            totalhit += i.floatValue();
            averagehit += i.floatValue() / (float)this.recHitTimes.size();
            if (!(i.floatValue() > longesthit)) continue;
            longesthit = i.floatValue();
        }
        stats = stats + "Total iterations in step 3:  " + totalit + "\\\\";
        stats = stats + "Largest set of iterations in step 3:  " + largestit + "\\\\";
        stats = stats + "Average iterations set in step 3:  " + averageit + "\\\\";
        stats = stats + "Total hitting sets calculation time:  " + totalhit + "\\\\";
        stats = stats + "Average hitting set calculation time:  " + averagehit + "\\\\";
        stats = stats + "Longest hitting set calculation time:  " + longesthit + "\\\\";
        return stats;
    }

    private static Set<Triple> getPossibleTriples(Graph pag) {
        HashSet<Triple> triples = new HashSet<Triple>();
        for (Node node : pag.getNodes()) {
            HashSet<Node> adjNodes = new HashSet<Node>();
            for (Node node2 : pag.getAdjacentNodes(node)) {
                if (pag.getEndpoint(node2, node).equals(Endpoint.TAIL)) continue;
                adjNodes.add(node2);
            }
            for (Node node2 : adjNodes) {
                for (Node node3 : adjNodes) {
                    if (((Object)node2).equals(node3) || !pag.getEndpoint(node2, node).equals(Endpoint.CIRCLE) && !pag.getEndpoint(node3, node).equals(Endpoint.CIRCLE)) continue;
                    triples.add(new Triple(node2, node, node3));
                }
            }
        }
        return triples;
    }

    private static Set<Triple> getAllTriples(Graph pag) {
        HashSet<Triple> triples = new HashSet<Triple>();
        for (Edge edge : pag.getEdges()) {
            if (!IonSearch.isUndirected(edge)) continue;
            Node y = edge.getNode2();
            for (Edge adjEdge : pag.getEdges(y)) {
                if (!IonSearch.isUndirected(adjEdge) || pag.isUnderlineTriple(edge.getNode1(), y, adjEdge.getNode2())) continue;
                triples.add(new Triple(edge.getNode1(), y, adjEdge.getNode2()));
            }
        }
        return triples;
    }

    private List<Set<IonIndependenceFacts>> findSepAndAssoc() {
        HashSet<IonIndependenceFacts> separations = new HashSet<IonIndependenceFacts>();
        HashSet<IonIndependenceFacts> associations = new HashSet<IonIndependenceFacts>();
        Set<NodePair> allNodes = IonSearch.makeAllPairs(this.variables);
        for (NodePair pair : allNodes) {
            Node x = pair.getFirst();
            Node y = pair.getSecond();
            ArrayList<Node> variables = new ArrayList<Node>(this.variables);
            variables.remove(x);
            variables.remove(y);
            List<Set<Node>> subsets = SearchGraphUtils.powerSet(variables);
            IonIndependenceFacts indep = new IonIndependenceFacts(x, y, new HashSet<List<Node>>());
            IonIndependenceFacts assoc = new IonIndependenceFacts(x, y, new HashSet<List<Node>>());
            boolean addIndep = false;
            boolean addAssoc = false;
            for (Graph pag : this.input) {
                for (Set<Node> subset : subsets) {
                    if (!IonSearch.containsAll(pag, subset, pair)) continue;
                    if (pag.isDSeparatedFrom(x, y, new ArrayList<Node>(subset))) {
                        if (!this.notadjacent.contains(pair)) continue;
                        addIndep = true;
                        indep.addMoreZ(new ArrayList<Node>(subset));
                        continue;
                    }
                    addAssoc = true;
                    assoc.addMoreZ(new ArrayList<Node>(subset));
                }
            }
            if (addIndep) {
                separations.add(indep);
            }
            if (!addAssoc) continue;
            associations.add(assoc);
        }
        ArrayList<Set<IonIndependenceFacts>> ret = new ArrayList<Set<IonIndependenceFacts>>(2);
        ret.add(0, separations);
        ret.add(1, associations);
        return ret;
    }

    private static boolean containsAll(Graph g, Set<Node> nodes, NodePair pair) {
        if (!g.containsNode(pair.getFirst()) || !g.containsNode(pair.getSecond())) {
            return false;
        }
        for (Node node : nodes) {
            if (g.containsNode(node)) continue;
            return false;
        }
        return true;
    }

    private void removeAdjacencies(Graph graph) {
        for (Edge edge : graph.getEdges()) {
            for (Graph input : this.input) {
                if (!input.containsNode(edge.getNode1()) || !input.containsNode(edge.getNode2()) || input.isAdjacentTo(edge.getNode1(), edge.getNode2())) continue;
                graph.removeEdge(edge);
                NodePair nodePair = new NodePair(edge.getNode1(), edge.getNode2());
                this.notadjacent.add(nodePair);
                TetradLogger.getInstance().log("details", "Added to NotAdj : " + nodePair);
            }
        }
    }

    private void transferOrientations(Graph graph) {
        HashMap<Edge, Edge> edgeMap = new HashMap<Edge, Edge>();
        HashSet<Edge> conflict = new HashSet<Edge>();
        for (Edge sourceEdge : graph.getEdges()) {
            Node node1 = sourceEdge.getNode1();
            Node node2 = sourceEdge.getNode2();
            for (Graph pag : this.input) {
                if (!pag.containsNode(node1) || !pag.containsNode(node2)) continue;
                Edge edge = pag.getEdge(node1, node2);
                if (edge == null) {
                    graph.removeEdge(sourceEdge);
                    NodePair nodePair = new NodePair(node1, node2);
                    this.notadjacent.add(nodePair);
                    TetradLogger.getInstance().log("details", "Added to NotAdj: " + nodePair);
                    continue;
                }
                if (edge.getEndpoint1().equals(Endpoint.TAIL) && edge.getEndpoint2().equals(Endpoint.TAIL) || !IonSearch.isPartiallyDirected(edge) || conflict.contains(edge)) continue;
                Edge previous = (Edge)edgeMap.get(sourceEdge);
                if (previous != null && IonSearch.isConflict(previous, edge)) {
                    conflict.add(edge);
                    sourceEdge.setEndpoint1(Endpoint.CIRCLE);
                    sourceEdge.setEndpoint2(Endpoint.CIRCLE);
                    continue;
                }
                Edge clone = new Edge(sourceEdge);
                if (((Object)sourceEdge.getNode1()).equals(edge.getNode1())) {
                    if (edge.getEndpoint1() != Endpoint.CIRCLE) {
                        sourceEdge.setEndpoint1(edge.getEndpoint1());
                    }
                    if (edge.getEndpoint2() != Endpoint.CIRCLE) {
                        sourceEdge.setEndpoint2(edge.getEndpoint2());
                    }
                } else {
                    if (edge.getEndpoint2() != Endpoint.CIRCLE) {
                        sourceEdge.setEndpoint1(edge.getEndpoint2());
                    }
                    if (edge.getEndpoint1() != Endpoint.CIRCLE) {
                        sourceEdge.setEndpoint2(edge.getEndpoint1());
                    }
                }
                TetradLogger.getInstance().log("details", "Oriented edge " + clone + " to " + sourceEdge);
                edgeMap.put(clone, new Edge(sourceEdge));
            }
        }
        Iterator<TetradSerializable> i$ = this.input.iterator();
        while (i$.hasNext()) {
            Graph g;
            Graph pag = g = (Graph)i$.next();
            for (Triple triple : pag.getUnderLines()) {
                if (!graph.isAdjacentTo(triple.getX(), triple.getY()) || !graph.isAdjacentTo(triple.getZ(), triple.getY())) continue;
                TetradLogger.getInstance().log("details", "Marked definite noncollider:  " + triple);
                graph.addUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
            }
        }
    }

    private static boolean isConflict(Edge previous, Edge current) {
        Node node1 = previous.getNode1();
        if (previous.getEndpoint1() != Endpoint.CIRCLE && previous.getEndpoint1() != current.getProximalEndpoint(node1)) {
            return true;
        }
        Node node2 = previous.getNode2();
        return current.getEndpoint2() != Endpoint.CIRCLE && previous.getEndpoint2() != current.getProximalEndpoint(node2);
    }

    private static boolean matchesTriple(Graph graph, Triple triple) {
        if (!(graph.containsNode(triple.getX()) && graph.containsNode(triple.getY()) && graph.containsNode(triple.getZ()))) {
            return false;
        }
        Edge edge1 = graph.getEdge(triple.getX(), triple.getY());
        Edge edge2 = graph.getEdge(triple.getY(), triple.getZ());
        if (!graph.containsEdge(edge1) || !graph.containsEdge(edge2)) {
            return false;
        }
        if (edge1.getEndpoint1() != Endpoint.CIRCLE || edge1.getEndpoint2() != Endpoint.CIRCLE) {
            return false;
        }
        return edge2.getEndpoint1() == Endpoint.CIRCLE && edge2.getEndpoint2() == Endpoint.CIRCLE;
    }

    private static boolean isPartiallyDirected(Edge edge) {
        Endpoint end1 = edge.getEndpoint1();
        Endpoint end2 = edge.getEndpoint2();
        return end1 == Endpoint.ARROW || end1 == Endpoint.TAIL || end2 == Endpoint.ARROW || end2 == Endpoint.TAIL;
    }

    private static boolean isUndirected(Edge edge) {
        return edge.getEndpoint1() == Endpoint.CIRCLE && edge.getEndpoint2() == Endpoint.CIRCLE;
    }

    private static void logGraphs(String message, List<? extends Graph> graphs) {
        if (message != null) {
            TetradLogger.getInstance().log("graph", message);
        }
        for (Graph graph : graphs) {
            TetradLogger.getInstance().log("graph", ((Object)graph).toString());
        }
    }

    private static boolean predictsFalseIndependence(Set<IonIndependenceFacts> associations, Graph pag) {
        for (IonIndependenceFacts assocFact : associations) {
            for (List<Node> conditioningSet : assocFact.getZ()) {
                if (!pag.isDSeparatedFrom(assocFact.getX(), assocFact.getY(), conditioningSet)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasCircularPath(Graph pag) {
        Set<Triple> triples = IonSearch.getAllTriples(pag);
        for (Triple trip : triples) {
            Edge one = pag.getEdge(trip.getX(), trip.getY());
            Edge two = pag.getEdge(trip.getY(), trip.getZ());
            Edge three = pag.getEdge(trip.getZ(), trip.getZ());
            if (!one.getDistalEndpoint(trip.getX()).equals(Endpoint.ARROW) || !two.getDistalEndpoint(trip.getY()).equals(Endpoint.ARROW) || !three.getDistalEndpoint(trip.getZ()).equals(Endpoint.ARROW)) continue;
            return true;
        }
        return false;
    }

    private static Set<NodePair> makeAllPairs(List<Node> nodes) {
        HashSet<NodePair> allNodes = new HashSet<NodePair>();
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                allNodes.add(new NodePair(nodes.get(i), nodes.get(j)));
            }
        }
        return allNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List findChanges(Map<Collection<Node>, List<PossibleDConnectingPath>> paths) {
        ArrayList pagChanges = new ArrayList();
        Set<Map.Entry<Collection<Node>, List<PossibleDConnectingPath>>> entries = paths.entrySet();
        for (Map.Entry<Collection<Node>, List<PossibleDConnectingPath>> entry : entries) {
            Collection<Node> conditions = entry.getKey();
            List<PossibleDConnectingPath> dConnecting = entry.getValue();
            for (PossibleDConnectingPath possible : dConnecting) {
                List<Node> possPath = possible.getPath();
                HashSet<GraphChange> pathChanges = new HashSet<GraphChange>(2 * possPath.size());
                ArrayList<Node> outsidePath = new ArrayList<Node>(conditions.size());
                for (Node condition : conditions) {
                    if (possPath.contains(condition)) continue;
                    outsidePath.add(condition);
                }
                for (int i = 0; i < possPath.size() - 1; ++i) {
                    Node current = possPath.get(i);
                    Node next = possPath.get(i + 1);
                    GraphChange gc = new GraphChange();
                    gc.addRemove(possible.getPag().getEdge(current, next));
                    pathChanges.add(gc);
                    if (conditions.contains(current) && i > 0) {
                        gc = new GraphChange();
                        Triple nonColider = new Triple(possPath.get(i - 1), current, next);
                        gc.addNonCollider(nonColider);
                        pathChanges.add(gc);
                    }
                    if (conditions.contains(current) || i <= 0) continue;
                    Triple colider = new Triple(possPath.get(i - 1), current, next);
                    if (possible.getPag().isUnderlineTriple(possPath.get(i - 1), current, next)) continue;
                    Edge edge1 = possible.getPag().getEdge(colider.getX(), colider.getY());
                    Edge edge2 = possible.getPag().getEdge(colider.getZ(), colider.getY());
                    if (!((Object)edge1.getNode1()).equals(colider.getY()) ? ((Object)edge1.getNode2()).equals(colider.getY()) && edge1.getEndpoint2().equals(Endpoint.TAIL) : edge1.getEndpoint1().equals(Endpoint.TAIL)) continue;
                    if (!((Object)edge2.getNode1()).equals(colider.getY()) ? ((Object)edge2.getNode2()).equals(colider.getY()) && edge2.getEndpoint2().equals(Endpoint.TAIL) : edge2.getEndpoint1().equals(Endpoint.TAIL)) continue;
                    if (outsidePath.size() == 0) {
                        gc = new GraphChange();
                        gc.addCollider(colider);
                        pathChanges.add(gc);
                        continue;
                    }
                    for (Node outside : outsidePath) {
                        List<Object> decendantPaths = new ArrayList();
                        lock.lock();
                        try {
                            decendantPaths = PossibleDConnectingPath.findDConnectingPaths(possible.getPag(), current, outside, new ArrayList<Node>());
                        }
                        finally {
                            lock.unlock();
                        }
                        for (PossibleDConnectingPath possibleDConnectingPath : decendantPaths) {
                            List<Node> decendantPath = possibleDConnectingPath.getPath();
                            boolean impliesDecendant = true;
                            HashSet<GraphChange> colideChanges = new HashSet<GraphChange>();
                            for (int j = 0; j < decendantPath.size() - 1; ++j) {
                                Node from = decendantPath.get(j);
                                Node to = decendantPath.get(j + 1);
                                Edge currentEdge = possible.getPag().getEdge(from, to);
                                if (currentEdge.getEndpoint1().equals(Endpoint.ARROW)) {
                                    impliesDecendant = false;
                                    break;
                                }
                                gc = new GraphChange();
                                gc.addCollider(colider);
                                gc.addRemove(currentEdge);
                                colideChanges.add(gc);
                                gc = new GraphChange();
                                gc.addCollider(colider);
                                gc.addOrient(to, from);
                                colideChanges.add(gc);
                            }
                            if (!impliesDecendant) continue;
                            pathChanges.addAll(colideChanges);
                        }
                    }
                }
                pagChanges.add(pathChanges);
            }
        }
        return pagChanges;
    }

    private List<Graph> possRemove(Graph pag, Map<Edge, Boolean> necEdges) {
        ArrayList<Edge> remEdges = new ArrayList<Edge>();
        for (Edge remEdge : necEdges.keySet()) {
            if (necEdges.get(remEdge).booleanValue()) continue;
            remEdges.add(remEdge);
        }
        PowerSet pset = new PowerSet(remEdges);
        ArrayList<Graph> possRemove = new ArrayList<Graph>();
        for (Set set : pset) {
            EdgeListGraph newPag = new EdgeListGraph(pag);
            for (Edge edge : set) {
                newPag.removeEdge(edge);
            }
            possRemove.add(newPag);
        }
        return possRemove;
    }

    private void preventColliders(Graph changed) {
        ArrayList<Triple> remTriples = new ArrayList<Triple>();
        for (Triple triple : changed.getUnderLines()) {
            if (!changed.isAdjacentTo(triple.getX(), triple.getY()) || !changed.isAdjacentTo(triple.getZ(), triple.getY()) || changed.isDefCollider(triple.getX(), triple.getY(), triple.getZ())) {
                remTriples.add(triple);
                continue;
            }
            if (changed.getEndpoint(triple.getX(), triple.getY()).equals(Endpoint.ARROW)) {
                changed.setEndpoint(triple.getZ(), triple.getY(), Endpoint.TAIL);
                remTriples.add(triple);
                changed.setEndpoint(triple.getY(), triple.getZ(), Endpoint.ARROW);
                continue;
            }
            if (!changed.getEndpoint(triple.getZ(), triple.getY()).equals(Endpoint.ARROW)) continue;
            changed.setEndpoint(triple.getX(), triple.getY(), Endpoint.TAIL);
            remTriples.add(triple);
            changed.setEndpoint(triple.getY(), triple.getX(), Endpoint.ARROW);
        }
        for (Triple triple : remTriples) {
            changed.removeUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    private void doFinalOrientation(Graph graph) {
        while (this.changeFlag) {
            this.changeFlag = false;
            this.doubleTriangle(graph);
            this.preventColliders(graph);
            this.awayFromColliderAncestorCycle(graph);
            this.discrimPaths(graph);
        }
        this.changeFlag = true;
    }

    private void doubleTriangle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            List<Node> intoBArrows = graph.getNodesInTo(B, Endpoint.ARROW);
            List<Node> intoBCircles = graph.getNodesInTo(B, Endpoint.CIRCLE);
            LinkedList<Node> possA = new LinkedList<Node>(intoBArrows);
            LinkedList<Node> possC = new LinkedList<Node>(intoBArrows);
            for (Node D : intoBCircles) {
                for (Node A : possA) {
                    for (Node C : possC) {
                        if (C == A || !graph.isAdjacentTo(A, D) || !graph.isAdjacentTo(C, D) || graph.isDefCollider(A, D, C) || !this.isArrowpointAllowed(graph, D, B)) continue;
                        graph.setEndpoint(D, B, Endpoint.ARROW);
                        this.changeFlag = true;
                    }
                }
            }
        }
    }

    private void awayFromColliderAncestorCycle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            int[] combination;
            List<Node> adj = graph.getAdjacentNodes(B);
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null) {
                Node A = adj.get(combination[0]);
                Node C = adj.get(combination[1]);
                this.awayFromCollider(graph, A, B, C);
                this.awayFromCollider(graph, C, B, A);
                this.awayFromAncestor(graph, A, B, C);
                this.awayFromAncestor(graph, C, B, A);
                this.awayFromCycle(graph, A, B, C);
                this.awayFromCycle(graph, C, B, A);
            }
        }
    }

    private boolean isArrowpointAllowed(Graph graph, Node x, Node y) {
        if (graph.getEndpoint(x, y) == Endpoint.ARROW) {
            return true;
        }
        if (graph.getEndpoint(x, y) == Endpoint.TAIL) {
            return false;
        }
        if (graph.getEndpoint(y, x) == Endpoint.ARROW && graph.getEndpoint(x, y) == Endpoint.CIRCLE) {
            return true;
        }
        return true;
    }

    private void awayFromCollider(Graph graph, Node a, Node b, Node c) {
        Endpoint BC = graph.getEndpoint(b, c);
        Endpoint CB = graph.getEndpoint(c, b);
        if (!graph.isAdjacentTo(a, c) && graph.getEndpoint(a, b) == Endpoint.ARROW) {
            if ((CB == Endpoint.CIRCLE || CB == Endpoint.TAIL) && BC == Endpoint.CIRCLE) {
                if (!this.isArrowpointAllowed(graph, b, c)) {
                    return;
                }
                graph.setEndpoint(b, c, Endpoint.ARROW);
                this.changeFlag = true;
            }
            if ((BC == Endpoint.CIRCLE || BC == Endpoint.ARROW) && CB == Endpoint.CIRCLE) {
                graph.setEndpoint(c, b, Endpoint.TAIL);
                this.changeFlag = true;
            }
        }
    }

    private void awayFromAncestor(Graph graph, Node a, Node b, Node c) {
        if (graph.isAdjacentTo(a, c) && graph.getEndpoint(a, c) == Endpoint.CIRCLE && graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(b, c) == Endpoint.ARROW && (graph.getEndpoint(b, a) == Endpoint.TAIL || graph.getEndpoint(c, b) == Endpoint.TAIL)) {
            if (!this.isArrowpointAllowed(graph, a, c)) {
                return;
            }
            graph.setEndpoint(a, c, Endpoint.ARROW);
            this.changeFlag = true;
        }
    }

    private void awayFromCycle(Graph graph, Node a, Node b, Node c) {
        if (graph.isAdjacentTo(a, c) && graph.getEndpoint(a, c) == Endpoint.ARROW && graph.getEndpoint(c, a) == Endpoint.CIRCLE && graph.isDirectedFromTo(a, b) && graph.isDirectedFromTo(b, c)) {
            graph.setEndpoint(c, a, Endpoint.TAIL);
            this.changeFlag = true;
        }
    }

    private void discrimPaths(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            List<Node> possAandC = graph.getNodesOutTo(b, Endpoint.ARROW);
            LinkedList<Node> possA = new LinkedList<Node>(possAandC);
            possA.removeAll(graph.getNodesInTo(b, Endpoint.TAIL));
            LinkedList<Node> possC = new LinkedList<Node>(possAandC);
            possC.retainAll(graph.getNodesInTo(b, Endpoint.CIRCLE));
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!graph.isParentOf(a, c)) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    this.reachablePathFindOrient(graph, a, b, c, reachable);
                }
            }
        }
    }

    private void reachablePathFindOrient(Graph graph, Node a, Node b, Node c, LinkedList<Node> reachable) {
        HashSet<Node> cParents = new HashSet<Node>(graph.getParents(c));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            List<Node> pathExtensions = graph.getNodesInTo(x, Endpoint.ARROW);
            pathExtensions.removeAll(visited);
            for (Node l : pathExtensions) {
                if (!graph.isAdjacentTo(l, c)) {
                    this.doDdpOrientation(graph, l, a, b, c);
                    return;
                }
                if (!cParents.contains(l) || graph.getEndpoint(x, l) != Endpoint.ARROW) continue;
                reachable.add(l);
            }
        }
    }

    private void doDdpOrientation(Graph graph, Node l, Node a, Node b, Node c) {
        boolean inCondSet = false;
        for (IonIndependenceFacts ionIndependenceFacts : this.separations) {
            if ((!((Object)ionIndependenceFacts.getX()).equals(l) || !((Object)ionIndependenceFacts.getY()).equals(c)) && (!((Object)ionIndependenceFacts.getY()).equals(l) || !((Object)ionIndependenceFacts.getX()).equals(c))) continue;
            for (List<Node> condSet : ionIndependenceFacts.getZ()) {
                if (!condSet.contains(b)) continue;
                inCondSet = true;
            }
        }
        if (!inCondSet) {
            for (List list : GraphUtils.treks(graph, l, c)) {
                if (!list.contains(b)) continue;
                inCondSet = true;
            }
        }
        if (inCondSet) {
            graph.setEndpoint(c, b, Endpoint.TAIL);
        } else {
            graph.setEndpoint(a, b, Endpoint.ARROW);
            graph.setEndpoint(c, b, Endpoint.ARROW);
        }
        this.changeFlag = true;
    }

    private void allColliderCombinations(Graph graph, Set<Edge> removedEdges) {
        this.currentGraph = graph;
        long start = System.currentTimeMillis();
        for (Set<Set<Edge>> necessaryTrek : this.necessaryTreks) {
            HashSet<Set<Edge>> newNecessaryTrek = new HashSet<Set<Edge>>();
            for (Set<Edge> trek : necessaryTrek) {
                boolean add = true;
                for (Edge edgeRemoved : removedEdges) {
                    if (!trek.contains(edgeRemoved)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                newNecessaryTrek.add(trek);
            }
            this.currentNecessaryTreks.add(newNecessaryTrek);
        }
        this.currentNecTreks += System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        this.currentTriples = this.getAllTriples2(graph);
        for (Triple triple : this.currentTriples) {
            if (graph.isAdjacentTo(triple.getX(), triple.getZ()) || graph.isUnderlineTriple(triple.getX(), triple.getY(), triple.getZ()) || graph.isDefCollider(triple.getX(), triple.getY(), triple.getZ())) continue;
            this.currentPossibleColliders.add(triple);
        }
        this.unshielded += System.currentTimeMillis() - start;
        System.out.println("Found Unshielded");
        start = System.currentTimeMillis();
        this.currentDiscriminatingColliders = this.discrimPathColliders(graph);
        this.currentPossibleColliders.addAll(this.currentDiscriminatingColliders);
        this.discrim += System.currentTimeMillis() - start;
        System.out.println("Found Discriminating");
        start = System.currentTimeMillis();
        this.simpleColliderIterator();
        this.currentPossibleColliders.clear();
        this.currentNecessaryTreks.clear();
    }

    private void simpleColliderIterator() {
        HashSet<Set<Triple>> necessaryEdges = new HashSet<Set<Triple>>();
        PowerSet<Triple> pset = new PowerSet<Triple>(this.currentPossibleColliders);
        int psetsize = (int)Math.pow(2.0, this.currentPossibleColliders.size());
        for (Set<Triple> set : pset) {
            System.out.println("Searching Powerset (ION): " + psetsize);
            --psetsize;
            boolean stop = false;
            for (Set set2 : necessaryEdges) {
                if (!set.containsAll(set2)) continue;
                stop = true;
                break;
            }
            if (stop) continue;
            if (this.checkCollider(set, necessaryEdges)) {
                EdgeListGraph newGraph = new EdgeListGraph(this.currentGraph);
                for (Triple triple : this.currentTriples) {
                    if (set.contains(triple)) {
                        newGraph.setEndpoint(triple.getX(), triple.getY(), Endpoint.ARROW);
                        newGraph.setEndpoint(triple.getZ(), triple.getY(), Endpoint.ARROW);
                        continue;
                    }
                    if (!this.currentDiscriminatingColliders.contains(triple) && newGraph.isAdjacentTo(triple.getX(), triple.getZ()) || newGraph.isDefCollider(triple.getX(), triple.getY(), triple.getZ())) continue;
                    newGraph.addUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
                }
                long l = System.currentTimeMillis();
                this.doFinalOrientation(newGraph);
                this.dofinal += System.currentTimeMillis() - l;
                l = System.currentTimeMillis();
                if (IonSearch.predictsFalseDependence(this.separations, newGraph)) continue;
                this.predicts += System.currentTimeMillis() - l;
                this.output.add(newGraph);
                continue;
            }
            necessaryEdges.add(set);
        }
    }

    private boolean checkCollider(Set<Triple> newSet, Set<Set<Triple>> necessaryEdges) {
        boolean possible = true;
        for (Set<Triple> set : necessaryEdges) {
            if (!newSet.containsAll(set)) continue;
            possible = false;
            break;
        }
        if (possible) {
            for (Set<Object> set : this.currentNecessaryTreks) {
                boolean okay = false;
                for (Set set2 : set) {
                    boolean pathOkay = true;
                    for (Triple triple : newSet) {
                        if (!set2.contains(this.currentGraph.getEdge(triple.getX(), triple.getY())) || !set2.contains(this.currentGraph.getEdge(triple.getY(), triple.getZ()))) continue;
                        pathOkay = false;
                        break;
                    }
                    if (!pathOkay) continue;
                    okay = true;
                    break;
                }
                if (okay) continue;
                possible = false;
                break;
            }
        }
        return possible;
    }

    private List<Triple> discrimPathColliders(Graph graph) {
        ArrayList<Triple> possColliders = new ArrayList<Triple>();
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            List<Node> possAandC = graph.getNodesOutTo(b, Endpoint.ARROW);
            possAandC.addAll(graph.getNodesOutTo(b, Endpoint.CIRCLE));
            LinkedList<Node> possA = new LinkedList<Node>(possAandC);
            possA.removeAll(graph.getNodesInTo(b, Endpoint.TAIL));
            LinkedList<Node> possC = new LinkedList<Node>(possAandC);
            possC.removeAll(graph.getNodesInTo(b, Endpoint.TAIL));
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!graph.isAdjacentTo(a, c) || graph.getEndpoint(a, c).equals(Endpoint.TAIL)) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    this.reachablePathFind(graph, a, b, c, reachable, possColliders);
                }
            }
        }
        return possColliders;
    }

    private void reachablePathFind(Graph graph, Node a, Node b, Node c, LinkedList<Node> reachable, List<Triple> possColliders) {
        HashSet<Node> cParents = new HashSet<Node>(graph.getAdjacentNodes(c));
        cParents.removeAll(graph.getNodesInTo(c, Endpoint.TAIL));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            HashSet<Node> pathExtensions = new HashSet<Node>(graph.getAdjacentNodes(x));
            pathExtensions.removeAll(graph.getNodesInTo(x, Endpoint.TAIL));
            pathExtensions.removeAll(visited);
            for (Node l : pathExtensions) {
                if (!graph.isAdjacentTo(l, c)) {
                    possColliders.add(new Triple(a, c, b));
                    return;
                }
                if (!cParents.contains(l) || graph.getEndpoint(x, l) == Endpoint.TAIL) continue;
                reachable.add(l);
            }
        }
    }

    private static boolean predictsFalseDependence(Set<IonIndependenceFacts> separations, Graph pag) {
        for (IonIndependenceFacts sepFact : separations) {
            for (List<Node> conditioningSet : sepFact.getZ()) {
                if (pag.isDSeparatedFrom(sepFact.getX(), sepFact.getY(), conditioningSet)) continue;
                return true;
            }
        }
        return false;
    }

    private void findNecessaryTreks(Graph graph) {
        this.necessaryTreks = new HashSet<Set<Set<Edge>>>();
        for (IonIndependenceFacts iif : this.associations) {
            boolean unconditional = false;
            for (List<Node> conditioningSet : iif.getZ()) {
                if (!conditioningSet.isEmpty()) continue;
                unconditional = true;
            }
            if (!unconditional) continue;
            HashSet paths = new HashSet();
            for (List<Node> path : GraphUtils.treks(graph, iif.getX(), iif.getY())) {
                HashSet<Edge> edges = new HashSet<Edge>();
                for (int k = 0; k < path.size() - 1; ++k) {
                    edges.add(graph.getEdge(path.get(k), path.get(k + 1)));
                }
                paths.add(edges);
            }
            boolean add = true;
            for (Set<Set<Edge>> necessaryTrek : this.necessaryTreks) {
                for (Set<Edge> edges : necessaryTrek) {
                    add = true;
                    for (Set set : paths) {
                        if (!edges.containsAll(set)) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                    break;
                }
                if (add) continue;
                break;
            }
            if (!add) continue;
            this.necessaryTreks.add(paths);
        }
    }

    private Set<Triple> getAllTriples2(Graph graph) {
        HashSet<Triple> triples = new HashSet<Triple>();
        for (Node node : graph.getNodes()) {
            List<Node> adjNodes = graph.getAdjacentNodes(node);
            for (int i = 0; i < adjNodes.size() - 1; ++i) {
                for (int j = i + 1; j < adjNodes.size(); ++j) {
                    triples.add(new Triple(adjNodes.get(i), node, adjNodes.get(j)));
                }
            }
        }
        return triples;
    }

    private class PowerSet<E>
    implements Iterable<Set<E>> {
        Collection<E> all;

        public PowerSet(Collection<E> all) {
            this.all = all;
        }

        @Override
        public Iterator<Set<E>> iterator() {
            return new PowerSetIterator(this);
        }

        class PowerSetIterator<InE>
        implements Iterator<Set<InE>> {
            PowerSet<InE> powerSet;
            List<InE> canonicalOrder = new ArrayList<InE>();
            List<InE> mask = new ArrayList<InE>();
            boolean hasNext = true;

            PowerSetIterator(PowerSet<InE> powerSet2) {
                this.powerSet = powerSet2;
                this.canonicalOrder.addAll(powerSet2.all);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean allOnes() {
                for (InE bit : this.mask) {
                    if (bit != null) continue;
                    return false;
                }
                return true;
            }

            private void increment() {
                int i;
                for (i = 0; i < this.mask.size(); ++i) {
                    InE bit = this.mask.get(i);
                    if (bit == null) {
                        this.mask.set(i, this.canonicalOrder.get(i));
                        return;
                    }
                    this.mask.set(i, null);
                }
                this.mask.add(this.canonicalOrder.get(i));
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Set<InE> next() {
                HashSet<InE> result = new HashSet<InE>();
                result.addAll(this.mask);
                result.remove(null);
                boolean bl = this.hasNext = this.mask.size() < this.powerSet.all.size() || !this.allOnes();
                if (this.hasNext) {
                    this.increment();
                }
                return result;
            }
        }
    }

    private final class IonIndependenceFacts {
        private Node x;
        private Node y;
        private Collection<List<Node>> z;

        public IonIndependenceFacts(Node x, Node y, Collection<List<Node>> z) {
            if (x == null || y == null || z == null) {
                throw new NullPointerException();
            }
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public final Node getX() {
            return this.x;
        }

        public final Node getY() {
            return this.y;
        }

        public final Collection<List<Node>> getZ() {
            return this.z;
        }

        public void addMoreZ(List<Node> moreZ) {
            this.z.add(moreZ);
        }

        public final int hashCode() {
            int hash = 17;
            hash += 19 * ((Object)this.x).hashCode() * ((Object)this.y).hashCode();
            return hash += 23 * ((Object)this.z).hashCode();
        }

        public final boolean equals(Object obj) {
            if (!(obj instanceof IonIndependenceFacts)) {
                return false;
            }
            IonIndependenceFacts fact = (IonIndependenceFacts)obj;
            return ((Object)this.x).equals(fact.x) && ((Object)this.y).equals(fact.y) && ((Object)this.z).equals(fact.z) || ((Object)this.x).equals(fact.y) & ((Object)this.y).equals(fact.x) && ((Object)this.z).equals(fact.z);
        }

        public String toString() {
            return "I(" + this.x + ", " + this.y + " | " + this.z + ")";
        }
    }
}

