/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MimUtils {
    public static Clusters convertToClusters(Graph clusterGraph) {
        ArrayList<String> latents = new ArrayList<String>();
        Clusters clusters = new Clusters();
        for (Node node : clusterGraph.getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            latents.add(node.getName());
        }
        Collections.sort(latents);
        for (int i = 0; i < latents.size(); ++i) {
            String name = (String)latents.get(i);
            clusters.setClusterName(i, name);
            Node latent = clusterGraph.getNode(name);
            List<Node> measured = clusterGraph.getNodesOutTo(latent, Endpoint.ARROW);
            for (Node _node : measured) {
                if (_node.getNodeType() == NodeType.LATENT) continue;
                clusters.addToCluster(i, _node.getName());
            }
        }
        return clusters;
    }

    public static Graph extractStructureGraph(Graph clusterGraph) throws Exception {
        List<Edge> edges = clusterGraph.getEdges();
        EdgeListGraph structureGraph = new EdgeListGraph();
        for (Edge edge : edges) {
            Node node1 = edge.getNode1();
            Node node2 = edge.getNode2();
            if (node1.getNodeType() == NodeType.LATENT && !structureGraph.containsNode(node1)) {
                structureGraph.addNode(node1);
            }
            if (node2.getNodeType() == NodeType.LATENT && !structureGraph.containsNode(node2)) {
                structureGraph.addNode(node2);
            }
            if (node1.getNodeType() != NodeType.LATENT || node2.getNodeType() != NodeType.LATENT) continue;
            structureGraph.addEdge(edge);
        }
        Graph clone = new MarshalledObject<EdgeListGraph>(structureGraph).get();
        GraphUtils.arrangeInCircle(clone, 200, 200, 150);
        GraphUtils.fruchtermanReingoldLayout(clone);
        return clone;
    }
}

