/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.FciDsepLegalPairs2;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.LegalPairs;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

final class PossibleDsepCfci {
    private Graph graph;
    private IndependenceTest test;
    private List<Node> nodes;
    private SepsetMap sepset;
    private int depth = -1;
    private LegalPairs legalPairs;
    private Knowledge knowledge = new Knowledge();
    private int maxReachablePathLength = -1;

    public PossibleDsepCfci(Graph graph, IndependenceTest test, Set<Triple> unfaithfulTriples, SepsetMap sepset) {
        if (graph == null) {
            throw new NullPointerException("null GaSearchGraph passed in PossibleDSepSearch constructor!");
        }
        if (test == null) {
            throw new NullPointerException("null IndependenceChecker passed in PossibleDSepSearch constructor!");
        }
        this.graph = graph;
        this.test = test;
        this.nodes = new LinkedList<Node>(this.graph.getNodes());
        this.sepset = sepset;
        this.legalPairs = new FciDsepLegalPairs2(this.graph, unfaithfulTriples);
        this.setMaxReachablePathLength(this.maxReachablePathLength);
    }

    public final SepsetMap search() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node node1 = this.nodes.get(i);
            List<Node> adj = this.graph.getAdjacentNodes(node1);
            for (int j = 0; j < i; ++j) {
                adj.remove(this.nodes.get(j));
            }
            for (Node node2 : adj) {
                boolean removed = this.tryRemovingUsingDsep(node1, node2, this.getMaxReachablePathLength());
                if (removed) continue;
                this.tryRemovingUsingDsep(node2, node1, this.getMaxReachablePathLength());
            }
        }
        return this.sepset;
    }

    private boolean tryRemovingUsingDsep(Node node1, Node node2, int maxPathLength) {
        LinkedList<Node> possDsep = new LinkedList<Node>(this.getPossibleDsep(node1, node2, maxPathLength));
        boolean noEdgeRequired = this.getKnowledge().noEdgeRequired(node1.getName(), node2.getName());
        possDsep.remove(node1);
        possDsep.remove(node2);
        List<Node> possibleParents = this.possibleParents(node1, possDsep, this.getKnowledge());
        int _depth = possibleParents.size();
        if (this.getDepth() != -1 && _depth > this.getDepth()) {
            _depth = this.getDepth();
        }
        for (int num = 1; num <= _depth; ++num) {
            int[] indSet;
            ChoiceGenerator cg = new ChoiceGenerator(possibleParents.size(), num);
            while ((indSet = cg.next()) != null) {
                List<Node> condSet = SearchGraphUtils.asList(indSet, possibleParents);
                boolean independent = this.test.isIndependent(node1, node2, condSet);
                if (!independent || !noEdgeRequired) continue;
                System.out.println("*** DSEP removed " + this.graph.getEdge(node1, node2));
                this.graph.removeEdge(node1, node2);
                LinkedList<Node> z = new LinkedList<Node>(condSet);
                this.sepset.set(node1, node2, z);
                return true;
            }
        }
        return false;
    }

    private List<Node> possibleParents(Node x, List<Node> nodes, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : nodes) {
            String _z = z.getName();
            if (!PossibleDsepCfci.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private static boolean possibleParentOf(String _z, String _x, Knowledge bk) {
        return !bk.edgeForbidden(_z, _x) && !bk.edgeRequired(_x, _z);
    }

    private Set<Node> getPossibleDsep(Node node1, Node node2, int maxPathLength) {
        List<Node> initialNodes = Collections.singletonList(node1);
        List<Node> c = null;
        List<Node> d = null;
        Set<Node> reachable = SearchGraphUtils.getReachableNodes(initialNodes, this.legalPairs, c, d, this.graph, maxPathLength);
        reachable.remove(node1);
        reachable.remove(node2);
        return reachable;
    }

    private int getDepth() {
        return this.depth;
    }

    public final void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    private Knowledge getKnowledge() {
        return this.knowledge;
    }

    public final void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public int getMaxReachablePathLength() {
        return this.maxReachablePathLength == Integer.MAX_VALUE ? -1 : this.maxReachablePathLength;
    }

    public void setMaxReachablePathLength(int maxReachablePathLength) {
        if (maxReachablePathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxReachablePathLength);
        }
        this.maxReachablePathLength = maxReachablePathLength == -1 ? Integer.MAX_VALUE : maxReachablePathLength;
    }
}

