/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.FciDsepLegalPairs;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.LegalPairs;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class PossibleDsepFci {
    private Graph graph;
    private IndependenceTest test;
    private List<Node> nodes;
    private SepsetMap sepset;
    private int depth = -1;
    private LegalPairs legalPairs;
    private Knowledge knowledge = new Knowledge();
    private int maxReachablePathLength = -1;

    public PossibleDsepFci(Graph graph, IndependenceTest test) {
        this(graph, test, new SepsetMap());
    }

    public PossibleDsepFci(Graph graph, IndependenceTest test, SepsetMap sepsetMap) {
        if (graph == null) {
            throw new NullPointerException("null GaSearchGraph passed in PossibleDSepSearch constructor!");
        }
        if (test == null) {
            throw new NullPointerException("null IndependenceChecker passed in PossibleDSepSearch constructor!");
        }
        this.graph = graph;
        this.test = test;
        this.nodes = new LinkedList<Node>(this.graph.getNodes());
        this.sepset = sepsetMap == null ? new SepsetMap() : sepsetMap;
        this.legalPairs = new FciDsepLegalPairs(this.graph);
        this.setMaxReachablePathLength(this.maxReachablePathLength);
    }

    public SepsetMap search() {
        for (Edge edge : new ArrayList<Edge>(this.graph.getEdges())) {
            Node node1 = edge.getNode1();
            Node node2 = edge.getNode2();
            System.out.println("Looking for possible dsep for " + this.graph.getEdges(node1, node2));
            boolean removed = this.tryRemovingUsingDsep(node1, node2, this.maxReachablePathLength);
            if (removed) continue;
            this.tryRemovingUsingDsep(node2, node1, this.maxReachablePathLength);
        }
        return this.sepset;
    }

    private boolean tryRemovingUsingDsep(Node node1, Node node2, int maxPathLength) {
        LinkedList<Node> possDsep = new LinkedList<Node>(this.getPossibleDsep(node1, node2, maxPathLength));
        boolean noEdgeRequired = this.getKnowledge().noEdgeRequired(node1.getName(), node2.getName());
        possDsep.remove(node1);
        possDsep.remove(node2);
        List<Node> possParents = this.possibleParents(node1, possDsep, this.getKnowledge());
        int _depth = possParents.size();
        if (this.getDepth() != -1 && _depth > this.getDepth()) {
            _depth = this.getDepth();
        }
        for (int num = 1; num <= _depth; ++num) {
            int[] indSet;
            ChoiceGenerator cg = new ChoiceGenerator(possParents.size(), num);
            while ((indSet = cg.next()) != null) {
                List<Node> condSet = SearchGraphUtils.asList(indSet, possParents);
                boolean independent = this.test.isIndependent(node1, node2, condSet);
                if (!independent || !noEdgeRequired) continue;
                this.graph.removeEdge(node1, node2);
                this.sepset.set(node1, node2, new LinkedList<Node>(condSet));
                return true;
            }
        }
        return false;
    }

    private List<Node> possibleParents(Node x, List<Node> nodes, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : nodes) {
            String _z = z.getName();
            if (!this.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String _z, String _x, Knowledge bk) {
        return !bk.edgeForbidden(_z, _x) && !bk.edgeRequired(_x, _z);
    }

    private Set<Node> getPossibleDsep(Node node1, Node node2, int maxPathLength) {
        List<Node> initialNodes = Collections.singletonList(node1);
        List<Node> c = null;
        List<Node> d = null;
        Set<Node> reachable = SearchGraphUtils.getReachableNodes(initialNodes, this.legalPairs, c, d, this.graph, maxPathLength);
        reachable.remove(node1);
        reachable.remove(node2);
        return reachable;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public int getMaxReachablePathLength() {
        return this.maxReachablePathLength == Integer.MAX_VALUE ? -1 : this.maxReachablePathLength;
    }

    public void setMaxReachablePathLength(int maxReachablePathLength) {
        if (maxReachablePathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxReachablePathLength);
        }
        this.maxReachablePathLength = maxReachablePathLength == -1 ? Integer.MAX_VALUE : maxReachablePathLength;
    }
}

