/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Pattern;
import edu.cmu.tetrad.search.DagInPatternIterator;
import edu.cmu.tetrad.search.DagIterator;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.LegalPairs;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.PatternToDag;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.map.MultiKeyMap;

public final class SearchGraphUtils {
    public static void pcOrientbk(Knowledge bk, Graph graph, List<Node> nodes) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        TetradLogger.getInstance().log("info", "Staring BK Orientation.");
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), nodes);
            to = SearchGraphUtils.translate(edge.getTo(), nodes);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.removeEdge(from, to);
            graph.addDirectedEdge(from, to);
            graph.setEndpoint(from, to, Endpoint.TAIL);
            graph.setEndpoint(to, from, Endpoint.ARROW);
            TetradLogger.getInstance().log("knowledgeOrientations", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(to, from)));
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), nodes);
            to = SearchGraphUtils.translate(edge.getTo(), nodes);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.TAIL);
            graph.setEndpoint(from, to, Endpoint.ARROW);
            TetradLogger.getInstance().log("knowledgeOrientations", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        TetradLogger.getInstance().log("info", "Finishing BK Orientation.");
    }

    public static void pcdOrientC(SepsetMap set, IndependenceTest test, Knowledge knowledge, Graph graph) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        List<Node> nodes = graph.getNodes();
        for (Node y : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                boolean splitDeterminesAugmentedSetXZ;
                List<Node> sepset;
                Node z;
                Node x = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(x, z = adjacentNodes.get(combination[1])) || (sepset = set.get(x, z)) == null) continue;
                LinkedList<Node> augmentedSet = new LinkedList<Node>(sepset);
                augmentedSet.add(y);
                if (test.determines(sepset, y)) {
                    TetradLogger.getInstance().log("info", sepset + " determines " + y);
                    continue;
                }
                boolean splitDeterminexSepsetXZ = test.determines(sepset, x) || test.determines(sepset, z);
                boolean bl = splitDeterminesAugmentedSetXZ = test.determines(augmentedSet, x) || test.determines(augmentedSet, z);
                if (!splitDeterminexSepsetXZ && splitDeterminesAugmentedSetXZ) {
                    TetradLogger.getInstance().log("info", sepset + " split determines " + x + " and " + z);
                    continue;
                }
                if (!SearchGraphUtils.isArrowpointAllowed(x, y, knowledge) || !SearchGraphUtils.isArrowpointAllowed(z, y, knowledge)) continue;
                graph.setEndpoint(x, y, Endpoint.ARROW);
                graph.setEndpoint(z, y, Endpoint.ARROW);
                TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(x, y, z));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    public static void orientUsingMeekRulesLocally(Knowledge knowledge, Graph graph, IndependenceTest test, int depth) {
        boolean changed;
        TetradLogger.getInstance().log("info", "Starting Orientation Step D.");
        while (changed = SearchGraphUtils.meekR1Locally(graph, knowledge, test, depth) || SearchGraphUtils.meekR2(graph, knowledge) || SearchGraphUtils.meekR3(graph, knowledge) || SearchGraphUtils.meekR4(graph, knowledge)) {
        }
        TetradLogger.getInstance().log("info", "Finishing Orientation Step D.");
    }

    public static void orientUsingMeekRulesLocally2(Knowledge knowledge, Graph graph, IndependenceTest test, int depth) {
        boolean changed;
        TetradLogger.getInstance().log("info", "Starting Orientation Step D.");
        while (changed = SearchGraphUtils.meekR1Locally2(graph, knowledge, test, depth) || SearchGraphUtils.meekR2(graph, knowledge) || SearchGraphUtils.meekR3(graph, knowledge) || SearchGraphUtils.meekR4(graph, knowledge)) {
        }
        TetradLogger.getInstance().log("info", "Finishing Orientation Step D.");
    }

    public static void orientCollidersUsingSepsets(SepsetMap set, Knowledge knowledge, Graph graph) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        List<Node> nodes = graph.getNodes();
        for (Node a : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                List<Node> sepset;
                Node c;
                Node b = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1])) || (sepset = set.get(b, c)) == null || sepset.contains(a) || !SearchGraphUtils.isArrowpointAllowed(b, a, knowledge) || !SearchGraphUtils.isArrowpointAllowed(c, a, knowledge)) continue;
                graph.setEndpoint(b, a, Endpoint.ARROW);
                graph.setEndpoint(c, a, Endpoint.ARROW);
                TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(b, a, c, sepset));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    public static void orientCollidersLocally(Knowledge knowledge, Graph graph, IndependenceTest test, int depth) {
        SearchGraphUtils.orientCollidersLocally(knowledge, graph, test, depth, null);
    }

    public static void orientCollidersLocally(Knowledge knowledge, Graph graph, IndependenceTest test, int depth, Set<Node> nodesToVisit) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        if (nodesToVisit == null) {
            nodesToVisit = new HashSet<Node>(graph.getNodes());
        }
        for (Node a : nodesToVisit) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node c;
                Node b = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1])) || !SearchGraphUtils.isArrowpointAllowed1(b, a, knowledge) || !SearchGraphUtils.isArrowpointAllowed1(c, a, knowledge) || SearchGraphUtils.existsLocalSepsetWith(b, a, c, test, graph, depth)) continue;
                graph.setEndpoint(b, a, Endpoint.ARROW);
                graph.setEndpoint(c, a, Endpoint.ARROW);
                TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(b, a, c));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    public static void orientCollidersLocallyDet(Knowledge knowledge, Graph graph, IndependenceTest test, int depth) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        List<Node> nodes = graph.getNodes();
        for (Node a : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node c;
                Node b = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1])) || !SearchGraphUtils.isArrowpointAllowed1(b, a, knowledge) || !SearchGraphUtils.isArrowpointAllowed1(c, a, knowledge) || !SearchGraphUtils.existsLocalSepsetWithoutDet(b, a, c, test, graph, depth)) continue;
                graph.setEndpoint(b, a, Endpoint.ARROW);
                graph.setEndpoint(c, a, Endpoint.ARROW);
                TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(b, a, c));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    public static boolean existsLocalSepsetWith(Node x, Node y, Node z, IndependenceTest test, Graph graph, int depth) {
        HashSet<Node> __nodes = new HashSet<Node>(graph.getAdjacentNodes(x));
        __nodes.addAll(graph.getAdjacentNodes(z));
        __nodes.remove(x);
        __nodes.remove(z);
        LinkedList<Node> _nodes = new LinkedList<Node>(__nodes);
        TetradLogger.getInstance().log("adjacencies", "Adjacents for " + x + "--" + y + "--" + z + " = " + _nodes);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = Math.min(_depth, _nodes.size());
        for (int d = 1; d <= _depth; ++d) {
            int[] choice;
            if (_nodes.size() < d) continue;
            ChoiceGenerator cg2 = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg2.next()) != null) {
                List<Node> condSet = SearchGraphUtils.asList(choice, _nodes);
                if (!condSet.contains(y) || !test.isIndependent(x, z, condSet)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean existsLocalSepsetWithout(Node x, Node y, Node z, IndependenceTest test, Graph graph, int depth) {
        HashSet<Node> __nodes = new HashSet<Node>(graph.getAdjacentNodes(x));
        __nodes.addAll(graph.getAdjacentNodes(z));
        __nodes.remove(x);
        __nodes.remove(z);
        LinkedList<Node> _nodes = new LinkedList<Node>(__nodes);
        TetradLogger.getInstance().log("adjacencies", "Adjacents for " + x + "--" + y + "--" + z + " = " + _nodes);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = Math.min(_depth, _nodes.size());
        for (int d = 0; d <= _depth; ++d) {
            int[] choice;
            if (_nodes.size() < d) continue;
            ChoiceGenerator cg2 = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg2.next()) != null) {
                List<Node> condSet = SearchGraphUtils.asList(choice, _nodes);
                if (condSet.contains(y) || !test.isIndependent(x, z, condSet)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean existsLocalSepsetWithoutDet(Node x, Node y, Node z, IndependenceTest test, Graph graph, int depth) {
        HashSet<Node> __nodes = new HashSet<Node>(graph.getAdjacentNodes(x));
        __nodes.addAll(graph.getAdjacentNodes(z));
        __nodes.remove(x);
        __nodes.remove(z);
        LinkedList<Node> _nodes = new LinkedList<Node>(__nodes);
        TetradLogger.getInstance().log("adjacencies", "Adjacents for " + x + "--" + y + "--" + z + " = " + _nodes);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = Math.min(_depth, _nodes.size());
        for (int d = 0; d <= _depth; ++d) {
            int[] choice;
            if (_nodes.size() < d) continue;
            ChoiceGenerator cg2 = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg2.next()) != null) {
                List<Node> condSet = SearchGraphUtils.asList(choice, _nodes);
                if (condSet.contains(y) || test.determines(condSet, y) || !test.isIndependent(x, z, condSet)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean meekR1Locally(Graph graph, Knowledge knowledge, IndependenceTest test, int depth) {
        List<Node> nodes = graph.getNodes();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Node a : nodes) {
                int[] combination;
                List<Node> adjacentNodes = graph.getAdjacentNodes(a);
                if (adjacentNodes.size() < 2) continue;
                ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node c;
                    Node b = adjacentNodes.get(combination[0]);
                    if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1]))) continue;
                    if (graph.getEndpoint(b, a) == Endpoint.ARROW && graph.isUndirectedFromTo(a, c)) {
                        if (SearchGraphUtils.existsLocalSepsetWithout(b, a, c, test, graph, depth) || !SearchGraphUtils.isArrowpointAllowed(a, c, knowledge)) continue;
                        graph.setEndpoint(a, c, Endpoint.ARROW);
                        TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1", graph.getEdge(a, c)));
                        changed = true;
                        continue;
                    }
                    if (graph.getEndpoint(c, a) != Endpoint.ARROW || !graph.isUndirectedFromTo(a, b) || SearchGraphUtils.existsLocalSepsetWithout(b, a, c, test, graph, depth) || !SearchGraphUtils.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1", graph.getEdge(a, b)));
                    changed = true;
                }
            }
        }
        return changed;
    }

    public static boolean meekR1Locally2(Graph graph, Knowledge knowledge, IndependenceTest test, int depth) {
        List<Node> nodes = graph.getNodes();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Node a : nodes) {
                int[] combination;
                List<Node> adjacentNodes = graph.getAdjacentNodes(a);
                if (adjacentNodes.size() < 2) continue;
                ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node c;
                    Node b = adjacentNodes.get(combination[0]);
                    if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1]))) continue;
                    if (graph.getEndpoint(b, a) == Endpoint.ARROW && graph.isUndirectedFromTo(a, c)) {
                        if (SearchGraphUtils.existsLocalSepsetWithoutDet(b, a, c, test, graph, depth) || !SearchGraphUtils.isArrowpointAllowed(a, c, knowledge)) continue;
                        graph.setEndpoint(a, c, Endpoint.ARROW);
                        TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1", graph.getEdge(a, c)));
                        changed = true;
                        continue;
                    }
                    if (graph.getEndpoint(c, a) != Endpoint.ARROW || !graph.isUndirectedFromTo(a, b) || SearchGraphUtils.existsLocalSepsetWithoutDet(b, a, c, test, graph, depth) || !SearchGraphUtils.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1", graph.getEdge(a, b)));
                    changed = true;
                }
            }
        }
        return changed;
    }

    public static boolean meekR2(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node b = adjacentNodes.get(combination[0]);
                Node c = adjacentNodes.get(combination[1]);
                if (graph.isDirectedFromTo(b, a) && graph.isDirectedFromTo(a, c) && graph.isUndirectedFromTo(b, c)) {
                    if (!SearchGraphUtils.isArrowpointAllowed(b, c, knowledge)) continue;
                    graph.setEndpoint(b, c, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(b, c)));
                    continue;
                }
                if (!graph.isDirectedFromTo(c, a) || !graph.isDirectedFromTo(a, b) || !graph.isUndirectedFromTo(c, b) || !SearchGraphUtils.isArrowpointAllowed(c, b, knowledge)) continue;
                graph.setEndpoint(c, b, Endpoint.ARROW);
                TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(c, b)));
            }
        }
        return changed;
    }

    public static boolean meekR3(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node b : adjacentNodes) {
                int[] combination;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(b);
                if (!graph.isUndirectedFromTo(a, b)) continue;
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node d;
                    Node c = (Node)otherAdjacents.get(combination[0]);
                    if (graph.isAdjacentTo(c, d = (Node)otherAdjacents.get(combination[1])) || !graph.isUndirectedFromTo(a, c) || !graph.isUndirectedFromTo(a, d) || !graph.isDirectedFromTo(c, b) || !graph.isDirectedFromTo(d, b) || !SearchGraphUtils.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R3", graph.getEdge(a, b)));
                    changed = true;
                    continue block1;
                }
            }
        }
        return changed;
    }

    public static boolean meekR4(Graph graph, Knowledge knowledge) {
        if (knowledge == null) {
            return false;
        }
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node d : adjacentNodes) {
                int[] combination;
                if (!graph.isAdjacentTo(a, d)) continue;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(d);
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node b = (Node)otherAdjacents.get(combination[0]);
                    Node c = (Node)otherAdjacents.get(combination[1]);
                    if (!graph.isUndirectedFromTo(a, b) || !graph.isUndirectedFromTo(a, c)) continue;
                    if (graph.isDirectedFromTo(b, c) && graph.isDirectedFromTo(d, c)) {
                        if (!SearchGraphUtils.isArrowpointAllowed(a, c, knowledge)) continue;
                        graph.setEndpoint(a, c, Endpoint.ARROW);
                        TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R4", graph.getEdge(a, c)));
                        changed = true;
                        continue block1;
                    }
                    if (!graph.isDirectedFromTo(c, d) || !graph.isDirectedFromTo(d, b) || !SearchGraphUtils.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R4", graph.getEdge(a, b)));
                    changed = true;
                    continue block1;
                }
            }
        }
        return changed;
    }

    public static boolean isArrowpointAllowed(Object from, Object to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.edgeRequired(to.toString(), from.toString()) && !knowledge.edgeForbidden(from.toString(), to.toString());
    }

    public static void pdagToDag(Graph g) {
        EdgeListGraph p = new EdgeListGraph(g);
        ArrayList<Edge> undirectedEdges = new ArrayList<Edge>();
        for (Edge edge : g.getEdges()) {
            if (edge.getEndpoint1() != Endpoint.TAIL || edge.getEndpoint2() != Endpoint.TAIL || undirectedEdges.contains(edge)) continue;
            undirectedEdges.add(edge);
        }
        g.removeEdges(undirectedEdges);
        List<Node> pNodes = p.getNodes();
        do {
            Node x = null;
            for (Node pNode : pNodes) {
                x = pNode;
                if (p.getChildren(x).size() > 0) continue;
                HashSet<Node> neighbors = new HashSet<Node>();
                for (Edge edge : p.getEdges()) {
                    if (edge.getNode1() != x && edge.getNode2() != x || edge.getEndpoint1() != Endpoint.TAIL || edge.getEndpoint2() != Endpoint.TAIL) continue;
                    if (edge.getNode1() == x) {
                        neighbors.add(edge.getNode2());
                        continue;
                    }
                    neighbors.add(edge.getNode1());
                }
                if (neighbors.size() > 0) {
                    List<Node> parents = p.getParents(x);
                    HashSet<Node> all = new HashSet<Node>(neighbors);
                    all.addAll(parents);
                    if (!GraphUtils.isClique(all, p)) continue;
                }
                for (Node neighbor : neighbors) {
                    Node node1 = g.getNode(neighbor.getName());
                    Node node2 = g.getNode(x.getName());
                    g.addDirectedEdge(node1, node2);
                }
                p.removeNode(x);
                break;
            }
            pNodes.remove(x);
        } while (pNodes.size() > 0);
    }

    public static void basicPattern(Graph graph) {
        HashSet<Edge> undirectedEdges = new HashSet<Edge>();
        block0: for (Edge edge : graph.getEdges()) {
            Node head = null;
            Node tail = null;
            if (edge.getEndpoint1() == Endpoint.ARROW && edge.getEndpoint2() == Endpoint.TAIL) {
                head = edge.getNode1();
                tail = edge.getNode2();
            } else if (edge.getEndpoint2() == Endpoint.ARROW && edge.getEndpoint1() == Endpoint.TAIL) {
                head = edge.getNode2();
                tail = edge.getNode1();
            }
            if (head == null) continue;
            for (Node node : graph.getParents(head)) {
                if (node == tail || graph.isAdjacentTo(tail, node)) continue;
                continue block0;
            }
            undirectedEdges.add(edge);
        }
        for (Edge nextUndirected : undirectedEdges) {
            Node node1 = nextUndirected.getNode1();
            Node node2 = nextUndirected.getNode2();
            graph.removeEdge(nextUndirected);
            graph.addUndirectedEdge(node1, node2);
        }
    }

    public static void dagToPdag(Graph graph) {
        int i;
        EdgeListGraph graphCopy = new EdgeListGraph(graph);
        Node[] orderedNodes = new Node[graphCopy.getNodes().size()];
        int count = 0;
        while (graphCopy.getNodes().size() > 0) {
            HashSet<Node> exogenousNodes = new HashSet<Node>();
            for (Node next : graphCopy.getNodes()) {
                if (!graphCopy.isExogenous(next)) continue;
                exogenousNodes.add(next);
                orderedNodes[count++] = graph.getNode(next.getName());
            }
            graphCopy.removeNodes(new ArrayList<Node>(exogenousNodes));
        }
        count = 0;
        Edge[] edges = new Edge[graph.getNumEdges()];
        boolean[] edgeOrdered = new boolean[graph.getNumEdges()];
        Edge[] orderedEdges = new Edge[graph.getNumEdges()];
        for (Edge edge : graph.getEdges()) {
            edges[count++] = edge;
        }
        for (int i2 = 0; i2 < edges.length; ++i2) {
            edgeOrdered[i2] = false;
        }
        while (count > 0) {
            for (Node orderedNode : orderedNodes) {
                for (int k = orderedNodes.length - 1; k >= 0; --k) {
                    for (int q = 0; q < edges.length; ++q) {
                        if (edgeOrdered[q] || edges[q].getNode1() != orderedNodes[k] || edges[q].getNode2() != orderedNode) continue;
                        edgeOrdered[q] = true;
                        orderedEdges[orderedEdges.length - count] = edges[q];
                        --count;
                    }
                }
            }
        }
        boolean[] compelledEdges = new boolean[graph.getNumEdges()];
        boolean[] reversibleEdges = new boolean[graph.getNumEdges()];
        for (i = 0; i < graph.getNumEdges(); ++i) {
            compelledEdges[i] = false;
            reversibleEdges[i] = false;
        }
        for (i = 0; i < graph.getNumEdges(); ++i) {
            if (compelledEdges[i] || reversibleEdges[i]) continue;
            Node x = orderedEdges[i].getNode1();
            Node y = orderedEdges[i].getNode2();
            for (int j = 0; j < orderedEdges.length; ++j) {
                if (orderedEdges[j].getNode2() == x && compelledEdges[j]) {
                    int k;
                    Node w = orderedEdges[j].getNode1();
                    if (!graph.isParentOf(w, y)) {
                        for (k = 0; k < orderedEdges.length; ++k) {
                            if (orderedEdges[k].getNode2() != y) continue;
                            compelledEdges[k] = true;
                            break;
                        }
                    } else {
                        for (k = 0; k < orderedEdges.length; ++k) {
                            if (orderedEdges[k].getNode1() != w || orderedEdges[k].getNode2() != y) continue;
                            compelledEdges[k] = true;
                            break;
                        }
                    }
                }
                if (compelledEdges[i]) break;
            }
            if (compelledEdges[i]) continue;
            boolean foundZ = false;
            for (Edge orderedEdge : orderedEdges) {
                Node z = orderedEdge.getNode1();
                if (z == x || orderedEdge.getNode2() != y || graph.isParentOf(z, x)) continue;
                compelledEdges[i] = true;
                for (int k = i + 1; k < graph.getNumEdges(); ++k) {
                    if (orderedEdges[k].getNode2() != y || reversibleEdges[k]) continue;
                    compelledEdges[k] = true;
                }
                foundZ = true;
                break;
            }
            if (foundZ) continue;
            reversibleEdges[i] = true;
            for (int j = i + 1; j < orderedEdges.length; ++j) {
                if (compelledEdges[j] || orderedEdges[j].getNode2() != y) continue;
                reversibleEdges[j] = true;
            }
        }
        for (i = 0; i < reversibleEdges.length; ++i) {
            if (!reversibleEdges[i]) continue;
            graph.setEndpoint(orderedEdges[i].getNode1(), orderedEdges[i].getNode2(), Endpoint.TAIL);
            graph.setEndpoint(orderedEdges[i].getNode2(), orderedEdges[i].getNode1(), Endpoint.TAIL);
        }
    }

    public static Graph patternFromDag(Graph dag) {
        EdgeListGraph graph = new EdgeListGraph(dag);
        SearchGraphUtils.basicPattern(graph);
        MeekRules rules = new MeekRules();
        rules.orientImplied(graph);
        return graph;
    }

    public static Graph dagFromPattern(Graph pattern) {
        EdgeListGraph graph = new EdgeListGraph(pattern);
        SearchGraphUtils.pdagToDag(graph);
        return graph;
    }

    public static void arrangeByKnowledgeTiers(Graph graph, Knowledge knowledge) {
        if (knowledge.getNumTiers() == 0) {
            throw new IllegalArgumentException("There are no Tiers to arrange.");
        }
        List<Node> nodes = graph.getNodes();
        ArrayList<String> varNames = new ArrayList<String>();
        int ySpace = 500 / knowledge.getNumTiers();
        ySpace = ySpace < 50 ? 50 : ySpace;
        for (Node node1 : nodes) {
            varNames.add(node1.getName());
        }
        List<String> notInTier = knowledge.getVarsNotInTier();
        int x = 0;
        int y = 50 - ySpace;
        if (notInTier.size() > 0) {
            y += ySpace;
            for (String name : notInTier) {
                x += 90;
                Node node = graph.getNode(name);
                if (node == null) continue;
                node.setCenterX(x);
                node.setCenterY(y);
            }
        }
        for (int i = 0; i < knowledge.getNumTiers(); ++i) {
            List<String> tier = knowledge.getTier(i);
            y += ySpace;
            x = -25;
            for (String name : tier) {
                x += 90;
                Node node = graph.getNode(name);
                if (node == null) continue;
                node.setCenterX(x);
                node.setCenterY(y);
            }
        }
    }

    public static boolean verifySepsetIntegrity(SepsetMap sepset, Graph pattern) {
        for (Node x : pattern.getNodes()) {
            for (Node y : pattern.getNodes()) {
                if (x == y || pattern.isAdjacentTo(y, x) == (sepset.get(x, y) == null)) continue;
                System.out.println("Sepset not consistent with graph for {" + x + ", " + y + "}");
                return false;
            }
        }
        return true;
    }

    public static Set<Node> getReachableNodes(List<Node> initialNodes, LegalPairs legalPairs, List<Node> c, List<Node> d, Graph graph, int maxPathLength) {
        HashSet<Node> reachable = new HashSet<Node>();
        MultiKeyMap visited = new MultiKeyMap();
        LinkedList<ReachabilityEdge> nextEdges = new LinkedList<ReachabilityEdge>();
        for (Node x : initialNodes) {
            List<Node> adjX = graph.getAdjacentNodes(x);
            for (Node y : adjX) {
                if (!legalPairs.isLegalFirstEdge(x, y)) continue;
                reachable.add(y);
                nextEdges.add(new ReachabilityEdge(x, y));
                visited.put(x, y, Boolean.TRUE);
            }
        }
        int pathLength = 1;
        while (nextEdges.size() > 0) {
            if (++pathLength > maxPathLength) {
                return reachable;
            }
            LinkedList<ReachabilityEdge> currEdges = nextEdges;
            nextEdges = new LinkedList();
            for (ReachabilityEdge edge : currEdges) {
                Node x = edge.getFrom();
                Node y = edge.getTo();
                List<Node> adjY = graph.getAdjacentNodes(y);
                for (Node z : adjY) {
                    if (visited.get(y, z) == Boolean.TRUE || !legalPairs.isLegalPair(x, y, z, c, d)) continue;
                    reachable.add(z);
                    nextEdges.add(new ReachabilityEdge(y, z));
                    visited.put(y, z, Boolean.TRUE);
                }
            }
        }
        return reachable;
    }

    public static Node translate(String a, List<Node> nodes) {
        for (Node node : nodes) {
            if (!node.getName().equals(a)) continue;
            return node;
        }
        return null;
    }

    public static List<Node> asList(int[] indices, List<Node> nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        for (int i : indices) {
            list.add(nodes.get(i));
        }
        return list;
    }

    public static List<Set<Node>> powerSet(List<Node> nodes) {
        ArrayList<Set<Node>> subsets = new ArrayList<Set<Node>>();
        int total = (int)Math.pow(2.0, nodes.size());
        for (int i = 0; i < total; ++i) {
            HashSet<Node> newSet = new HashSet<Node>();
            String selection = Integer.toBinaryString(i);
            for (int j = selection.length() - 1; j >= 0; --j) {
                if (selection.charAt(j) != '1') continue;
                newSet.add(nodes.get(selection.length() - j - 1));
            }
            subsets.add(newSet);
        }
        return subsets;
    }

    public static boolean isArrowpointAllowed1(Node from, Node to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.edgeRequired(((Object)to).toString(), ((Object)from).toString()) && !knowledge.edgeForbidden(((Object)from).toString(), ((Object)to).toString());
    }

    public static boolean isArrowpointAllowed2(Node from, Node to, Knowledge knowledge, Graph graph) {
        if (knowledge == null) {
            return true;
        }
        if (!graph.getNodesInTo(to, Endpoint.ARROW).isEmpty()) {
            return false;
        }
        return !knowledge.edgeRequired(((Object)to).toString(), ((Object)from).toString()) && !knowledge.edgeForbidden(((Object)from).toString(), ((Object)to).toString());
    }

    public static List<Graph> getDagsInPatternMeek(Graph pattern, Knowledge knowledge) {
        DagInPatternIterator iterator = new DagInPatternIterator(pattern);
        ArrayList<Graph> dags = new ArrayList<Graph>();
        while (iterator.hasNext()) {
            Graph graph = iterator.next();
            try {
                if (knowledge.isViolatedBy(graph)) continue;
                dags.add(graph);
            }
            catch (IllegalArgumentException e) {
                System.out.println("Found a non-DAG: " + graph);
            }
        }
        return dags;
    }

    public static List<Dag> getAllDagsInUndirectedGraph(Graph graph) {
        Graph undirected = GraphUtils.undirectedGraph(graph);
        DagIterator iterator = new DagIterator(undirected);
        ArrayList<Dag> dags = new ArrayList<Dag>();
        while (iterator.hasNext()) {
            Graph _graph = iterator.next();
            try {
                Dag dag = new Dag(_graph);
                dags.add(dag);
            }
            catch (IllegalArgumentException e) {}
        }
        return dags;
    }

    public static List<Dag> getAllDagsByDirectingUndirectedEdges(Graph graph) {
        DagIterator iterator = new DagIterator(graph);
        ArrayList<Dag> dags = new ArrayList<Dag>();
        while (iterator.hasNext()) {
            Graph _graph = iterator.next();
            try {
                Dag dag = new Dag(_graph);
                dags.add(dag);
            }
            catch (IllegalArgumentException e) {}
        }
        return dags;
    }

    public static Graph bestGuessCycleOrientation(Graph graph, IndependenceTest test) {
        List<Node> cycle;
        while ((cycle = GraphUtils.directedCycle(graph)) != null) {
            LinkedList<Node> _cycle = new LinkedList<Node>(cycle);
            Node first = _cycle.getFirst();
            Node last = _cycle.getLast();
            _cycle.addFirst(last);
            _cycle.addLast(first);
            int _j = -1;
            double minP = Double.POSITIVE_INFINITY;
            for (int j = 1; j < _cycle.size() - 1; ++j) {
                int i = j - 1;
                int k = j + 1;
                Node x = test.getVariable(_cycle.get(i).getName());
                Node y = test.getVariable(_cycle.get(j).getName());
                Node z = test.getVariable(_cycle.get(k).getName());
                test.isIndependent(x, z, Collections.singletonList(y));
                double p = test.getPValue();
                if (!(p < minP)) continue;
                _j = j;
                minP = p;
            }
            Node x = _cycle.get(_j - 1);
            Node y = _cycle.get(_j);
            Node z = _cycle.get(_j + 1);
            graph.removeEdge(x, y);
            graph.removeEdge(z, y);
            graph.addDirectedEdge(x, y);
            graph.addDirectedEdge(z, y);
        }
        return graph;
    }

    public static CpcTripleType getCpcTripleType(Node x, Node y, Node z, IndependenceTest test, int depth, Graph graph) {
        List<Node> condSet;
        int[] choice;
        ChoiceGenerator cg;
        int d;
        boolean existsSepsetContainingY = false;
        boolean existsSepsetNotContainingY = false;
        HashSet<Node> __nodes = new HashSet<Node>(graph.getAdjacentNodes(x));
        __nodes.remove(z);
        LinkedList<Node> _nodes = new LinkedList<Node>(__nodes);
        TetradLogger.getInstance().log("adjacencies", "Adjacents for " + x + "--" + y + "--" + z + " = " + _nodes);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = Math.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                condSet = GraphUtils.asList(choice, _nodes);
                if (!test.isIndependent(x, z, condSet)) continue;
                if (condSet.contains(y)) {
                    existsSepsetContainingY = true;
                    continue;
                }
                existsSepsetNotContainingY = true;
            }
        }
        __nodes = new HashSet<Node>(graph.getAdjacentNodes(z));
        __nodes.remove(x);
        _nodes = new LinkedList<Node>(__nodes);
        TetradLogger.getInstance().log("adjacencies", "Adjacents for " + x + "--" + y + "--" + z + " = " + _nodes);
        _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = Math.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                condSet = GraphUtils.asList(choice, _nodes);
                if (!test.isIndependent(x, z, condSet)) continue;
                if (condSet.contains(y)) {
                    existsSepsetContainingY = true;
                    continue;
                }
                existsSepsetNotContainingY = true;
            }
        }
        if (existsSepsetContainingY == existsSepsetNotContainingY) {
            return CpcTripleType.AMBIGUOUS;
        }
        if (!existsSepsetNotContainingY) {
            return CpcTripleType.NONCOLLIDER;
        }
        return CpcTripleType.COLLIDER;
    }

    public static Graph chooseDagInPattern(Graph graph) {
        EdgeListGraph newGraph = new EdgeListGraph(graph);
        for (Edge edge : newGraph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            newGraph.removeEdge(edge);
        }
        PatternToDag search = new PatternToDag(new Pattern(newGraph));
        Graph dag = search.patternToDagMeekRules();
        GraphUtils.arrangeBySourceGraph(dag, graph);
        return dag;
    }

    public static Graph patternForDag(Dag measuredGraph) {
        IndTestDSep test = new IndTestDSep(measuredGraph);
        return new Pc(test).search();
    }

    public static enum CpcTripleType {
        COLLIDER,
        NONCOLLIDER,
        AMBIGUOUS;

    }

    private static class ReachabilityEdge {
        private Node from;
        private Node to;

        public ReachabilityEdge(Node from, Node to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int hash = 17;
            hash += 63 * ((Object)this.getFrom()).hashCode();
            return hash += 71 * ((Object)this.getTo()).hashCode();
        }

        public boolean equals(Object obj) {
            ReachabilityEdge edge = (ReachabilityEdge)obj;
            if (!((Object)edge.getFrom()).equals(this.getFrom())) {
                return false;
            }
            return ((Object)edge.getTo()).equals(this.getTo());
        }

        public Node getFrom() {
            return this.from;
        }

        public Node getTo() {
            return this.to;
        }
    }
}

