/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;

public class SearchLogUtils {
    private static NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();

    public static String endpointOrientedMsg(Endpoint e, Node x, Node y) {
        char endptChar = '*';
        if (e == Endpoint.TAIL) {
            endptChar = '-';
        } else if (e == Endpoint.ARROW) {
            endptChar = '>';
        } else if (e == Endpoint.CIRCLE) {
            endptChar = 'o';
        }
        String msg = "Orienting endpoint: " + x.getName() + " *-" + endptChar + " " + y.getName();
        return msg;
    }

    public static String edgeOrientedMsg(String reason, Edge edge) {
        return "Orienting edge (" + reason + "): " + edge;
    }

    public static String colliderOrientedMsg(String note, Node x, Node y, Node z) {
        return "Orienting collider (" + note + "): " + x.getName() + " *-> " + y.getName() + " <-* " + z.getName();
    }

    public static String colliderOrientedMsg(Node x, Node y, Node z) {
        return "Orienting collider: " + x.getName() + " *-> " + y.getName() + " <-* " + z.getName();
    }

    public static String colliderOrientedMsg(Node x, Node y, Node z, List sepset) {
        return "Orienting collider: " + x.getName() + " *-> " + y.getName() + " <-* " + z.getName() + "\t(Sepset = " + sepset + ")";
    }

    public static String independenceFactMsg(Node x, Node y, List<Node> condSet, double pValue) {
        StringBuilder sb = new StringBuilder();
        sb.append("Independence accepted: ");
        sb.append(SearchLogUtils.independenceFact(x, y, condSet));
        if (!Double.isNaN(pValue)) {
            sb.append("\tp = ").append(nf.format(pValue));
        }
        return sb.toString();
    }

    public static String dependenceFactMsg(Node x, Node y, List<Node> condSet, double pValue) {
        StringBuilder sb = new StringBuilder();
        sb.append("Dependent: ");
        sb.append(SearchLogUtils.independenceFact(x, y, condSet));
        if (!Double.isNaN(pValue)) {
            sb.append("\tp = ").append(nf.format(pValue));
        }
        return sb.toString();
    }

    public static String independenceFact(Node x, Node y, List<Node> condSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(x.getName());
        sb.append(" _||_ ");
        sb.append(y.getName());
        Iterator<Node> it = condSet.iterator();
        if (it.hasNext()) {
            sb.append(" | ");
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(", ");
            sb.append(it.next());
        }
        return sb.toString();
    }
}

