/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConverter;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.search.Cfci;
import edu.cmu.tetrad.search.FciOld;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFciSearch
extends TestCase {
    public TestFciSearch(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public void testSearch1() {
        System.out.println("Test1");
        this.checkSearch("X1-->X2,X1-->X3,X2-->X4,X3-->X4", "X1o-oX2,X1o-oX3,X2o->X4,X3o->X4", new Knowledge());
    }

    public void testSearch2() {
        System.out.println("Test2");
        this.checkSearch("Z1-->X,Z2-->X,X-->Y", "Z1o->X,Z2o->X,X-->Y", new Knowledge());
    }

    public void testSearch3() {
        System.out.println("Test3");
        this.checkSearch("A-->C,B-->C,B-->D,C-->D", "Ao->C,Bo->C,B-->D,C-->D", new Knowledge());
    }

    public void testSearch4() {
        System.out.println("Test4");
        this.checkSearch("A-->C,B-->C,B-->D,C-->D,E", "Ao->C,Bo->C,B-->D,C-->D,E", new Knowledge());
    }

    public void testSearch5() {
        System.out.println("Test5");
        this.checkSearch("A-->B", "Ao-oB", new Knowledge());
    }

    public void testSearch6() {
        System.out.println("Test6");
        this.checkSearch("Latent(E),Latent(G),E-->D,E-->H,G-->H,G-->L,D-->L,D-->M,H-->M,L-->M,S-->D,I-->S,P-->S", "D<->H,H<->L,D-->L,D-->M,H-->M,L-->M,S-->D,Io->S,Po->S", new Knowledge());
    }

    public void testSearch7() {
        System.out.println("Test7");
        this.checkSearch("X-->Z,Y-->Z,Z-->B,B-->A,C-->A", "Xo->Z,Yo->Z,Z-->B,B-->A,Co->A", new Knowledge());
    }

    public void testSearch8() {
        System.out.println("Test8");
        this.checkSearch("Latent(T1),Latent(T2),T1-->A,T1-->B,B-->E,F-->B,C-->F,C-->H,H-->D,D-->A,T2-->D,T2-->E", "A<->B,B-->E,Fo->B,Fo-oC,Co-oH,Ho->D,D<->E,D-->A", new Knowledge());
    }

    public void testSearch9() {
        System.out.println("Test9");
        this.checkSearch("A-->D,A-->B,B-->D,C-->D,D-->E", "Ao->D,Ao-oB,Bo->D,Co->D,D-->E", new Knowledge());
    }

    public void testSearch10() {
        System.out.println("Test10");
        this.checkSearch("Latent(L1),Latent(L2),L1-->X1,L1-->X2,L2-->X2,L2-->X3", "X1o->X2,X3o->X2", new Knowledge());
        Knowledge knowledge = new Knowledge();
        knowledge.addToTier(1, "X1");
        knowledge.addToTier(1, "X2");
        knowledge.addToTier(2, "X3");
        this.checkSearch("Latent(L1),Latent(L2),L1-->X1,L1-->X2,L2-->X2,L2-->X3", "X1o->X2,X3<->X2", knowledge);
    }

    public void testSearch11() {
        System.out.println("Test11");
        this.checkSearch("Latent(L1),X1-->X2,X3-->X4,L1-->X2,L1-->X4", "X1o->X2,X3o->X4,X2<->X4", new Knowledge());
        Knowledge knowledge = new Knowledge();
        knowledge.setEdgeRequired("X2", "X4", true);
        System.out.println(knowledge);
        this.checkSearch("Latent(L1),X1-->X2,X3-->X4,L1-->X2,L1-->X4", "X1o-oX2,X3o->X4,X2-->X4", knowledge);
    }

    public void testMarginal() {
        System.out.println("Marginal Test");
        ContinuousVariable A = new ContinuousVariable("X1");
        ContinuousVariable B = new ContinuousVariable("X2");
        ContinuousVariable C = new ContinuousVariable("X3");
        ContinuousVariable D = new ContinuousVariable("X4");
        EdgeListGraph G1 = new EdgeListGraph(Arrays.asList(A, B, C, D));
        G1.addEdge(new Edge(A, B, Endpoint.TAIL, Endpoint.ARROW));
        G1.addEdge(new Edge(D, B, Endpoint.TAIL, Endpoint.ARROW));
        G1.addEdge(new Edge(A, C, Endpoint.TAIL, Endpoint.ARROW));
        G1.addEdge(new Edge(C, D, Endpoint.TAIL, Endpoint.ARROW));
        FciOld fci1 = new FciOld(new IndTestDSep(G1));
        System.out.println(fci1.search());
        FciOld fci2 = new FciOld(new IndTestDSep(G1), Arrays.asList(A, B, C));
        System.out.println(fci2.search());
        FciOld fci3 = new FciOld(new IndTestDSep(G1), Arrays.asList(A, B, D));
        System.out.println(fci3.search());
        FciOld fci4 = new FciOld(new IndTestDSep(G1), Arrays.asList(A, D, C));
        System.out.println(fci4.search());
        FciOld fci5 = new FciOld(new IndTestDSep(G1), Arrays.asList(B, D, C));
        System.out.println(fci5.search());
    }

    public void rtestSearch4() {
        int numVars = 40;
        int numEdges = 40;
        int sampleSize = 1000;
        boolean latentDataSaved = false;
        Dag trueGraph = GraphUtils.randomDag(numVars, 10, numEdges, 7, 5, 5, false);
        System.out.println("\nInput graph:");
        System.out.println(trueGraph);
        SemPm bayesPm = new SemPm(trueGraph);
        SemIm bayesIm = new SemIm(bayesPm);
        DataSet dataSet = bayesIm.simulateData(sampleSize, latentDataSaved);
        IndTestFisherZ test = new IndTestFisherZ(dataSet, 0.1);
        FciOld search = new FciOld(test);
        Graph resultGraph = search.search();
        System.out.println("\nResult graph:");
        System.out.println(resultGraph);
    }

    public void rtestSearch5() {
        int numVars = 30;
        int numEdges = 30;
        int sampleSize = 1000;
        boolean latentDataSaved = false;
        Dag trueGraph = GraphUtils.randomDag(numVars, 10, numEdges, 7, 5, 5, false);
        System.out.println("\nInput graph:");
        System.out.println(trueGraph);
        System.out.println("\n# vars = " + numVars);
        SemPm bayesPm = new SemPm(trueGraph);
        SemIm bayesIm = new SemIm(bayesPm);
        DataSet dataSet = bayesIm.simulateData(sampleSize, latentDataSaved);
        IndTestFisherZ test = new IndTestFisherZ(dataSet, 0.05);
        System.out.println("\nUsing local test:");
        Cfci search2 = new Cfci(test);
        Graph resultGraph2 = search2.search();
        System.out.println("Elapsed time = " + (double)search2.getElapsedTime() / 1000.0);
        System.out.println(resultGraph2);
        System.out.println("\nUsing sepsets:");
        FciOld search = new FciOld(test);
        Graph resultGraph = search.search();
        System.out.println("Elapsed time = " + (double)search.getElapsedTime() / 1000.0);
        System.out.println(resultGraph);
    }

    public void rtestSearch6() {
        int numVars = 80;
        int numEdges = 80;
        int sampleSize = 1000;
        boolean latentDataSaved = false;
        int numLatents = 40;
        Dag trueGraph = GraphUtils.randomDag(numVars, numLatents, numEdges, 7, 5, 5, false);
        System.out.println("\nInput graph:");
        System.out.println(trueGraph);
        SemPm bayesPm = new SemPm(trueGraph);
        SemIm bayesIm = new SemIm(bayesPm);
        DataSet dataSet = bayesIm.simulateData(sampleSize, latentDataSaved);
        IndTestFisherZ test = new IndTestFisherZ(dataSet, 0.05);
        Cfci search = new Cfci(test);
        Graph resultGraph = search.search();
        System.out.println("\nResult graph:");
        System.out.println(resultGraph);
    }

    private void checkSearch(String inputGraph, String outputGraph, Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        Graph graph = GraphConverter.convert(inputGraph);
        IndTestDSep independence = new IndTestDSep(graph);
        FciOld fci = new FciOld(independence);
        fci.setKnowledge(knowledge);
        Graph resultGraph = fci.search();
        EdgeListGraph compareGraph = new EdgeListGraph(GraphConverter.convert(outputGraph));
        System.out.println("FCI:");
        System.out.println("Input graph:");
        System.out.println(graph);
        System.out.println("Result graph:");
        System.out.println(resultGraph);
        System.out.println("True graph:");
        System.out.println(compareGraph);
        resultGraph.setUnderLineTriples(compareGraph.getUnderLines());
        resultGraph.setDottedUnderLineTriples(compareGraph.getDottedUnderlines());
        TestFciSearch.assertTrue(((Object)compareGraph).equals(resultGraph));
        Cfci cfci = new Cfci(independence);
        cfci.setKnowledge(knowledge);
        Graph _resultGraph = cfci.search();
        System.out.println("CFCI:");
        System.out.println("Input graph:");
        System.out.println(graph);
        System.out.println("Result graph:");
        System.out.println(_resultGraph);
        System.out.println("True graph:");
        System.out.println(compareGraph);
        resultGraph.setUnderLineTriples(compareGraph.getUnderLines());
        resultGraph.setDottedUnderLineTriples(compareGraph.getDottedUnderlines());
        TestFciSearch.assertTrue(((Object)compareGraph).equals(resultGraph));
    }

    public void testOrientationRules() {
    }

    public static Test suite() {
        return new TestSuite(TestFciSearch.class);
    }
}

