/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.TestEdgeListGraph;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.DepthChoiceGenerator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestGraph
extends TestCase {
    private Node x1;
    private Node x2;
    private Node x3;
    private Node x4;
    private Node x5;
    private Graph graph;

    public TestGraph(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        this.x1 = new GraphNode("x1");
        this.x2 = new GraphNode("x2");
        this.x3 = new GraphNode("x3");
        this.x4 = new GraphNode("x4");
        this.x5 = new GraphNode("x5");
        this.graph = new EdgeListGraph();
    }

    public void testDSeparation() {
        Dag graph = GraphUtils.randomDag(20, 0, 30, 3, 3, 3, false);
        List<Node> nodes = graph.getNodes();
        int depth = 2;
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                int[] choice;
                Node x = nodes.get(i);
                Node y = nodes.get(j);
                ArrayList<Node> theRest = new ArrayList<Node>(nodes);
                theRest.remove(x);
                theRest.remove(y);
                DepthChoiceGenerator gen = new DepthChoiceGenerator(theRest.size(), depth);
                while ((choice = gen.next()) != null) {
                    LinkedList<Node> z = new LinkedList<Node>();
                    for (int k = 0; k < choice.length; ++k) {
                        z.add((Node)theRest.get(choice[k]));
                    }
                    if (graph.isDSeparatedFrom(x, y, z) == graph.isDSeparatedFrom(y, x, z)) continue;
                    TestGraph.fail(SearchLogUtils.independenceFact(x, y, z) + " should have same d-sep result as " + SearchLogUtils.independenceFact(y, x, z));
                }
            }
        }
    }

    public void testDSeparation2() {
        Dag graph = GraphUtils.randomDag(20, 0, 30, 3, 3, 3, false);
        IndTestDSep test = new IndTestDSep(graph);
        Pc pc = new Pc(test);
        Graph pattern = pc.search();
        Graph pattern2 = SearchGraphUtils.patternFromDag(pattern);
        TestGraph.assertEquals(pattern, pattern2);
    }

    public static Test suite() {
        return new TestSuite(TestEdgeListGraph.class);
    }
}

