/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DelimiterType;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.HitonOld;
import edu.cmu.tetrad.search.IndTestChiSquare;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestHiton
extends TestCase {
    static Graph testGraphSub;
    static Graph testGraphSubCorrect;

    public TestHiton(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public void test1() {
    }

    public void rtestHiton() {
        try {
            String filenameD1 = "test_data/markovBlanketTestDisc.dat";
            File fileD1 = new File(filenameD1);
            double alpha = 0.05;
            String targetVariableString = "A1";
            int depth = 2;
            DataReader reader = new DataReader();
            reader.setDelimiter(DelimiterType.TAB);
            reader.setCommentMarker("#");
            DataSet dds1 = reader.parseTabular(fileD1);
            IndTestChiSquare test = new IndTestChiSquare(dds1, alpha);
            HitonOld hitonSearch = new HitonOld(test, depth);
            Graph currentMb = hitonSearch.search(targetVariableString);
            System.out.println("Output of HITON-MB = " + currentMb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Test suite() {
        return new TestSuite(TestHiton.class);
    }
}

