/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.RegressionUtils;
import edu.cmu.tetrad.search.Ges;
import edu.cmu.tetrad.search.GraphWithParameters;
import edu.cmu.tetrad.search.Lingam;
import edu.cmu.tetrad.search.Lingam_old;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.StudentT;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.LowerTriangDenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.QL;
import no.uib.cipr.matrix.QR;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;

public class TestLingam
extends TestCase {
    public TestLingam(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        RandomUtil.getInstance().setSeed(128583858L);
    }

    public void test1() {
        DataReader reader = new DataReader();
        DataSet data = null;
        try {
            data = reader.parseTabular(new File("sample_data/roidata.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Lingam lingam = new Lingam();
        Graph graph = lingam.search(data);
        System.out.println(graph);
    }

    public void testSqrtMatrix() {
        Dag graph = GraphUtils.randomDag(5, 0, 5, 4, 4, 4, false);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        DataSet data = im.simulateData(1000, false);
        CovarianceMatrix cov = new CovarianceMatrix(data);
        DoubleMatrix2D m = cov.getMatrix();
        EigenvalueDecomposition eig = new EigenvalueDecomposition(m);
        DoubleMatrix2D d = DoubleFactory2D.dense.diagonal(eig.getRealEigenvalues());
        DoubleMatrix2D v = eig.getV();
        System.out.println("d = " + d);
        System.out.println("v = " + v);
        for (int k = 0; k < 5; ++k) {
            d.set(k, k, Math.sqrt(d.get(k, k)));
        }
        Algebra a = new Algebra();
        DoubleMatrix2D prod = a.mult(a.mult(v, d), v.viewDice());
        System.out.println("V-1DV = " + prod);
        prod = a.mult(prod, prod);
        System.out.println("prod = " + prod);
        System.out.println(m);
    }

    public void testLingam() {
        DataSet data;
        Dag graph = GraphUtils.randomDag(5, 0, 5, 3, 3, 3, false);
        System.out.println(graph);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        for (Node node : im.getSemPm().getVariableNodes()) {
            im.setDistribution(node, new StudentT(2.0));
        }
        DataReader reader = new DataReader();
        try {
            data = reader.parseTabular(new File("sample_data/lingamsample.txt"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("For simulated data:");
        DataUtils.printAndersonDarlingPs(data);
        Lingam lingam = new Lingam();
        Lingam.EstimateResult result = lingam.estimate(data.getDoubleData());
    }

    public void testLingam2() {
        DataSet data;
        DataReader reader = new DataReader();
        try {
            data = reader.parseTabular(new File("sample_data/lingamsample.txt"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Ges ges = new Ges(data);
        System.out.println("GES " + ges.search());
        Lingam_old lingam = new Lingam_old();
        lingam.setAlpha(0.05);
        GraphWithParameters gwp = lingam.lingam(data);
        Dag lingamDag = new Dag(gwp.getGraph());
        System.out.println(lingamDag);
        DataSet residuals = RegressionUtils.residuals(data, lingamDag);
        System.out.println("For residuals:");
        DataUtils.printAndersonDarlingPs(residuals);
    }

    public void testLingam3() {
        DataSet data;
        DataReader reader = new DataReader();
        try {
            data = reader.parseTabular(new File("sample_data/lingamsample.txt"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("For simulated data:");
        DataUtils.printAndersonDarlingPs(data);
        Lingam lingam = new Lingam();
        int[] k = new int[]{1, 2, 0, 4, 3};
        DoubleMatrix2D matrix2D = data.getDoubleData();
        DoubleMatrix2D bTilde = lingam.pruneEdgesByResampling(matrix2D, k);
        System.out.println("ans = " + bTilde);
    }

    public void testIperm() {
        int[] k = new int[]{1, 2, 0};
        System.out.println(Arrays.toString(new Lingam().iperm(k)));
    }

    public void testQlQr() {
        long seed = RandomUtil.getInstance().getSeed();
        RandomUtil.getInstance().setSeed(384827384L);
        Dag graph = GraphUtils.randomDag(5, 0, 5, 3, 3, 3, false);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        DataSet data = im.simulateData(1000, false);
        CovarianceMatrix cov = new CovarianceMatrix(data);
        DoubleMatrix2D matrix = cov.getMatrix();
        System.out.println(matrix);
        DenseMatrix matrix2 = new DenseMatrix(matrix.toArray());
        QL ql = QL.factorize(new DenseMatrix(matrix2));
        LowerTriangDenseMatrix l = ql.getL();
        System.out.println(new DenseDoubleMatrix2D(Matrices.getArray(l)));
        matrix2.transpose();
        QR qr = QR.factorize(new DenseMatrix(matrix2));
        UpperTriangDenseMatrix r = qr.getR();
        System.out.println(new DenseDoubleMatrix2D(Matrices.getArray(r)));
        RandomUtil.getInstance().setSeed(seed);
    }

    public static Test suite() {
        return new TestSuite(TestLingam.class);
    }
}

