/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConverter;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.MbUtils;
import edu.cmu.tetrad.search.Mbfs;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMbfs
extends TestCase {
    static Graph testGraphSub;
    static Graph testGraphSubCorrect;

    public TestMbfs(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public static void testSubgraph1() {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
        Graph graph = GraphConverter.convert("T-->X,X-->Y,W-->X,W-->Y");
        IndTestDSep test = new IndTestDSep(graph);
        Mbfs mbSearch = new Mbfs(test, -1);
        mbSearch.search("T");
    }

    public static void testSubgraph2() {
        Graph graph = GraphConverter.convert("P1-->T,P2-->T,T-->C1,T-->C2,T-->C3,PC1a-->C1,PC1b-->C1,PC2a-->C2,PC2b<--C2,PC3a-->C3,PC3b-->C3,PC1b-->PC2a,PC1a<--PC3b,U,V");
        System.out.println("True graph is: " + graph);
        IndTestDSep test = new IndTestDSep(graph);
        Mbfs mbSearch = new Mbfs(test, -1);
        mbSearch.search("T");
    }

    public static void testGenerateDaglist() {
        Graph graph = GraphConverter.convert("T-->X1,T-->X2,X1-->X2,T-->X3,X4-->T");
        System.out.println("True graph is: " + graph);
        IndTestDSep test = new IndTestDSep(graph);
        Mbfs search = new Mbfs(test, -1);
        Graph resultGraph = search.search("T");
        System.out.println("\n\n################### MB DAGS #################");
        List<Graph> mbDags = MbUtils.generateMbDags(resultGraph, true, search.getTest(), search.getDepth(), search.getTarget());
        System.out.println("Number of dags = " + mbDags.size());
        System.out.println(mbDags);
        TestMbfs.assertTrue(mbDags.size() == 9);
        TestMbfs.assertTrue(mbDags.contains(graph));
    }

    public static void testRandom() {
        RandomUtil.getInstance().setSeed(8388428832L);
        Dag dag = GraphUtils.randomDag(10, 0, 10, 5, 5, 5, false);
        IndTestDSep test = new IndTestDSep(dag);
        Mbfs search = new Mbfs(test, -1);
        System.out.println("INDEPENDENT GRAPH: " + dag);
        List<Node> nodes = dag.getNodes();
        for (Node node : nodes) {
            Graph resultMb = search.search(node.getName());
            Dag trueMb = GraphUtils.markovBlanketDag(node, dag);
            List<Node> resultNodes = resultMb.getNodes();
            List<Node> trueNodes = trueMb.getNodes();
            HashSet<String> resultNames = new HashSet<String>();
            for (Node resultNode : resultNodes) {
                resultNames.add(resultNode.getName());
            }
            HashSet<String> trueNames = new HashSet<String>();
            for (Node v : trueNodes) {
                trueNames.add(v.getName());
            }
            System.out.println("result names = " + resultNames);
            System.out.println("true names = " + trueNames);
            TestMbfs.assertTrue(((Object)resultNames).equals(trueNames));
            List<Edge> resultEdges = resultMb.getEdges();
            for (Edge resultEdge : resultEdges) {
                if (!Edges.isDirectedEdge(resultEdge)) continue;
                String name1 = resultEdge.getNode1().getName();
                String name2 = resultEdge.getNode2().getName();
                Node node1 = trueMb.getNode(name1);
                Node node2 = trueMb.getNode(name2);
                if (node1 == null) {
                    System.err.println("Node " + name1 + " is not in the true graph.");
                    continue;
                }
                if (node2 == null) {
                    System.err.println("Node " + name2 + " is not in the true graph.");
                    continue;
                }
                Edge trueEdge = trueMb.getEdge(node1, node2);
                if (trueEdge == null) {
                    Node resultNode1 = resultMb.getNode(node1.getName());
                    Node resultNode2 = resultMb.getNode(node2.getName());
                    Node resultTarget = resultMb.getNode(node.getName());
                    Edge a = resultMb.getEdge(resultNode1, resultTarget);
                    Edge b = resultMb.getEdge(resultNode2, resultTarget);
                    if (a == null || b == null || Edges.isDirectedEdge(a) && Edges.isUndirectedEdge(b) || Edges.isUndirectedEdge(a) && Edges.isDirectedEdge(b)) continue;
                    TestMbfs.fail("EXTRA EDGE: Edge in result MB but not true MB = " + resultEdge);
                }
                TestMbfs.assertEquals(resultEdge.getEndpoint1(), trueEdge.getEndpoint1());
                TestMbfs.assertEquals(resultEdge.getEndpoint2(), trueEdge.getEndpoint2());
                System.out.println("Result edge = " + resultEdge + ", true edge = " + trueEdge);
            }
            List<Edge> trueEdges = trueMb.getEdges();
            for (Edge trueEdge : trueEdges) {
                Node node1 = trueEdge.getNode1();
                Node node2 = trueEdge.getNode2();
                Node resultNode1 = resultMb.getNode(node1.getName());
                Node resultNode2 = resultMb.getNode(node2.getName());
                TestMbfs.assertTrue("Expected adjacency " + resultNode1 + "---" + resultNode2, resultMb.isAdjacentTo(resultNode1, resultNode2));
            }
        }
    }

    public void testLoadFile() {
        try {
            String line;
            File inFile = new File("test_data/cancer.txt");
            File outFile = new File("test_data/cancer2.txt");
            BufferedReader in = new BufferedReader(new FileReader(inFile));
            PrintWriter out = new PrintWriter(new FileWriter(outFile));
            in.readLine();
            while ((line = in.readLine()) != null) {
                String[] tokens = line.split("\t");
                for (int i = 2; i < tokens.length; ++i) {
                    out.print(tokens[i]);
                    if (i >= tokens.length - 1) continue;
                    out.print("\t");
                }
                out.println();
            }
            in.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Test suite() {
        return new TestSuite(TestMbfs.class);
    }
}

