/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.search.BDeuScore;
import edu.cmu.tetrad.search.Cpc;
import edu.cmu.tetrad.search.Ges;
import edu.cmu.tetrad.search.Icpc;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndTestGSquare;
import edu.cmu.tetrad.search.MdluScore;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMdlu
extends TestCase {
    public TestMdlu(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public void rtestMdlu() {
        for (int i = 0; i < 20; ++i) {
            Dag graph = GraphUtils.randomDag(10, 20, false);
            Pc pc = new Pc(new IndTestDSep(graph));
            Graph knowledgePattern = pc.search();
            BayesPm pm = new BayesPm(graph, 2, 4);
            MlBayesIm im = new MlBayesIm(pm, 1);
            DataSet data = im.simulateData(50000, false);
            MdluScore mdlu = new MdluScore(data, 0.001);
            BDeuScore bdeu = new BDeuScore(data, 10.0, 0.001);
            Ges ges = new Ges(data);
            ges.setDiscreteScore(bdeu);
            Graph pattern1 = ges.search();
            Ges ges2 = new Ges(data);
            ges2.setDiscreteScore(mdlu);
            Graph pattern2 = ges2.search();
            Cpc cpc = new Cpc(new IndTestGSquare(data, 0.01));
            Graph pattern3 = cpc.search();
            Icpc icpc = new Icpc(new IndTestGSquare(data, 1.0E-4));
            Graph pattern4 = icpc.search();
            ArrayList<Graph> patterns = new ArrayList<Graph>();
            patterns.add(pattern1);
            patterns.add(pattern2);
            patterns.add(pattern3);
            patterns.add(pattern4);
            this.printErrors(graph, knowledgePattern, patterns);
        }
    }

    private void printErrors(Graph graph, Graph knowledgePattern, List<Graph> patterns) {
        for (Graph pattern : patterns) {
            int adjFp = GraphUtils.adjacenciesComplement(pattern, knowledgePattern).size();
            int adjFn = GraphUtils.adjacenciesComplement(knowledgePattern, pattern).size();
            int orientationErrors = GraphUtils.numDifferentOrientations(pattern, knowledgePattern);
            int directedrientationErrors = GraphUtils.numDifferentOrientationsDirected(pattern, graph);
            System.out.print(adjFp + "\t" + adjFn + "\t" + orientationErrors + "\t" + directedrientationErrors + "\t");
        }
        System.out.println();
    }

    public static Test suite() {
        return new TestSuite(TestMdlu.class);
    }
}

