/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConverter;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Pattern;
import edu.cmu.tetrad.search.PatternToDag;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPatternToDag
extends TestCase {
    public TestPatternToDag(String name) {
        super(name);
    }

    public void testChickeringAlgorithm() {
        GraphNode A = new GraphNode("A");
        GraphNode B = new GraphNode("B");
        GraphNode C = new GraphNode("C");
        GraphNode D = new GraphNode("D");
        GraphNode E = new GraphNode("E");
        Pattern pattern = new Pattern();
        pattern.addNode(A);
        pattern.addNode(B);
        pattern.addNode(C);
        pattern.addNode(D);
        pattern.addNode(E);
        pattern.addUndirectedEdge(A, B);
        pattern.addUndirectedEdge(B, C);
        pattern.addUndirectedEdge(C, E);
        pattern.addUndirectedEdge(A, D);
        pattern.addUndirectedEdge(B, D);
        pattern.addUndirectedEdge(C, D);
        pattern.addUndirectedEdge(E, D);
        Pattern pattern1 = new Pattern(pattern);
        PatternToDag search1 = new PatternToDag(pattern1);
        Dag dag1 = search1.patternToDagDorTarsi();
        Graph correctDag = GraphConverter.convert("B-->A,D-->A,C-->B,D-->B,E-->C,D-->C,E-->D");
        System.out.println("Correct DAG");
        System.out.println(correctDag);
        System.out.println("Result 1:  ");
        System.out.println(dag1);
        TestPatternToDag.assertTrue(((Object)correctDag).equals(dag1));
        Pattern pattern2 = new Pattern(pattern);
        PatternToDag search2 = new PatternToDag(pattern2);
        Graph dag2 = search2.patternToDagMeekRules();
        System.out.println("Result 2:  ");
        System.out.println(dag2);
    }

    public static Test suite() {
        return new TestSuite(TestPatternToDag.class);
    }
}

