/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConverter;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Cpc;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndTestFisherZOnTheFly;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Mbfs;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.sem.LargeSemSimulator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPc
extends TestCase {
    public TestPc(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
        RandomUtil.getInstance().setSeed(-1857293L);
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public void testSearch1() {
        this.checkSearch("X1-->X2,X1-->X3,X2-->X4,X3-->X4", "X1---X2,X1---X3,X2-->X4,X3-->X4");
    }

    public void testSearch2() {
        this.checkSearch2("X1-->X2,X1-->X3,X2-->X4,X3-->X4", "X1---X2,X1---X3,X2-->X4,X3-->X4");
    }

    public void testSearch3() {
        this.checkSearch("A-->D,A-->B,B-->D,C-->D,D-->E", "A-->D,A---B,B-->D,C-->D,D-->E");
    }

    public void testSearch4() {
        Knowledge knowledge = new Knowledge();
        knowledge.setEdgeForbidden("B", "D", true);
        knowledge.setEdgeForbidden("D", "B", true);
        knowledge.setEdgeForbidden("C", "B", true);
        this.checkWithKnowledge("A-->B,C-->B,B-->D", "A-->B,C-->B,A-->D,C-->D", knowledge);
    }

    public void rtestShowInefficiency() {
        int numVars = 20;
        int numEdges = 20;
        int maxSample = 2000;
        int increment = 1;
        Dag trueGraph = GraphUtils.randomDag(numVars, 0, numEdges, 7, 5, 5, false);
        System.out.println("\nInput graph:");
        System.out.println(trueGraph);
        SemPm semPm = new SemPm(trueGraph);
        SemIm semIm = new SemIm(semPm);
        DataSet _dataSet = semIm.simulateData(maxSample, false);
        Graph previousResult = null;
        for (int n = 3; n <= maxSample; n += increment) {
            int[] rows = new int[n];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = i;
            }
            DataSet dataSet = _dataSet.subsetRows(rows);
            IndTestFisherZ test = new IndTestFisherZ(dataSet, 0.05);
            Cpc search = new Cpc(test);
            Graph resultGraph = search.search();
            if (previousResult != null) {
                List<Edge> resultEdges = resultGraph.getEdges();
                List<Edge> previousEdges = previousResult.getEdges();
                LinkedList<Edge> addedEdges = new LinkedList<Edge>();
                for (Edge edge : resultEdges) {
                    if (previousEdges.contains(edge)) continue;
                    addedEdges.add(edge);
                }
                LinkedList<Edge> removedEdges = new LinkedList<Edge>();
                for (Edge edge : previousEdges) {
                    if (resultEdges.contains(edge)) continue;
                    removedEdges.add(edge);
                }
                if (!addedEdges.isEmpty() && !removedEdges.isEmpty()) {
                    System.out.println("\nn = " + n + ":");
                    if (!addedEdges.isEmpty()) {
                        System.out.println("Added: " + addedEdges);
                    }
                    if (!removedEdges.isEmpty()) {
                        System.out.println("Removed: " + removedEdges);
                    }
                }
            }
            previousResult = resultGraph;
        }
        System.out.println("Final graph = " + previousResult);
    }

    public void testCites() {
        String citesString = "164\nABILITY\tGPQ\tPREPROD\tQFJ\tSEX\tCITES\tPUBS\n1.0\n.62\t1.0\n.25\t.09\t1.0\n.16\t.28\t.07\t1.0\n-.10\t.00\t.03\t.10\t1.0\n.29\t.25\t.34\t.37\t.13\t1.0\n.18\t.15\t.19\t.41\t.43\t.55\t1.0";
        int length = citesString.length();
        char[] citesChars = citesString.toCharArray();
        DataReader reader = new DataReader();
        CovarianceMatrix dataSet = reader.parseCovariance(citesChars);
        System.out.println(dataSet);
        Knowledge knowledge = new Knowledge();
        knowledge.addToTier(1, "ABILITY");
        knowledge.addToTier(2, "GPQ");
        knowledge.addToTier(3, "QFJ");
        knowledge.addToTier(3, "PREPROD");
        knowledge.addToTier(4, "SEX");
        knowledge.addToTier(5, "PUBS");
        knowledge.addToTier(6, "CITES");
        Iterator<KnowledgeEdge> iterator = knowledge.forbiddenEdgesIterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
        Pc pc = new Pc(new IndTestFisherZ(dataSet, 0.11));
        pc.setKnowledge(knowledge);
        Graph pattern = pc.search();
        System.out.println("Pattern = " + pattern);
    }

    private void checkSearch(String inputGraph, String outputGraph) {
        Graph graph = GraphConverter.convert(inputGraph);
        IndTestDSep independence = new IndTestDSep(graph);
        Pc cpcMb = new Pc(independence);
        Graph resultGraph = cpcMb.search();
        Graph trueGraph = GraphConverter.convert(outputGraph);
        System.out.println("\nInput graph:");
        System.out.println(graph);
        System.out.println("\nResult graph:");
        System.out.println(resultGraph);
        System.out.println("\nTrue graph:");
        System.out.println(trueGraph);
        TestPc.assertTrue(((Object)resultGraph).equals(trueGraph));
    }

    private void checkSearch2(String inputGraph, String outputGraph) {
        Graph graph = GraphConverter.convert(inputGraph);
        SemPm semPm = new SemPm(graph);
        SemIm semIM = new SemIm(semPm);
        DataSet dataSet = semIM.simulateData(1000, false);
        IndTestFisherZ independence = new IndTestFisherZ(dataSet, 0.05);
        Pc pcSearch = new Pc(independence);
        Graph resultGraph = pcSearch.search();
        Graph trueGraph = GraphConverter.convert(outputGraph);
        System.out.println("\nInput graph:");
        System.out.println(graph);
        System.out.println("\nResult graph:");
        System.out.println(resultGraph);
        System.out.println("\nTrue graph:");
        System.out.println(trueGraph);
        TestPc.assertTrue(((Object)resultGraph).equals(trueGraph));
    }

    private void checkWithKnowledge(String inputGraph, String outputGraph, Knowledge knowledge) {
        Graph graph = GraphConverter.convert(inputGraph);
        SemPm semPm = new SemPm(graph);
        SemIm semIM = new SemIm(semPm);
        DataSet dataSet = semIM.simulateData(1000, false);
        IndTestFisherZ independence = new IndTestFisherZ(dataSet, 0.001);
        Pc pcSearch = new Pc(independence);
        pcSearch.setKnowledge(knowledge);
        Graph resultGraph = pcSearch.search();
        GraphConverter.convert(outputGraph);
        System.out.println(knowledge);
        System.out.println("\nInput graph:");
        System.out.println(graph);
        System.out.println("\nResult graph:");
        System.out.println(resultGraph);
    }

    public void rtest5() {
        Dag graph = GraphUtils.randomDag(20, 0, 20, 3, 2, 2, false);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        DataSet dataSet = im.simulateData(1000, false);
        IndTestFisherZ test = new IndTestFisherZ(dataSet, 0.05);
        this.allAtDepth(test, 3);
    }

    private void allAtDepth(IndependenceTest test, int depth) {
        ArrayList<Double> pValues = new ArrayList<Double>();
        LinkedList<Node> nodes = new LinkedList<Node>(test.getVariables());
        for (int d = 0; d <= depth; ++d) {
            for (Node x : nodes) {
                for (Node y : nodes) {
                    int[] choice;
                    if (x == y) continue;
                    ChoiceGenerator cg = new ChoiceGenerator(nodes.size(), d);
                    while ((choice = cg.next()) != null) {
                        List<Node> condSet = SearchGraphUtils.asList(choice, nodes);
                        if (condSet.contains(x) || condSet.contains(y)) continue;
                        test.isIndependent(x, y, condSet);
                        pValues.add(test.getPValue());
                        double[] p = new double[pValues.size()];
                        for (int t = 0; t < p.length; ++t) {
                            p[t] = (Double)pValues.get(t);
                        }
                        System.out.println("FDR cutoff = " + StatUtils.fdr(test.getAlpha(), p, false));
                    }
                }
            }
        }
    }

    public void rtestLargeSemPc() {
        TetradLogger.getInstance().setForceLog(false);
        System.out.println("Graph");
        Dag dag = GraphUtils.randomDag(1000, 2000, false);
        System.out.println("Data");
        LargeSemSimulator simulator = new LargeSemSimulator(dag);
        DataSet data = simulator.simulateDataAcyclic(300);
        long time0 = System.currentTimeMillis();
        System.out.println("Test");
        IndTestFisherZOnTheFly test = new IndTestFisherZOnTheFly(data, 0.001);
        System.out.println("PC");
        Mbfs mbfs = new Mbfs(test, 2);
        String name = test.getVariables().get(0).getName();
        System.out.println(name);
        Graph graph = mbfs.search(name);
        long time1 = System.currentTimeMillis();
        System.out.println("Output");
        System.out.println(graph.getNumEdges());
        System.out.println("Elapsed time = " + (double)(time1 - time0) / 1000.0 + " s");
    }

    public static Test suite() {
        return new TestSuite(TestPc.class);
    }
}

