/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.PlusMult;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Ricf;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRicf
extends TestCase {
    public TestRicf(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public void testRicf1() {
        String[] varNames = new String[]{"y", "x", "z", "u"};
        int numVars = varNames.length;
        double[] values = new double[]{2.93, -1.7, 0.76, -0.06, -1.7, 1.64, -0.78, 0.1, 0.76, -0.78, 1.66, -0.78, -0.06, 0.1, -0.78, 0.81};
        DoubleMatrix2D m = this.matrix(values, numVars, numVars);
        CovarianceMatrix s = new CovarianceMatrix(DataUtils.createContinuousVariables(varNames), m, 30);
        System.out.println(s);
        EdgeListGraph mag = new EdgeListGraph();
        ContinuousVariable x = new ContinuousVariable("x");
        ContinuousVariable y = new ContinuousVariable("y");
        ContinuousVariable z = new ContinuousVariable("z");
        ContinuousVariable u = new ContinuousVariable("u");
        mag.addNode(x);
        mag.addNode(y);
        mag.addNode(z);
        mag.addNode(u);
        mag.addDirectedEdge(y, x);
        mag.addBidirectedEdge(x, z);
        mag.addDirectedEdge(u, z);
        System.out.println(mag);
        int n = 100;
        double tol = 1.0E-6;
        Ricf ricf = new Ricf();
        Ricf.RicfResult ricfResult = ricf.ricf(mag, s, n, tol);
        System.out.println(ricfResult);
        double[] shatValues = new double[]{2.93, -1.434425, 0.0, 0.0, -1.434425, 1.379968, -0.343037, 0.0, 0.0, -0.343037, 1.594307, -0.744252, 0.0, 0.0, -0.744252, 0.81};
        double norm = this.normdiff(ricfResult, shatValues, numVars, numVars);
        TestRicf.assertTrue(norm < 1.0E-4);
        mag.removeEdges(mag.getEdges());
        mag.addBidirectedEdge(y, x);
        mag.addBidirectedEdge(x, z);
        mag.addBidirectedEdge(u, z);
        System.out.println(mag);
        Ricf.RicfResult ricfResult2 = ricf.ricf(mag, s, n, tol);
        System.out.println(ricfResult2);
        norm = this.normdiff(ricfResult, shatValues, numVars, numVars);
        TestRicf.assertTrue(norm < 1.0E-4);
    }

    private double normdiff(Ricf.RicfResult ricfResult, double[] shatValues, int rows, int cols) {
        DoubleMatrix2D shat = this.matrix(shatValues, rows, cols);
        DoubleMatrix2D diff = shat.copy();
        diff.assign(ricfResult.getShat(), PlusMult.plusMult(-1.0));
        return new Algebra().norm1(diff);
    }

    private DoubleMatrix2D matrix(double[] values, int rows, int cols) {
        DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, cols);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                m.set(i, j, values[i + cols * j]);
            }
        }
        return m;
    }

    public void testCliques() {
        EdgeListGraph graph = new EdgeListGraph();
        ContinuousVariable x0 = new ContinuousVariable("X0");
        ContinuousVariable x1 = new ContinuousVariable("X1");
        ContinuousVariable x2 = new ContinuousVariable("X2");
        ContinuousVariable x3 = new ContinuousVariable("X3");
        ContinuousVariable x4 = new ContinuousVariable("X4");
        ContinuousVariable x5 = new ContinuousVariable("X5");
        graph.addNode(x0);
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addUndirectedEdge(x0, x1);
        graph.addUndirectedEdge(x0, x2);
        graph.addUndirectedEdge(x0, x3);
        graph.addUndirectedEdge(x1, x2);
        graph.addUndirectedEdge(x1, x3);
        graph.addUndirectedEdge(x1, x4);
        graph.addUndirectedEdge(x2, x4);
        graph.addUndirectedEdge(x5, x0);
        graph.addUndirectedEdge(x5, x1);
        graph.addUndirectedEdge(x5, x2);
        List<List<Node>> cliques = new Ricf().cliques(graph);
        System.out.println(cliques);
    }

    public void testCliques2() {
        Dag graph = GraphUtils.randomDag(8, 0, 20, 5, 5, 5, false);
        List<List<Node>> cliques = new Ricf().cliques(graph);
        System.out.println(graph);
        System.out.println(cliques);
    }

    public void testCliques3() {
        EdgeListGraph graph = new EdgeListGraph();
        ContinuousVariable x1 = new ContinuousVariable("X1");
        ContinuousVariable x2 = new ContinuousVariable("X2");
        ContinuousVariable x3 = new ContinuousVariable("X3");
        ContinuousVariable x4 = new ContinuousVariable("X4");
        ContinuousVariable x5 = new ContinuousVariable("X5");
        ContinuousVariable x6 = new ContinuousVariable("X6");
        ContinuousVariable x7 = new ContinuousVariable("X7");
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addNode(x6);
        graph.addNode(x7);
        graph.addUndirectedEdge(x1, x2);
        graph.addUndirectedEdge(x1, x4);
        graph.addUndirectedEdge(x2, x3);
        graph.addUndirectedEdge(x2, x5);
        graph.addUndirectedEdge(x3, x5);
        graph.addUndirectedEdge(x4, x5);
        graph.addUndirectedEdge(x5, x6);
        List<List<Node>> cliques = new Ricf().cliques(graph);
        System.out.println(cliques);
    }

    public static Test suite() {
        return new TestSuite(TestRicf.class);
    }
}

