/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica;

import edu.cmu.tetrad.search.fastica.EigenValueFilter;
import edu.cmu.tetrad.search.fastica.math.Matrix;
import edu.cmu.tetrad.search.fastica.math.Vector;
import java.util.ArrayList;

public class BelowEVFilter
implements EigenValueFilter {
    private double limit;
    private boolean relative;
    private double[] eigenValues;
    private double[][] eigenVectors;

    public BelowEVFilter(double limit, boolean relative) {
        this.limit = limit;
        this.relative = relative;
    }

    @Override
    public void passEigenValues(double[] eigenValues, double[][] eigenVectors) {
        double limit;
        if (this.relative) {
            double max = -1.0;
            for (int i = 0; i < eigenValues.length; ++i) {
                if (!(max < Math.abs(eigenValues[i]))) continue;
                max = Math.abs(eigenValues[i]);
            }
            limit = max * this.limit;
        } else {
            limit = this.limit;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < eigenValues.length; ++i) {
            if (!(Math.abs(eigenValues[i]) >= limit)) continue;
            list.add(new Integer(i));
        }
        int m = Matrix.getNumOfRows(eigenVectors);
        int n = list.size();
        this.eigenValues = Vector.newVector(n);
        this.eigenVectors = Matrix.newMatrix(m, n);
        for (int j = 0; j < n; ++j) {
            int k = (Integer)list.get(j);
            this.eigenValues[j] = eigenValues[k];
            for (int i = 0; i < m; ++i) {
                this.eigenVectors[i][j] = eigenVectors[i][k];
            }
        }
    }

    @Override
    public double[] getEigenValues() {
        return this.eigenValues;
    }

    @Override
    public double[][] getEigenVectors() {
        return this.eigenVectors;
    }
}

