/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica;

public class FastICAConfig {
    private int numICs;
    private Approach approach;
    private double stepSize;
    private double epsilon;
    private int maxIterations;
    private double[][] initialMixingMatrix;

    public FastICAConfig(int numICs, Approach approach, double stepSize, double epsilon, int maxIterations, double[][] initialMixingMatrix) {
        this.numICs = numICs;
        this.approach = approach;
        this.stepSize = stepSize;
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
        this.initialMixingMatrix = initialMixingMatrix;
    }

    public FastICAConfig(int numICs) {
        this(numICs, Approach.DEFLATION, 1.0, 1.0E-12, 1000, null);
    }

    public FastICAConfig() {
        this(1);
    }

    public int getNumICs() {
        return this.numICs;
    }

    public Approach getApproach() {
        return this.approach;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public double[][] getInitialMixingMatrix() {
        return this.initialMixingMatrix;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setNumICs(int numICs) {
        this.numICs = numICs;
    }

    public void setApproach(Approach approach) {
        this.approach = approach;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public void setInitialMixingMatrix(double[][] initialMixingMatrix) {
        this.initialMixingMatrix = initialMixingMatrix;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    public static enum Approach {
        SYMMETRIC,
        DEFLATION;

    }
}

