/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica;

import edu.cmu.tetrad.search.fastica.EigenValueFilter;
import edu.cmu.tetrad.search.fastica.FirstEVFilter;
import edu.cmu.tetrad.search.fastica.SortingEVFilter;

public class PercentageEVFilter
implements EigenValueFilter {
    private double percentage;
    private double[] eigenValues;
    private double[][] eigenVectors;

    public PercentageEVFilter(double percentage) {
        this.percentage = percentage;
    }

    @Override
    public void passEigenValues(double[] eigenValues, double[][] eigenVectors) {
        int l = eigenValues.length;
        double power = 0.0;
        for (int i = 0; i < l; ++i) {
            power += Math.abs(eigenValues[i]);
        }
        power /= 100.0;
        SortingEVFilter sevf = new SortingEVFilter(true, true);
        sevf.passEigenValues(eigenValues, eigenVectors);
        double[] eigenValuesSorted = sevf.getEigenValues();
        double[][] eigenVectorsSorted = sevf.getEigenVectors();
        double per = 0.0;
        int n = 0;
        while (per - this.percentage < 0.0) {
            per += Math.abs(eigenValuesSorted[n]) / power;
            ++n;
        }
        FirstEVFilter fevf = new FirstEVFilter(n);
        fevf.passEigenValues(eigenValuesSorted, eigenVectorsSorted);
        this.eigenValues = fevf.getEigenValues();
        this.eigenVectors = fevf.getEigenVectors();
    }

    @Override
    public double[] getEigenValues() {
        return this.eigenValues;
    }

    @Override
    public double[][] getEigenVectors() {
        return this.eigenVectors;
    }
}

