/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica;

import edu.cmu.tetrad.search.fastica.EigenValueFilter;
import edu.cmu.tetrad.search.fastica.math.Matrix;
import edu.cmu.tetrad.search.fastica.math.Vector;
import java.util.Collections;
import java.util.LinkedList;

public class SortingEVFilter
implements EigenValueFilter {
    private boolean descending;
    private boolean absolute;
    private double[] eigenValues;
    private double[][] eigenVectors;

    public SortingEVFilter(boolean descending, boolean absolute) {
        this.descending = descending;
        this.absolute = absolute;
    }

    @Override
    public void passEigenValues(double[] eigenValues, double[][] eigenVectors) {
        int n = eigenValues.length;
        LinkedList<Pair> list = new LinkedList<Pair>();
        int j = 0;
        while (j < n) {
            Pair pair = new Pair();
            pair.value = this.absolute ? Math.abs(eigenValues[j]) : eigenValues[j];
            pair.index = j++;
            list.add(pair);
        }
        Collections.sort(list);
        if (this.descending) {
            Collections.reverse(list);
        }
        int m = Matrix.getNumOfRows(eigenVectors);
        this.eigenValues = Vector.newVector(n);
        this.eigenVectors = Matrix.newMatrix(m, n);
        for (int j2 = 0; j2 < n; ++j2) {
            int k = ((Pair)list.get((int)j2)).index;
            this.eigenValues[j2] = eigenValues[k];
            for (int i = 0; i < m; ++i) {
                this.eigenVectors[i][j2] = eigenVectors[i][k];
            }
        }
    }

    @Override
    public double[] getEigenValues() {
        return this.eigenValues;
    }

    @Override
    public double[][] getEigenVectors() {
        return this.eigenVectors;
    }

    private class Pair
    implements Comparable<Pair> {
        public double value;
        public int index;

        private Pair() {
        }

        @Override
        public int compareTo(Pair pair) {
            return new Double(this.value).compareTo(new Double(pair.value));
        }
    }
}

