/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EigenValueDialog
extends JDialog {
    private static final long serialVersionUID = 3906082369361621299L;
    private State state;
    private boolean[] acceptanceList;
    private JCheckBox[] eigenValueCB;

    public EigenValueDialog(JFrame owner, String title, double[] eigenValues) {
        super(owner, title, true);
        int m = eigenValues.length;
        this.acceptanceList = new boolean[m];
        for (int i = 0; i < m; ++i) {
            this.acceptanceList[i] = true;
        }
        JPanel mainPn = new JPanel(new BorderLayout(4, 4));
        this.setContentPane(mainPn);
        JPanel eigenValuePn = new JPanel(new GridLayout(m, 1, 4, 4));
        mainPn.add((Component)eigenValuePn, "Center");
        this.eigenValueCB = new JCheckBox[m];
        for (int i = 0; i < m; ++i) {
            this.eigenValueCB[i] = new JCheckBox(Double.toString(eigenValues[i]), true);
            eigenValuePn.add(this.eigenValueCB[i]);
        }
        JPanel buttonPn = new JPanel();
        mainPn.add((Component)buttonPn, "South");
        JButton okBt = new JButton("  OK  ");
        okBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EigenValueDialog.this.actionOk();
            }
        });
        buttonPn.add(okBt);
        JButton cancelBt = new JButton("Cancel");
        cancelBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EigenValueDialog.this.actionCancel();
            }
        });
        buttonPn.add(cancelBt);
        mainPn.add((Component)new JLabel("  "), "North");
        mainPn.add((Component)new JLabel("  "), "West");
        mainPn.add((Component)new JLabel("  "), "East");
        this.pack();
        this.setLocation(owner.getLocation().x + 16, owner.getLocation().y + 16);
        this.setSize((int)((double)this.getSize().width * 1.1), (int)((double)this.getSize().height * 1.05));
    }

    public boolean[] getAcceptanceList() {
        return this.acceptanceList;
    }

    public boolean open() {
        this.state = State.PROCESSING;
        this.setVisible(true);
        while (this.state == State.PROCESSING) {
        }
        return this.state == State.OKAY;
    }

    private void actionOk() {
        int m = this.acceptanceList.length;
        for (int i = 0; i < m; ++i) {
            this.acceptanceList[i] = this.eigenValueCB[i].isSelected();
        }
        this.state = State.OKAY;
        this.setVisible(false);
    }

    private void actionCancel() {
        this.state = State.CANCEL;
        this.setVisible(false);
    }

    @Override
    protected void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201) {
            this.actionCancel();
        }
        super.processWindowEvent(event);
    }

    private static enum State {
        PROCESSING,
        OKAY,
        CANCEL;

    }
}

