/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica.swing;

import edu.cmu.tetrad.search.fastica.swing.FastICAFrame;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class FastICAApp {
    public static final int PREF_DIR_ADD = 0;
    private static final String[] PREF_KEYS = new String[]{"DIR_ADD"};
    private static final String[] PREF_DEFAULTS = new String[]{System.getProperty("user.home")};

    public FastICAApp() {
        FastICAFrame frame = new FastICAFrame();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        new FastICAApp();
    }

    public static void exceptionDialog(Exception exc) {
        StringWriter sw = new StringWriter();
        exc.printStackTrace(new PrintWriter(sw));
        String str = sw.toString();
        JOptionPane.showMessageDialog(null, "Error: " + str, exc.getClass().toString(), 0);
        System.err.println(str);
    }

    public static String getPreference(int pref) {
        Preferences prefs = Preferences.userNodeForPackage(FastICAApp.class);
        return prefs.get(PREF_KEYS[pref], PREF_DEFAULTS[pref]);
    }

    public static void setPreference(int pref, String value) {
        Preferences prefs = Preferences.userNodeForPackage(FastICAApp.class);
        prefs.put(PREF_KEYS[pref], value);
    }
}

