/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica.swing;

import edu.cmu.tetrad.search.fastica.BelowEVFilter;
import edu.cmu.tetrad.search.fastica.CompositeEVFilter;
import edu.cmu.tetrad.search.fastica.FastICAConfig;
import edu.cmu.tetrad.search.fastica.SortingEVFilter;
import edu.cmu.tetrad.search.fastica.TanhCFunction;
import edu.cmu.tetrad.search.fastica.math.Matrix;
import edu.cmu.tetrad.search.fastica.swing.DialogEVFilter;
import edu.cmu.tetrad.search.fastica.swing.FastICAApp;
import edu.cmu.tetrad.search.fastica.swing.FastICAThread;
import edu.cmu.tetrad.search.fastica.swing.MatrixDialog;
import edu.cmu.tetrad.search.fastica.swing.NumberDialog;
import edu.cmu.tetrad.search.fastica.util.AudioVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.LinkedList;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class FastICAFrame
extends JFrame {
    private static final long serialVersionUID = 3257285816446694454L;
    private JButton addBt;
    private JButton deleteBt;
    private JButton playBt;
    private JButton mixBt;
    private JButton analyseBt;
    private DefaultMutableTreeNode dataRootNd;
    private JTree dataTr;
    private LinkedList<LinkedList<double[]>> audioVectors = new LinkedList();
    private float audioSampleRate = 44100.0f;
    private JProgressBar statusPB;

    public FastICAFrame() {
        this.setMinimumSize(new Dimension(400, 300));
        this.setSize(new Dimension(400, 300));
        this.setTitle("FastIca for JAVA");
        this.enableEvents(64L);
        JPanel mainPn = new JPanel(new BorderLayout(4, 4));
        this.setContentPane(mainPn);
        this.dataRootNd = new DefaultMutableTreeNode("root");
        this.dataTr = new JTree(this.dataRootNd);
        this.dataTr.setRootVisible(false);
        this.dataTr.setEditable(false);
        this.dataTr.getSelectionModel().setSelectionMode(1);
        JScrollPane dataSP = new JScrollPane(this.dataTr);
        mainPn.add((Component)dataSP, "Center");
        JPanel buttonPn = new JPanel();
        mainPn.add((Component)buttonPn, "North");
        this.addBt = new JButton("  add  ");
        this.addBt.setToolTipText("Adds a signal.");
        this.addBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FastICAFrame.this.actionAdd();
            }
        });
        buttonPn.add(this.addBt);
        this.deleteBt = new JButton(" delete ");
        this.deleteBt.setToolTipText("Deletes the selected signal.");
        this.deleteBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FastICAFrame.this.actionDelete();
            }
        });
        buttonPn.add(this.deleteBt);
        this.playBt = new JButton("  play  ");
        this.playBt.setToolTipText("Plays the selected signal.");
        this.playBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FastICAFrame.this.actionPlay();
            }
        });
        buttonPn.add(this.playBt);
        this.mixBt = new JButton("  mix  ");
        this.mixBt.setToolTipText("Mixes the signals.");
        this.mixBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FastICAFrame.this.actionMix();
            }
        });
        buttonPn.add(this.mixBt);
        this.analyseBt = new JButton(" analyse ");
        this.analyseBt.setToolTipText("Starts to analyse the signals.");
        this.analyseBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FastICAFrame.this.actionAnalyse();
            }
        });
        buttonPn.add(this.analyseBt);
        this.statusPB = new JProgressBar(0, 1024);
        this.statusPB.setBorderPainted(false);
        this.statusPB.setStringPainted(true);
        mainPn.add((Component)this.statusPB, "South");
        this.setProgress(0, "Ready.");
        this.pack();
    }

    private DefaultMutableTreeNode getSelectedNode() {
        TreePath selectionPath = this.dataTr.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode selectedNd = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        if (!this.dataRootNd.isNodeDescendant(selectedNd)) {
            return null;
        }
        return selectedNd;
    }

    private int[] getNodeIndexList(DefaultMutableTreeNode node) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        while (!node.isRoot()) {
            list.addFirst(new Integer(node.getParent().getIndex(node)));
            node = (DefaultMutableTreeNode)node.getParent();
        }
        int n = list.size();
        int[] nodeList = new int[n];
        for (int i = 0; i < n; ++i) {
            nodeList[i] = (Integer)list.get(i);
        }
        return nodeList;
    }

    private void actionAdd() {
        DefaultMutableTreeNode selNd = this.getSelectedNode();
        if (selNd == null) {
            this.audioVectors.add(new LinkedList());
            DefaultMutableTreeNode newNd = new DefaultMutableTreeNode("Collection");
            this.dataRootNd.add(newNd);
            this.dataTr.scrollPathToVisible(new TreePath(newNd.getPath()));
            this.dataTr.updateUI();
        } else {
            JFileChooser fileDl;
            int[] selIdxs = this.getNodeIndexList(selNd);
            if (selIdxs.length == 1 && (fileDl = new JFileChooser(FastICAApp.getPreference(0))).showOpenDialog(this) == 0) {
                try {
                    File selFile = fileDl.getSelectedFile();
                    FastICAApp.setPreference(0, selFile.getParentFile().getAbsolutePath());
                    double[] audioVector = AudioVector.readAudioFile(selFile, this.audioSampleRate);
                    this.audioVectors.get(selIdxs[0]).add(audioVector);
                    DefaultMutableTreeNode newNd = new DefaultMutableTreeNode(selFile.getName());
                    selNd.add(newNd);
                    this.dataTr.scrollPathToVisible(new TreePath(newNd.getPath()));
                    this.dataTr.updateUI();
                }
                catch (Exception exc) {
                    FastICAApp.exceptionDialog(exc);
                }
            }
        }
    }

    private void actionDelete() {
        DefaultMutableTreeNode selNd = this.getSelectedNode();
        if (selNd != null) {
            int[] selIdxs = this.getNodeIndexList(selNd);
            if (selIdxs.length == 1) {
                this.audioVectors.remove(selIdxs[0]);
                this.dataRootNd.remove(selIdxs[0]);
                this.dataTr.updateUI();
            } else {
                ((DefaultMutableTreeNode)this.dataRootNd.getChildAt(selIdxs[0])).remove(selIdxs[1]);
                this.audioVectors.get(selIdxs[0]).remove(selIdxs[1]);
                this.dataTr.updateUI();
            }
        }
    }

    private void actionPlay() {
        int[] selIdxs;
        DefaultMutableTreeNode selNd = this.getSelectedNode();
        if (selNd != null && (selIdxs = this.getNodeIndexList(selNd)).length == 2) {
            try {
                Clip clip = AudioSystem.getClip();
                clip.open(AudioVector.toAudioInputStream(this.audioVectors.get(selIdxs[0]).get(selIdxs[1]), this.audioSampleRate));
                clip.start();
                clip.drain();
                clip.stop();
                clip.flush();
                clip.close();
            }
            catch (Exception exc) {
                FastICAApp.exceptionDialog(exc);
            }
        }
    }

    private void actionMix() {
        int n;
        MatrixDialog matrixDl;
        NumberDialog numberDl;
        LinkedList<double[]> audioList;
        int m;
        int[] selIdxs;
        DefaultMutableTreeNode selNd = this.getSelectedNode();
        if (selNd != null && (selIdxs = this.getNodeIndexList(selNd)).length == 1 && (m = (audioList = this.audioVectors.get(selIdxs[0])).size()) > 0 && (numberDl = new NumberDialog(this, "Number of output signals...", 1, 1, 32)).open() && (matrixDl = new MatrixDialog((Frame)this, "Choose the mixing matrix...", Matrix.newMatrix(m, n = numberDl.getNumber(), 0.0))).open()) {
            double[][] mixingMatrix = Matrix.transpose(matrixDl.getMatrix());
            double[][] audioMatrix = AudioVector.toMatrix((double[][])audioList.toArray((T[])new double[1][]));
            double[][] resAudioMatrix = Matrix.mult(mixingMatrix, audioMatrix);
            this.saveAudioVectors(resAudioMatrix, "Mixed Collection");
        }
    }

    private void actionAnalyse() {
        NumberDialog numberDl;
        LinkedList<double[]> audioList;
        int m;
        int[] selIdxs;
        DefaultMutableTreeNode selNd = this.getSelectedNode();
        if (selNd != null && (selIdxs = this.getNodeIndexList(selNd)).length == 1 && (m = (audioList = this.audioVectors.get(selIdxs[0])).size()) > 0 && (numberDl = new NumberDialog(this, "Number of independent components...", 1, 1, 32)).open()) {
            int ics = numberDl.getNumber();
            CompositeEVFilter filter = new CompositeEVFilter();
            filter.add(new BelowEVFilter(1.0E-12, false));
            filter.add(new SortingEVFilter(true, true));
            filter.add(new DialogEVFilter(this));
            FastICAConfig config = new FastICAConfig(ics, FastICAConfig.Approach.DEFLATION, 1.0, 1.0E-14, 400, null);
            double[][] audioMatrix = AudioVector.toMatrix((double[][])audioList.toArray((T[])new double[1][]));
            FastICAThread ficaThread = new FastICAThread(this, audioMatrix, config, new TanhCFunction(1.0), filter);
            ficaThread.start();
        }
    }

    private void actionExit() {
        System.exit(0);
    }

    @Override
    protected void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201) {
            this.actionExit();
        }
        super.processWindowEvent(event);
    }

    public void setProgress(int progressValue, String progressString) {
        this.statusPB.setValue(progressValue);
        this.statusPB.setString(progressString);
        this.statusPB.updateUI();
    }

    public void setLock(boolean lock) {
        this.addBt.setEnabled(!lock);
        this.deleteBt.setEnabled(!lock);
        this.playBt.setEnabled(!lock);
        this.mixBt.setEnabled(!lock);
        this.analyseBt.setEnabled(!lock);
    }

    public void saveAudioVectors(double[][] newAudioVectors, String newCollectionName) {
        int n = newAudioVectors.length;
        LinkedList<double[]> newAudioList = new LinkedList<double[]>();
        this.audioVectors.add(newAudioList);
        DefaultMutableTreeNode newParNd = new DefaultMutableTreeNode(newCollectionName);
        this.dataRootNd.add(newParNd);
        for (int i = 0; i < n; ++i) {
            newAudioList.add(AudioVector.normalise(newAudioVectors[i]));
            newParNd.add(new DefaultMutableTreeNode(Integer.toString(i)));
        }
        this.dataTr.updateUI();
    }
}

