/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica.swing;

import edu.cmu.tetrad.search.fastica.math.Matrix;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MatrixDialog
extends JDialog {
    private static final long serialVersionUID = 3905809656100960049L;
    private State state;
    private JTextField[][] matrixTF;
    private double[][] matrix;

    public MatrixDialog(Frame owner, String title, double[][] initMatrix) {
        super(owner, title, true);
        int m = Matrix.getNumOfRows(initMatrix);
        int n = Matrix.getNumOfColumns(initMatrix);
        this.matrix = Matrix.newMatrix(m, n);
        JPanel mainPn = new JPanel(new BorderLayout(4, 4));
        this.setContentPane(mainPn);
        JPanel matrixPn = new JPanel(new GridLayout(m, n, 4, 4));
        mainPn.add((Component)matrixPn, "Center");
        this.matrixTF = new JTextField[m][];
        for (int i = 0; i < m; ++i) {
            this.matrixTF[i] = new JTextField[n];
            for (int j = 0; j < n; ++j) {
                this.matrixTF[i][j] = new JTextField(Double.toString(initMatrix[i][j]));
                matrixPn.add(this.matrixTF[i][j]);
            }
        }
        JPanel buttonPn = new JPanel();
        mainPn.add((Component)buttonPn, "South");
        JButton randomBt = new JButton("Random");
        randomBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MatrixDialog.this.actionRandom();
            }
        });
        buttonPn.add(randomBt);
        buttonPn.add(new JLabel("  "));
        JButton okBt = new JButton("  OK  ");
        okBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MatrixDialog.this.actionOk();
            }
        });
        buttonPn.add(okBt);
        JButton cancelBt = new JButton("Cancel");
        cancelBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MatrixDialog.this.actionCancel();
            }
        });
        buttonPn.add(cancelBt);
        mainPn.add((Component)new JLabel("  "), "North");
        mainPn.add((Component)new JLabel("  "), "West");
        mainPn.add((Component)new JLabel("  "), "East");
        this.pack();
        this.setLocation(owner.getLocation().x + 16, owner.getLocation().y + 16);
        this.setSize((int)((double)this.getSize().width * 1.1), (int)((double)this.getSize().height * 1.05));
    }

    public boolean open() {
        this.state = State.PROCESSING;
        this.setVisible(true);
        while (this.state == State.PROCESSING) {
        }
        return this.state == State.OKAY;
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    private void actionRandom() {
        int m = Matrix.getNumOfRows(this.matrix);
        int n = Matrix.getNumOfColumns(this.matrix);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.matrix[i][j] = Math.random();
                this.matrixTF[i][j].setText(Double.toString(this.matrix[i][j]));
            }
        }
        this.repaint();
    }

    private void actionOk() {
        try {
            int m = Matrix.getNumOfRows(this.matrix);
            int n = Matrix.getNumOfColumns(this.matrix);
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.matrix[i][j] = Double.parseDouble(this.matrixTF[i][j].getText());
                }
            }
        }
        catch (NumberFormatException exc) {
            return;
        }
        this.state = State.OKAY;
        this.setVisible(false);
    }

    private void actionCancel() {
        this.state = State.CANCEL;
        this.setVisible(false);
    }

    @Override
    protected void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201) {
            this.actionCancel();
        }
        super.processWindowEvent(event);
    }

    private static enum State {
        PROCESSING,
        OKAY,
        CANCEL;

    }
}

