/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NumberDialog
extends JDialog {
    private static final long serialVersionUID = 3257562910472550704L;
    private State state;
    private int number;
    private JTextField numberTF;
    private int min;
    private int max;

    public NumberDialog(Frame owner, String title, int number, int min, int max) {
        super(owner, title, true);
        this.number = number;
        this.min = min;
        this.max = max;
        JPanel mainPn = new JPanel(new BorderLayout(4, 4));
        this.setContentPane(mainPn);
        this.numberTF = new JTextField(Integer.toBinaryString(number));
        mainPn.add((Component)this.numberTF, "Center");
        JPanel buttonPn = new JPanel();
        mainPn.add((Component)buttonPn, "South");
        JButton okBt = new JButton("  OK  ");
        okBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NumberDialog.this.actionOk();
            }
        });
        buttonPn.add(okBt);
        JButton cancelBt = new JButton("Cancel");
        cancelBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NumberDialog.this.actionCancel();
            }
        });
        buttonPn.add(cancelBt);
        mainPn.add((Component)new JLabel("  "), "North");
        mainPn.add((Component)new JLabel("  "), "West");
        mainPn.add((Component)new JLabel("  "), "East");
        this.pack();
        this.setLocation(owner.getLocation().x + 16, owner.getLocation().y + 16);
        this.setSize((int)((double)this.getSize().width * 1.1), (int)((double)this.getSize().height * 1.05));
    }

    public boolean open() {
        this.state = State.PROCESSING;
        this.setVisible(true);
        while (this.state == State.PROCESSING) {
        }
        return this.state == State.OKAY;
    }

    public int getNumber() {
        return this.number;
    }

    private void actionOk() {
        int temp;
        try {
            temp = Integer.parseInt(this.numberTF.getText());
        }
        catch (NumberFormatException exc) {
            return;
        }
        if (temp > this.max) {
            return;
        }
        if (temp < this.min) {
            return;
        }
        this.number = temp;
        this.state = State.OKAY;
        this.setVisible(false);
    }

    private void actionCancel() {
        this.state = State.CANCEL;
        this.setVisible(false);
    }

    @Override
    protected void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201) {
            this.actionCancel();
        }
        super.processWindowEvent(event);
    }

    private static enum State {
        PROCESSING,
        OKAY,
        CANCEL;

    }
}

