/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica.util;

import edu.cmu.tetrad.search.fastica.math.Matrix;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioBuffer {
    private double[][] data;
    private float sampleRate;

    public AudioBuffer(double[][] data, float sampleRate) {
        this.data = Matrix.clone(data);
        this.sampleRate = sampleRate;
    }

    public AudioBuffer(File file) throws IOException, UnsupportedAudioFileException {
        AudioInputStream aistream = AudioSystem.getAudioInputStream(file);
        this.sampleRate = aistream.getFormat().getSampleRate();
        int chs = aistream.getFormat().getChannels();
        AudioFormat format = new AudioFormat(this.sampleRate, 16, chs, true, true);
        DataInputStream distream = new DataInputStream(new BufferedInputStream(AudioSystem.getAudioInputStream(format, aistream)));
        int n = (int)aistream.getFrameLength();
        this.data = new double[chs][];
        for (int i = 0; i < chs; ++i) {
            this.data[i] = new double[n];
        }
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < chs; ++i) {
                this.data[i][j] = (double)distream.readShort() / 32768.0;
            }
        }
    }

    public double[][] getData() {
        return this.data;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public AudioInputStream getStream() {
        int chs = Matrix.getNumOfRows(this.data);
        int len = Matrix.getNumOfColumns(this.data);
        AudioFormat format = new AudioFormat(this.sampleRate, 16, chs, true, false);
        double max = 0.0;
        for (int i = 0; i < chs; ++i) {
            for (int j = 0; j < len; ++j) {
                if (!(Math.abs(this.data[i][j]) > max)) continue;
                max = Math.abs(this.data[i][j]);
            }
        }
        max = 32000.0 / max;
        byte[] byteArray = new byte[len * chs * 2];
        for (int j = 0; j < len; ++j) {
            for (int i = 0; i < chs; ++i) {
                int val = (int)(this.data[i][j] * max);
                if (val < 0) {
                    val = -val - 1;
                    byteArray[j * chs * 2 + i * 2] = (byte)(~(val & 0xFF));
                    byteArray[j * chs * 2 + i * 2 + 1] = (byte)(~(val >> 8));
                    continue;
                }
                byteArray[j * chs * 2 + i * 2] = (byte)(val & 0xFF);
                byteArray[j * chs * 2 + i * 2 + 1] = (byte)(val >> 8);
            }
        }
        AudioInputStream stream = new AudioInputStream(new ByteArrayInputStream(byteArray), format, len);
        return stream;
    }
}

