/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.mb;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.GesOrienter;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.mb.Mmmb;
import java.util.HashMap;
import java.util.List;

public class Mmhc
implements GraphSearch {
    private IndependenceTest independenceTest;
    private int depth = -1;
    private DataSet data;
    private Knowledge knowledge = new Knowledge();

    public Mmhc(IndependenceTest test) {
        this.independenceTest = test;
        this.data = (DataSet)test.getData();
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public long getElapsedTime() {
        return 0L;
    }

    @Override
    public Graph search() {
        List<Node> variables = this.independenceTest.getVariables();
        Mmmb mmmb = new Mmmb(this.independenceTest, this.getDepth(), true);
        HashMap<Node, List<Node>> pc = new HashMap<Node, List<Node>>();
        for (Node x : variables) {
            pc.put(x, mmmb.getPc(x));
        }
        EdgeListGraph graph = new EdgeListGraph();
        for (Node x : variables) {
            graph.addNode(x);
        }
        for (Node x : variables) {
            for (Node y : (List)pc.get(x)) {
                if (graph.isAdjacentTo(x, y)) continue;
                graph.addUndirectedEdge(x, y);
            }
        }
        GesOrienter orienter = new GesOrienter(this.data, this.getKnowledge());
        orienter.orient(graph);
        return graph;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }
}

