/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.mb;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MbSearch;
import edu.cmu.tetrad.search.MbUtils;
import edu.cmu.tetrad.search.Pc;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class VanderbiltInterIambnPc
implements MbSearch {
    private IndependenceTest independenceTest;
    private List<Node> variables;

    public VanderbiltInterIambnPc(IndependenceTest test) {
        if (test == null) {
            throw new NullPointerException();
        }
        this.independenceTest = test;
        this.variables = test.getVariables();
    }

    @Override
    public List<Node> findMb(String targetName) {
        Node target = this.getVariableForName(targetName);
        List<Node> cmb = new LinkedList<Node>();
        Pc pc = new Pc(this.independenceTest);
        HashSet<Node> usedVars = new HashSet<Node>();
        boolean cont = true;
        while (cont) {
            cont = false;
            LinkedList<Node> remaining = new LinkedList<Node>(this.variables);
            remaining.removeAll(cmb);
            remaining.remove(target);
            double strength = Double.NEGATIVE_INFINITY;
            Node f = null;
            for (Node v : remaining) {
                double _strength;
                if (v == target || usedVars.contains(v) || !((_strength = this.associationStrength(v, target, cmb)) > strength)) continue;
                strength = _strength;
                f = v;
            }
            if (f == null) break;
            if (!this.independenceTest.isIndependent(f, target, cmb)) {
                cmb.add(f);
                cont = true;
            }
            cmb.add(target);
            Graph graph = pc.search(cmb);
            cmb.remove(target);
            MbUtils.trimToMbNodes(graph, target, false);
            List<Node> newCmb = graph.getNodes();
            newCmb.remove(target);
            LinkedList<Node> diff = new LinkedList<Node>(cmb);
            diff.removeAll(newCmb);
            usedVars.addAll(diff);
            cmb = newCmb;
        }
        return cmb;
    }

    private double associationStrength(Node v, Node target, List<Node> cmb) {
        this.independenceTest.isIndependent(v, target, cmb);
        return 1.0 - this.independenceTest.getPValue();
    }

    @Override
    public String getAlgorithmName() {
        return "InterIAMBnPC";
    }

    @Override
    public int getNumIndependenceTests() {
        return 0;
    }

    private Node getVariableForName(String targetName) {
        Node target = null;
        for (Node V : this.variables) {
            if (!V.getName().equals(targetName)) continue;
            target = V;
            break;
        }
        if (target == null) {
            throw new IllegalArgumentException("Target variable not in dataset: " + targetName);
        }
        return target;
    }
}

