/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerEm;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.TetradLogger;

public class SemOptimizerNrPowell
implements SemOptimizer {
    static final long serialVersionUID = 23L;

    public static SemOptimizerNrPowell serializableInstance() {
        return new SemOptimizerNrPowell();
    }

    @Override
    public void optimize(SemIm semIm) {
        new SemOptimizerEm().optimize(semIm);
        SemFittingFunction fcn = new SemFittingFunction(semIm);
        int n = fcn.getNumParameters();
        double[][] xi = MatrixUtils.identity(n);
        double[] p = semIm.getFreeParamValues();
        double[] fret = new double[]{0.0};
        int[] iter = new int[]{0};
        double ftol = 0.001;
        this.powell(p, xi, n, ftol, iter, fret, fcn);
    }

    private void powell(double[] p, double[][] xi, int n, double ftol, int[] iter, double[] fret, FittingFunction fcn) {
        int j;
        double TINY = 1.0E-25;
        int ITMAX = 200;
        double[] pt = new double[n];
        double[] ptt = new double[n];
        double[] xit = new double[n];
        fret[0] = fcn.evaluate(p);
        for (j = 0; j < n; ++j) {
            pt[j] = p[j];
        }
        iter[0] = 0;
        while (true) {
            double t;
            double fptt;
            double fp = fret[0];
            int ibig = 0;
            double del = 0.0;
            for (int i = 0; i < n; ++i) {
                for (j = 0; j < n; ++j) {
                    xit[j] = xi[j][i];
                }
                fptt = fret[0];
                this.linmin(p, xit, n, fret, fcn);
                if (!(fptt - fret[0] > del)) continue;
                del = fptt - fret[0];
                ibig = i;
            }
            if (2.0 * (fp - fret[0]) <= ftol * (Math.abs(fp) + Math.abs(fret[0])) + TINY) {
                return;
            }
            if (iter[0] == ITMAX) {
                throw new IllegalStateException("Powell exceeding maximum number of iterations (" + ITMAX + "); unable to find extremum.");
            }
            for (j = 0; j < n; ++j) {
                ptt[j] = 2.0 * p[j] - pt[j];
                xit[j] = p[j] - pt[j];
                pt[j] = p[j];
            }
            fptt = fcn.evaluate(ptt);
            if (fptt < fp && (t = 2.0 * (fp - 2.0 * fret[0] + fptt) * (fp - fret[0] - del) * (fp - fret[0] - del) - del * (fp - fptt) * (fp - fptt)) < 0.0) {
                this.linmin(p, xit, n, fret, fcn);
                for (j = 0; j < n; ++j) {
                    xi[j][ibig] = xi[j][n - 1];
                    xi[j][n - 1] = xit[j];
                }
            }
            iter[0] = iter[0] + 1;
        }
    }

    private void linmin(double[] p, double[] xi, int n, double[] fret, FittingFunction fcn) {
        int j;
        double TOL = 2.0E-7;
        int ncom = n;
        double[] pcom = new double[n];
        double[] xicom = new double[n];
        for (j = 0; j < n; ++j) {
            pcom[j] = p[j];
            xicom[j] = xi[j];
        }
        double ax = 0.0;
        double xx = 1.0;
        double[] brakarg = new double[6];
        brakarg[0] = ax;
        brakarg[1] = xx;
        this.mnbrak(brakarg, ncom, pcom, xicom, fcn);
        ax = brakarg[0];
        xx = brakarg[1];
        double bx = brakarg[2];
        double[] brentarg = new double[5];
        brentarg[0] = ax;
        brentarg[1] = xx;
        brentarg[2] = bx;
        brentarg[3] = TOL;
        fret[0] = this.brent(brentarg, ncom, pcom, xicom, fcn);
        if (fret[0] < -900.0) {
            return;
        }
        double xmin = brentarg[4];
        for (j = 0; j < n; ++j) {
            int n2 = j;
            xi[n2] = xi[n2] * xmin;
            p[j] = p[j] + xi[j];
        }
    }

    private double f1dim(double x, int ncom, double[] pcom, double[] xicom, FittingFunction fcn) {
        double[] xt = new double[ncom];
        for (int j = 0; j < ncom; ++j) {
            xt[j] = pcom[j] + x * xicom[j];
        }
        return fcn.evaluate(xt);
    }

    private void mnbrak(double[] args, int ncom, double[] pcom, double[] xicom, FittingFunction fcn) {
        double GOLD = 1.618034;
        double GLIMIT = 100.0;
        double TINY = 1.0E-20;
        double ax = args[0];
        double bx = args[1];
        double cx = args[2];
        double fa = args[3];
        double fb = args[4];
        double fc = args[5];
        fa = this.f1dim(ax, ncom, pcom, xicom, fcn);
        fb = this.f1dim(bx, ncom, pcom, xicom, fcn);
        if (fb > fa) {
            double dum = ax;
            ax = bx;
            bx = dum;
            dum = fb;
            fb = fa;
            fa = dum;
        }
        cx = bx + GOLD * (bx - ax);
        fc = this.f1dim(cx, ncom, pcom, xicom, fcn);
        while (fb > fc) {
            double fu;
            double q = (bx - cx) * (fb - fa);
            double r = (bx - ax) * (fb - fc);
            double fm = Math.abs(q - r) > TINY ? Math.abs(q - r) : TINY;
            double s = q - r >= 0.0 ? Math.abs(fm) : -Math.abs(fm);
            double u = bx - ((bx - cx) * q - (bx - ax) * r) / (2.0 * s);
            double ulim = bx + GLIMIT * (cx - bx);
            if ((bx - u) * (u - cx) > 0.0) {
                fu = this.f1dim(u, ncom, pcom, xicom, fcn);
                if (fu < fc) {
                    ax = bx;
                    bx = u;
                    fa = fb;
                    fb = fu;
                    args[0] = ax;
                    args[1] = bx;
                    args[2] = cx;
                    args[3] = fa;
                    args[4] = fb;
                    args[5] = fc;
                    return;
                }
                if (fu > fb) {
                    cx = u;
                    fc = fu;
                    args[0] = ax;
                    args[1] = bx;
                    args[2] = cx;
                    args[3] = fa;
                    args[4] = fb;
                    args[5] = fc;
                    return;
                }
                u = cx + GOLD * (cx - bx);
                fu = this.f1dim(u, ncom, pcom, xicom, fcn);
            } else if ((cx - u) * (u - ulim) > 0.0) {
                fu = this.f1dim(u, ncom, pcom, xicom, fcn);
                if (fu < fc) {
                    bx = cx;
                    cx = u;
                    u = cx + GOLD * (cx - bx);
                    fb = fc;
                    fc = fu;
                    fu = this.f1dim(u, ncom, pcom, xicom, fcn);
                }
            } else if ((u - ulim) * (ulim - cx) >= 0.0) {
                u = ulim;
                fu = this.f1dim(u, ncom, pcom, xicom, fcn);
            } else {
                u = cx + GOLD * (cx - bx);
                fu = this.f1dim(u, ncom, pcom, xicom, fcn);
            }
            ax = bx;
            bx = cx;
            cx = u;
            fa = fb;
            fb = fc;
            fc = fu;
        }
        args[0] = ax;
        args[1] = bx;
        args[2] = cx;
        args[3] = fa;
        args[4] = fb;
        args[5] = fc;
    }

    private double brent(double[] args, int ncom, double[] pcom, double[] xicom, FittingFunction fcn) {
        double fx;
        double v;
        double e = 0.0;
        double d = 0.0;
        int ITMAX = 100;
        double CGOLD = 0.381966;
        double ZEPS = 1.0E-10;
        double ax = args[0];
        double bx = args[1];
        double cx = args[2];
        double tol = args[3];
        double xmin = args[4];
        double a = ax < cx ? ax : cx;
        double b = ax > cx ? ax : cx;
        double w = v = bx;
        double x = v;
        double fv = fx = this.f1dim(x, ncom, pcom, xicom, fcn);
        double fw = fx;
        for (int iter = 1; iter <= ITMAX; ++iter) {
            double u;
            double xm = 0.5 * (a + b);
            double tol1 = tol * Math.abs(x) + ZEPS;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                args[4] = xmin = x;
                return fx;
            }
            if (Math.abs(e) > tol1) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                }
                q = Math.abs(q);
                double etemp = e;
                e = d;
                if (Math.abs(p) >= Math.abs(0.5 * q * etemp) || p <= q * (x - a) || p >= q * (b - x)) {
                    e = x >= xm ? a - x : b - x;
                    d = CGOLD * e;
                } else {
                    d = p / q;
                    u = x + d;
                    if (u - a < tol2 || b - u < tol2) {
                        d = xm - x >= 0.0 ? Math.abs(tol1) : -Math.abs(tol1);
                    }
                }
            } else {
                e = x >= xm ? a - x : b - x;
                d = CGOLD * e;
            }
            double s = tol1 >= 0.0 ? Math.abs(d) : -Math.abs(d);
            u = Math.abs(d) >= tol1 ? x + d : x + s;
            double fu = this.f1dim(u, ncom, pcom, xicom, fcn);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                w = x;
                x = u;
                fv = fw;
                fw = fx;
                fx = fu;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || w == x) {
                v = w;
                w = u;
                fv = fw;
                fw = fu;
                continue;
            }
            if (!(fu <= fv) && v != x && v != w) continue;
            v = u;
            fv = fu;
        }
        args[4] = xmin = x;
        return fx;
    }

    static class SemFittingFunction
    implements FittingFunction {
        private final SemIm sem;

        public SemFittingFunction(SemIm sem) {
            this.sem = sem;
        }

        @Override
        public double evaluate(double[] parameters) {
            this.sem.setFreeParamValues(parameters);
            double fml = this.sem.getFml();
            TetradLogger.getInstance().log("optimization", "FML = " + fml);
            System.out.println("FML = " + fml);
            if (Double.isNaN(fml)) {
                return 10000.0;
            }
            return fml;
        }

        @Override
        public int getNumParameters() {
            return this.sem.getNumFreeParams();
        }
    }

    static interface FittingFunction {
        public double evaluate(double[] var1);

        public int getNumParameters();
    }
}

