/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerEm;
import edu.cmu.tetrad.sem.SemOptimizerPalCds;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;

public class SemOptimizerScattershot
implements SemOptimizer {
    static final long serialVersionUID = 23L;

    public static SemOptimizerScattershot serializableInstance() {
        return new SemOptimizerScattershot();
    }

    @Override
    public void optimize(SemIm semIm) {
        TetradLogger.getInstance().log("info", "Trying EM...");
        new SemOptimizerEm().optimize(semIm);
        TetradLogger.getInstance().log("info", "Trying scattershot...");
        SemFittingFunction f = new SemFittingFunction(semIm);
        double[] p = semIm.getFreeParamValues();
        double[] pRef = new double[p.length];
        do {
            System.arraycopy(p, 0, pRef, 0, p.length);
            semIm.setFreeParamValues(p);
            double width = semIm.getFml() / 40.0;
            this.iterateFindLowerRandom(f, p, width, 500);
        } while (!this.pointsEqual(p, pRef));
        semIm.setFreeParamValues(p);
    }

    private void slideIndividualParameters(FittingFunction f, double[] p, double[] pRef, double delta) {
        TetradLogger.getInstance().log("info", "Sliding parameters delta = " + delta);
        double min = f.evaluate(p);
        do {
            System.arraycopy(p, 0, pRef, 0, p.length);
            for (int i = 0; i < p.length; ++i) {
                int n = i;
                p[n] = p[n] + delta;
                double value = f.evaluate(p);
                if (value < min) {
                    TetradLogger.getInstance().log("info", "Sliding parameter " + i + " up, min = " + value);
                    min = value;
                    continue;
                }
                int n2 = i;
                p[n2] = p[n2] - 2.0 * delta;
                value = f.evaluate(pRef);
                if (value < min) {
                    TetradLogger.getInstance().log("info", "Sliding parameter " + i + " down, min = " + value);
                    min = value;
                    continue;
                }
                p[i] = pRef[i];
            }
        } while (!this.pointsEqual(p, pRef));
    }

    private double[] tryCds(SemIm semIm, double[] p) {
        semIm.setFreeParamValues(p);
        new SemOptimizerPalCds().optimize(semIm);
        return semIm.getFreeParamValues();
    }

    private void iterateFindLowerRandom(FittingFunction fcn, double[] p, double range, int iterations) {
        boolean found;
        do {
            found = false;
            try {
                found = this.findLowerRandom(fcn, p, range, iterations);
            }
            catch (Exception e) {
                return;
            }
        } while (found);
    }

    private boolean findLowerRandom(FittingFunction fcn, double[] p, double width, int numPoints) {
        double fMin = fcn.evaluate(p);
        if (Double.isNaN(fMin)) {
            throw new IllegalArgumentException("Center point must evaluate!");
        }
        double[] fixedP = new double[p.length];
        System.arraycopy(p, 0, fixedP, 0, p.length);
        double[] pTemp = new double[p.length];
        System.arraycopy(p, 0, pTemp, 0, p.length);
        for (int i = 0; i < numPoints; ++i) {
            this.randomPointAboutCenter(pTemp, fixedP, width);
            double f = fcn.evaluate(pTemp);
            if (!(f < fMin)) continue;
            fMin = f;
            System.arraycopy(pTemp, 0, p, 0, pTemp.length);
            TetradLogger.getInstance().log("optimization", "Cube width = " + width + " FML = " + f);
            return true;
        }
        return false;
    }

    private double getPartial(double fBefore, double fAfter, double[] pBefore, double[] pAfter) {
        double distance = this.distance(pBefore, pAfter);
        double height = fAfter - fBefore;
        return height / distance;
    }

    private double distance(double[] pBefore, double[] pAfter) {
        double sum = 0.0;
        for (int i = 0; i < pBefore.length; ++i) {
            double diff = pAfter[i] - pBefore[i];
            sum += diff * diff;
        }
        return Math.sqrt(sum);
    }

    private void randomPointAboutCenter(double[] pTemp, double[] fixedP, double width) {
        for (int j = 0; j < pTemp.length; ++j) {
            double v = this.getRandom().nextDouble();
            pTemp[j] = fixedP[j] + (-width / 2.0 + width * v);
        }
    }

    private boolean pointsEqual(double[] p, double[] pTemp) {
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == pTemp[i]) continue;
            return false;
        }
        return true;
    }

    private RandomUtil getRandom() {
        return RandomUtil.getInstance();
    }

    static class SemFittingFunction
    implements FittingFunction {
        private final SemIm sem;

        public SemFittingFunction(SemIm sem) {
            this.sem = sem;
        }

        @Override
        public double evaluate(double[] parameters) {
            this.sem.setFreeParamValues(parameters);
            double fml = this.sem.getFml();
            if (Double.isNaN(fml)) {
                return Double.POSITIVE_INFINITY;
            }
            return fml;
        }

        @Override
        public int getNumParameters() {
            return this.sem.getNumFreeParams();
        }
    }

    static interface FittingFunction {
        public double evaluate(double[] var1);

        public int getNumParameters();
    }
}

