/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerEm;
import edu.cmu.tetrad.util.TetradLogger;
import optimization.Uncmin_f77;
import optimization.Uncmin_methods;

public class SemOptimizerUncmin
implements SemOptimizer {
    static final long serialVersionUID = 23L;

    public static SemOptimizerUncmin serializableInstance() {
        return new SemOptimizerUncmin();
    }

    @Override
    public void optimize(SemIm semIm) {
        if (semIm == null) {
            throw new NullPointerException("SemIm must not be null.");
        }
        new SemOptimizerEm().optimize(semIm);
        UncminFittingFunction fittingFunction = new UncminFittingFunction(semIm);
        int numParams = semIm.getNumFreeParams();
        double[] init0Ind = semIm.getFreeParamValues();
        double[] init1Ind = new double[numParams + 1];
        double[] finalEst = new double[numParams + 1];
        double[] g = new double[numParams + 1];
        double[][] hessian = new double[numParams + 1][numParams + 1];
        double[] hessianDiag = new double[numParams + 1];
        for (int i = 1; i <= numParams; ++i) {
            init1Ind[i] = init0Ind[i - 1];
        }
        init1Ind[0] = 1.0;
        double[] f = new double[2];
        int[] info = new int[]{0, 1};
        double[] typsiz = new double[numParams + 1];
        double[] fscale = new double[2];
        int[] method = new int[]{0, 3};
        int[] iexp = new int[]{0, 0};
        int[] msg = new int[2];
        int[] ndigit = new int[]{0, 20};
        int[] itnlim = new int[]{0, 1500};
        int[] iagflg = new int[]{0, 0};
        int[] iahflg = new int[]{0, 0};
        double[] dlt = new double[2];
        double[] gradtl = new double[]{0.0, 1.0E-6};
        double[] stepmx = new double[2];
        double[] steptl = new double[2];
        Uncmin_f77.optif9_f77(numParams, init1Ind, fittingFunction, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl, finalEst, f, g, info, hessian, hessianDiag);
    }

    static class UncminFittingFunction
    implements Uncmin_methods {
        private SemIm sem;
        private double[] params0Ind;

        public UncminFittingFunction(SemIm sem) {
            this.sem = sem;
            this.params0Ind = new double[sem.getNumFreeParams()];
        }

        @Override
        public double f_to_minimize(double[] params1Ind) {
            System.arraycopy(params1Ind, 1, this.params0Ind(), 0, this.sem().getNumFreeParams());
            this.sem().setFreeParamValues(this.params0Ind());
            double fml = this.sem().getFml();
            TetradLogger.getInstance().log("optimization", "FML = " + fml);
            if (Double.isNaN(fml)) {
                return 10000.0;
            }
            return fml;
        }

        @Override
        public void gradient(double[] x, double[] g) {
        }

        @Override
        public void hessian(double[] x, double[][] h) {
        }

        private double[] params0Ind() {
            return this.params0Ind;
        }

        private SemIm sem() {
            return this.sem;
        }
    }
}

