/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.ConnectionFunction;
import edu.cmu.tetradapp.model.calculator.expression.Context;
import edu.cmu.tetradapp.model.calculator.expression.Expression;
import edu.cmu.tetradapp.model.calculator.parser.ExpressionParser;
import java.text.ParseException;
import java.util.ArrayList;

public class StringFunction
implements ConnectionFunction {
    private String formula;
    private Node[] inputs;
    private Expression expression;

    public StringFunction(String formula, Node ... parents) throws ParseException {
        this.formula = formula;
        ArrayList<String> varNames = new ArrayList<String>();
        for (Node node : parents) {
            varNames.add(node.getName());
        }
        ExpressionParser parser = new ExpressionParser(varNames, ExpressionParser.RestrictionType.MAY_ONLY_CONTAIN);
        this.expression = parser.parseExpression(formula);
        this.inputs = parents;
    }

    @Override
    public Node[] getInputNodes() {
        return this.inputs;
    }

    public String getFormula() {
        return this.formula;
    }

    @Override
    public double valueAt(final double ... inputValues) {
        if (inputValues == null) {
            throw new NullPointerException();
        }
        if (inputValues.length != this.inputs.length) {
            throw new NullPointerException();
        }
        return this.expression.evaluate(new Context(){

            @Override
            public Double getValue(String var) {
                for (int i = 0; i < StringFunction.this.inputs.length; ++i) {
                    Node node = StringFunction.this.inputs[i];
                    if (!var.equals(node.getName())) continue;
                    return inputValues[i];
                }
                return null;
            }
        });
    }
}

