/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.PlusMult;
import cern.jet.stat.Descriptive;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.MatrixUtils;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSemIm
extends TestCase {
    public TestSemIm(String name) {
        super(name);
    }

    public void rtestSampleVsImpliedCorrlelations() {
        Dag randomGraph = GraphUtils.randomDagC(5, 0, 8);
        SemPm semPm1 = new SemPm(randomGraph);
        SemIm semIm1 = new SemIm(semPm1);
        DataSet DataSet2 = semIm1.simulateDataReducedForm(1000, false);
        SemEstimator semEstimator = new SemEstimator(DataSet2, semPm1);
        semEstimator.estimate();
        CovarianceMatrix covMatrix = new CovarianceMatrix(DataSet2);
        System.out.println("covMatrix = " + covMatrix);
        DoubleMatrix2D implCovarC = semEstimator.getEstimatedSem().getImplCovar();
        double[][] implCovar = implCovarC.toArray();
        System.out.println("Implied covariance matrix:");
        System.out.println(MatrixUtils.toString(implCovar));
    }

    public void rtest2() {
        Graph graph = this.constructGraph1();
        SemPm semPm = new SemPm(graph);
        SemIm semIm = new SemIm(semPm);
        System.out.println(semIm);
        Node x1 = graph.getNode("X1");
        Node x2 = graph.getNode("X2");
        semIm.setEdgeCoef(x1, x2, 100.0);
        TestSemIm.assertEquals(100.0, semIm.getEdgeCoef(x1, x2));
        semIm.setErrCovar(x1, x1, 25.0);
        TestSemIm.assertEquals(25.0, semIm.getErrVar(x1));
    }

    public void test3() {
        Graph graph = this.constructGraph1();
        SemPm semPm = new SemPm(graph);
        SemIm semIm = new SemIm(semPm);
        System.out.println("Original SemIm: " + semIm);
        DataSet dataSetContColumnContinuous = semIm.simulateData(500, false);
        CovarianceMatrix covMatrix = new CovarianceMatrix(dataSetContColumnContinuous);
        SemEstimator estimator2 = new SemEstimator(covMatrix, semPm);
        estimator2.estimate();
        SemIm semIm2 = estimator2.getEstimatedSem();
        System.out.println("\nEstimated Sem #1: " + semIm2);
        SemEstimator estimator3 = new SemEstimator(covMatrix, semPm);
        estimator3.estimate();
        SemIm semIm3 = estimator3.getEstimatedSem();
        System.out.println("\nEstimated Sem #2: " + semIm3);
        SemPm semPm4 = new SemPm(graph);
        SemEstimator estimator4 = new SemEstimator(covMatrix, semPm4);
        estimator4.estimate();
        SemIm semIm4 = estimator4.getEstimatedSem();
        System.out.println("\nEstimated Sem #3: " + semIm4);
        SemPm semPm5 = new SemPm(graph);
        SemEstimator estimator5 = new SemEstimator(covMatrix, semPm5);
        estimator5.estimate();
        SemIm semIm5 = estimator5.getEstimatedSem();
        System.out.println("\nEstimated Sem #4: " + semIm5);
    }

    public void testCovariancesOfSimulated() {
        Dag randomGraph = GraphUtils.randomDagC(5, 0, 8);
        SemPm semPm1 = new SemPm(randomGraph);
        SemIm semIm1 = new SemIm(semPm1);
        DoubleMatrix2D implCovarC = semIm1.getImplCovar();
        double[][] impliedCovar = implCovarC.toArray();
        System.out.println("Implied covar of semIm = " + MatrixUtils.toString(impliedCovar));
        DataSet dataSet = semIm1.simulateDataRecursive(1000, false);
        CovarianceMatrix covMatrix = new CovarianceMatrix(dataSet);
        System.out.println("Covariance matrix of simulated data = " + covMatrix);
    }

    public void testIntercepts() {
        Dag randomGraph = GraphUtils.randomDagC(5, 0, 8);
        SemPm semPm = new SemPm(randomGraph);
        SemIm semIm = new SemIm(semPm);
        this.printIntercepts(semIm);
        semIm.setIntercept(semIm.getVariableNodes().get(0), 1.0);
        this.printIntercepts(semIm);
        semIm.setIntercept(semIm.getVariableNodes().get(1), 3.0);
        this.printIntercepts(semIm);
        semIm.setIntercept(semIm.getVariableNodes().get(2), -1.0);
        this.printIntercepts(semIm);
        semIm.setIntercept(semIm.getVariableNodes().get(3), 6.0);
        this.printIntercepts(semIm);
        TestSemIm.assertEquals(1.0, semIm.getIntercept(semIm.getVariableNodes().get(0)));
        TestSemIm.assertEquals(3.0, semIm.getIntercept(semIm.getVariableNodes().get(1)));
        TestSemIm.assertEquals(-1.0, semIm.getIntercept(semIm.getVariableNodes().get(2)));
        TestSemIm.assertEquals(6.0, semIm.getIntercept(semIm.getVariableNodes().get(3)));
        TestSemIm.assertEquals(0.0, semIm.getIntercept(semIm.getVariableNodes().get(4)));
        System.out.println(semIm);
    }

    private void printIntercepts(SemIm semIm) {
        System.out.println();
        for (int i = 0; i < 5; ++i) {
            Node node = semIm.getVariableNodes().get(i);
            System.out.println("Intercept of " + node + " = " + semIm.getIntercept(node));
        }
    }

    public void testCholesky() {
        Graph graph = this.constructGraph2();
        SemPm semPm = new SemPm(graph);
        SemIm semIm = new SemIm(semPm);
        System.out.println("Original SemIm: " + semIm);
        DataSet dataSet = semIm.simulateData(500, false);
        DoubleMatrix2D data = dataSet.getDoubleData();
        System.out.println("Data = ");
        System.out.println(data);
        double[][] a = new double[data.columns()][data.columns()];
        for (int i = 0; i < data.columns(); ++i) {
            for (int j = 0; j < data.columns(); ++j) {
                DoubleArrayList icol = new DoubleArrayList(data.viewColumn(i).toArray());
                DoubleArrayList jcol = new DoubleArrayList(data.viewColumn(j).toArray());
                a[i][j] = Descriptive.covariance(icol, jcol);
            }
        }
        System.out.println("A = ");
        System.out.println(MatrixUtils.toString(a));
        System.out.println("L = ");
        double[][] l = MatrixUtils.cholesky(a);
        System.out.println(MatrixUtils.toString(l));
        System.out.println("L' = ");
        double[][] lT = MatrixUtils.transpose(l);
        System.out.println(MatrixUtils.toString(lT));
        System.out.println("L L' = ");
        double[][] product = MatrixUtils.product(l, lT);
        System.out.println(MatrixUtils.toString(product));
        TestSemIm.assertTrue(MatrixUtils.equals(a, product, 1.0E-10));
    }

    public void test5() {
        EdgeListGraph graph = new EdgeListGraph();
        GraphNode x = new GraphNode("X");
        GraphNode y = new GraphNode("Y");
        GraphNode z = new GraphNode("Z");
        graph.addNode(x);
        graph.addNode(y);
        graph.addNode(z);
        GraphNode lx = new GraphNode("LX");
        lx.setNodeType(NodeType.LATENT);
        GraphNode ly = new GraphNode("LY");
        ly.setNodeType(NodeType.LATENT);
        GraphNode lz = new GraphNode("LZ");
        lz.setNodeType(NodeType.LATENT);
        graph.addNode(lx);
        graph.addNode(ly);
        graph.addNode(lz);
        graph.addDirectedEdge(lx, x);
        graph.addDirectedEdge(ly, y);
        graph.addDirectedEdge(lz, z);
        graph.addDirectedEdge(lx, ly);
        graph.addDirectedEdge(ly, lz);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        DataSet data = im.simulateDataReducedForm(1000, true);
        DoubleMatrix2D cov = data.getCovarianceMatrix();
        DoubleMatrix2D impliedCov = im.getImplCovar();
        System.out.println("cov = " + cov);
        System.out.println("implied cov = " + impliedCov);
    }

    public void test6() {
        DenseDoubleMatrix2D B = new DenseDoubleMatrix2D(2, 2);
        B.set(0, 0, 0.0);
        B.set(0, 1, 0.0);
        B.set(1, 0, 5.0);
        B.set(1, 1, 0.0);
        System.out.println("B = " + B);
        DoubleMatrix2D I = DoubleFactory2D.dense.identity(2);
        System.out.println("I = " + I);
        DoubleMatrix2D iMinusB = I.copy().assign(B, PlusMult.plusMult(-1.0));
        System.out.println("iMinusB = " + iMinusB);
        DoubleMatrix2D reduced = new Algebra().inverse(iMinusB);
        System.out.println("reduced form = " + reduced);
        DenseDoubleMatrix1D e = new DenseDoubleMatrix1D(2);
        e.set(0, 0.5);
        e.set(1, -2.0);
        System.out.println("e = " + e);
        DoubleMatrix1D x = new Algebra().mult(reduced, (DoubleMatrix1D)e);
        System.out.println(x);
        DoubleMatrix1D d1 = new Algebra().mult((DoubleMatrix2D)B, x);
        d1.assign(e, PlusMult.plusMult(1.0));
        System.out.println("check x = " + x);
    }

    private Graph constructGraph1() {
        EdgeListGraph graph = new EdgeListGraph();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        x1.setNodeType(NodeType.LATENT);
        x2.setNodeType(NodeType.LATENT);
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addDirectedEdge(x1, x2);
        graph.addDirectedEdge(x2, x3);
        graph.addDirectedEdge(x3, x4);
        graph.addDirectedEdge(x1, x4);
        graph.addDirectedEdge(x4, x5);
        return graph;
    }

    private Graph constructGraph2() {
        EdgeListGraph graph = new EdgeListGraph();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addDirectedEdge(x1, x2);
        graph.addDirectedEdge(x2, x3);
        graph.addDirectedEdge(x3, x4);
        graph.addDirectedEdge(x1, x4);
        graph.addDirectedEdge(x4, x5);
        return graph;
    }

    public static Test suite() {
        return new TestSuite(TestSemIm.class);
    }
}

